/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.govt.component;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.ns.sys.dto.SysUserDTO;
import java.net.HttpCookie;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class CloudreveHelper {
    private static final String COOKIE_NAME = "cloudreve-session";
    @Resource
    private SysParamsService sysParamsService;

    public String getUrl() {
        SysParamDTO sysParamDTO = this.sysParamsService.getDetail("CloudReserve", "url");
        if (sysParamDTO == null) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u4e91\u76d8\u7684url\u7cfb\u7edf\u53c2\u6570");
        }
        return sysParamDTO.getValue();
    }

    public String getVersion() {
        SysParamDTO sysParamDTO = this.sysParamsService.getDetail("CloudReserve", "version");
        if (sysParamDTO == null) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u4e91\u76d8\u7684version\u7cfb\u7edf\u53c2\u6570");
        }
        return sysParamDTO.getValue();
    }

    public String getCreate() {
        SysParamDTO sysParamDTO = this.sysParamsService.getDetail("CloudReserve", "create");
        if (sysParamDTO == null) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u4e91\u76d8\u7684create\u7cfb\u7edf\u53c2\u6570");
        }
        return sysParamDTO.getValue();
    }

    public String getSuffix() {
        SysParamDTO sysParamDTO = this.sysParamsService.getDetail("GovtCloudReve", "create");
        if (sysParamDTO == null) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u4e91\u76d8\u7684create\u7cfb\u7edf\u53c2\u6570");
        }
        return sysParamDTO.getValue();
    }

    public String getLogin() {
        SysParamDTO sysParamDTO = this.sysParamsService.getDetail("GovtCloudReve", "login");
        if (sysParamDTO == null) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u4e91\u76d8\u7684login\u7cfb\u7edf\u53c2\u6570");
        }
        return sysParamDTO.getValue();
    }

    public JSONObject create(SysUserDTO user) throws Exception {
        HttpRequest post = HttpUtil.createPost((String)(this.getUrl() + this.getVersion() + this.getCreate()));
        post.contentType("application/json");
        JSONObject jsonObject = new JSONObject();
        String userName = user.getUsername() + this.getSuffix();
        jsonObject.put("userName", (Object)userName);
        jsonObject.put("Password", (Object)userName);
        HttpResponse execute = post.body(JSONObject.toJSONString((Object)jsonObject)).execute();
        String body = execute.body();
        JSONObject object = JSONObject.parseObject((String)body);
        if (object.getInteger("code") != 0) {
            throw new Exception(object.getString("msg"));
        }
        return jsonObject;
    }

    public HttpCookie userLogin(String username, String password) {
        HttpRequest post = HttpUtil.createPost((String)(this.getUrl() + this.getVersion() + this.getLogin()));
        post.contentType("application/json");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        params.put("password", password);
        post.body(JSONObject.toJSONString(params));
        HttpResponse httpResponse = post.execute();
        this.result(httpResponse);
        return httpResponse.getCookie(COOKIE_NAME);
    }

    private JSONObject result(HttpResponse response) {
        Assert.state((boolean)response.isOk(), (String)("\u8bf7\u6c42 cloudreve \u670d\u52a1\u5668\u5931\u8d25, \u9519\u8bef\u7801 : " + response.getStatus()));
        String body = response.body();
        Assert.state((boolean)StrUtil.isNotEmpty((CharSequence)body), (String)"\u8bf7\u6c42\u7ed3\u679c\u5f02\u5e38!");
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        Assert.state((jsonObject.getInteger("code") == 0 ? 1 : 0) != 0, (String)("\u8bf7\u6c42\u5931\u8d25 : " + jsonObject.getString("msg")));
        return jsonObject;
    }
}

