
CREATE TABLE tb_govt_backlog (
	f_id varchar(40) NOT NULL,
	f_wiid varchar(40) NULL,
	f_business_type varchar(20) NOT NULL,
	f_business_type_name varchar(100) NOT NULL,
	f_xmid varchar(40) NOT NULL,
	f_xmmc varchar(200) NOT NULL,
	f_flow_type varchar(100) NOT NULL,
	f_url text NOT NULL,
	f_remark text NULL,
	f_user_id varchar(40) NOT NULL,
	f_user_name varchar(100) NOT NULL,
	f_accepted_date varchar(20) NOT NULL,
	f_step varchar(100) NULL,
	f_step_id varchar(40) NULL,
	f_send_user_id varchar(40) NULL,
	f_send_user_name varchar(100) NULL,
	f_send_step varchar(100) NULL,
	f_send_step_id varchar(40) NULL,
	f_opinion text NULL,
	f_flow_status int2 NULL,
	f_time_status int2 NOT NULL,
	f_pre_wiid varchar(40) NULL,
	f_system_name varchar(200) NULL,
	CONSTRAINT tb_govt_backlog_pkey PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_govt_backlog IS '待办事项表';

COMMENT ON COLUMN tb_govt_backlog.f_id IS '主键ID';
COMMENT ON COLUMN tb_govt_backlog.f_wiid IS '流转过程ID';
COMMENT ON COLUMN tb_govt_backlog.f_business_type IS '业务类型编码';
COMMENT ON COLUMN tb_govt_backlog.f_business_type_name IS '业务类型名称';
COMMENT ON COLUMN tb_govt_backlog.f_xmid IS '项目ID，流程实例ID';
COMMENT ON COLUMN tb_govt_backlog.f_xmmc IS '项目名称';
COMMENT ON COLUMN tb_govt_backlog.f_flow_type IS '流程类型';
COMMENT ON COLUMN tb_govt_backlog.f_url IS '处理链接';
COMMENT ON COLUMN tb_govt_backlog.f_remark IS '备注';
COMMENT ON COLUMN tb_govt_backlog.f_user_id IS '处理人ID';
COMMENT ON COLUMN tb_govt_backlog.f_user_name IS '处理人账号';
COMMENT ON COLUMN tb_govt_backlog.f_accepted_date IS '受理日期';
COMMENT ON COLUMN tb_govt_backlog.f_step IS '当前环节/岗位';
COMMENT ON COLUMN tb_govt_backlog.f_step_id IS '当前环节/岗位ID';
COMMENT ON COLUMN tb_govt_backlog.f_send_user_id IS '发送人ID';
COMMENT ON COLUMN tb_govt_backlog.f_send_user_name IS '发送人姓名';
COMMENT ON COLUMN tb_govt_backlog.f_send_step IS '发送环节/岗位';
COMMENT ON COLUMN tb_govt_backlog.f_send_step_id IS '发送环节/岗位ID';
COMMENT ON COLUMN tb_govt_backlog.f_opinion IS '意见';
COMMENT ON COLUMN tb_govt_backlog.f_flow_status IS '流程状态 0：初始化 1：进行中 2：终止  3：挂起 4：重开';
COMMENT ON COLUMN tb_govt_backlog.f_time_status IS '进度状态  0待办  1已办';
COMMENT ON COLUMN tb_govt_backlog.f_pre_wiid IS '前一个流转过程ID';
COMMENT ON COLUMN tb_govt_backlog.f_system_name IS '系统名称';