/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.govt.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.govt.entity.FunctionCollectSys;
import com.geoway.ns.govt.entity.FunctionRole;
import com.geoway.ns.govt.entity.FunctionSys;
import com.geoway.ns.govt.mapper.FunctionSysMapper;
import com.geoway.ns.govt.service.IFunctionCollectSysService;
import com.geoway.ns.govt.service.IFunctionRoleSysService;
import com.geoway.ns.govt.service.IFunctionSysService;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.utils.MyBatisQueryMapperUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FunctionSysServiceImpl
extends ServiceImpl<FunctionSysMapper, FunctionSys>
implements IFunctionSysService {
    @Autowired
    private FunctionSysMapper functionSysMapper;
    @Lazy
    private IFunctionCollectSysService functionCollectSysService;
    @Autowired
    private IFunctionRoleSysService functionRoleSysService;
    @Autowired
    private ITokenService tokenService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUp(FunctionSys functionSys) throws Exception {
        if (StrUtil.isEmpty((CharSequence)functionSys.getPid())) {
            functionSys.setPid("1");
        }
        if (StrUtil.isEmpty((CharSequence)functionSys.getName())) {
            throw new Exception("\u7cfb\u7edf\u540d\u79f0\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isNotEmpty((CharSequence)functionSys.getId())) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.ne(FunctionSys::getId, (Object)functionSys.getId());
            wrapper.eq(FunctionSys::getPid, (Object)functionSys.getPid());
            wrapper.eq(FunctionSys::getAppId, (Object)functionSys.getAppId());
            wrapper.eq(FunctionSys::getName, (Object)functionSys.getName());
            FunctionSys one = (FunctionSys)this.getOne((Wrapper)wrapper);
            if (one != null) {
                throw new Exception("\u7cfb\u7edf\u540d\u79f0\u3010" + one.getName() + "\u3011\u5df2\u5b58\u5728\uff01");
            }
            this.updateById(functionSys);
        } else {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(FunctionSys::getPid, (Object)functionSys.getPid())).eq(FunctionSys::getAppId, (Object)functionSys.getAppId())).eq(FunctionSys::getName, (Object)functionSys.getName());
            FunctionSys one = (FunctionSys)this.getOne((Wrapper)wrapper);
            if (one != null) {
                throw new Exception("\u7cfb\u7edf\u540d\u79f0\u3010" + one.getName() + "\u3011\u5df2\u5b58\u5728\uff01");
            }
            LambdaQueryWrapper wrappers = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)wrappers.eq(FunctionSys::getAppId, (Object)functionSys.getAppId())).eq(FunctionSys::getPid, (Object)functionSys.getPid());
            List list = this.list((Wrapper)wrappers);
            if (list.size() > 0) {
                functionSys.setSort(list.size());
            }
            this.save(functionSys);
        }
    }

    @Override
    public void deleteFunctionSys(String id, Integer sort, String pid) throws Exception {
        if (StrUtil.isEmpty((CharSequence)id)) {
            throw new Exception("\u4f20\u9012\u7684id\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(FunctionSys::getId, (Object)id);
        this.functionSysMapper.delete((Wrapper)wrapper);
    }

    @Override
    public IPage<FunctionSys> queryFunctionSys(String params, Integer page, Integer size, String uid, String userId, String token) throws Exception {
        if (StrUtil.isEmpty((CharSequence)params) && page == null) {
            Page pages = new Page();
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.orderByAsc(FunctionSys::getSort);
            return this.page((IPage)pages, (Wrapper)wrapper);
        }
        MyBatisQueryMapperUtil qmu = new MyBatisQueryMapperUtil();
        QueryWrapper queryWrapper = qmu.queryMapper(params, FunctionSys.class);
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        String roleIds = this.getRole(userId, token);
        if (StrUtil.isEmpty((CharSequence)uid)) {
            IPage pageInfo = this.page((IPage)pages, (Wrapper)queryWrapper);
            if (StrUtil.isNotEmpty((CharSequence)roleIds)) {
                List records = pageInfo.getRecords();
                records = records.stream().filter(a -> roleIds.indexOf(a.getId()) != -1).collect(Collectors.toList());
                pageInfo.setRecords(records);
            }
            return pageInfo;
        }
        IPage iPage = this.page((IPage)pages, (Wrapper)queryWrapper);
        FunctionCollectSys collect = (FunctionCollectSys)this.functionCollectSysService.getOne((Wrapper)new QueryWrapper().eq((Object)"f_uid", (Object)uid));
        String idInfo = "";
        if (collect != null) {
            idInfo = collect.getFunctions();
        }
        String ids = idInfo;
        List records = iPage.getRecords();
        List result = records.stream().filter(a -> ids.indexOf(a.getId()) != -1).collect(Collectors.toList());
        if (StrUtil.isNotEmpty((CharSequence)roleIds)) {
            result = result.stream().filter(a -> roleIds.indexOf(a.getId()) != -1).collect(Collectors.toList());
        }
        return iPage.setRecords(result);
    }

    @Override
    public IPage<FunctionSys> queryTree(String params, Integer page, Integer size) throws Exception {
        MyBatisQueryMapperUtil qmu = new MyBatisQueryMapperUtil();
        params = "pid_EQ_1;state_EQ_1;" + params;
        QueryWrapper queryWrapper = qmu.queryMapper(params, FunctionSys.class);
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        queryWrapper.orderByAsc((Object)"f_sort", new Object[]{"f_appid"});
        Page infos = (Page)this.page((IPage)pages, (Wrapper)queryWrapper);
        List records = infos.getRecords();
        pages.setRecords(this.getTree(records));
        return pages;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void upSort(String appId, String id, String pid, Integer sort, Integer flag) throws Exception {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        switch (flag) {
            case 1: {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.gt(FunctionSys::getSort, (Object)sort)).eq(FunctionSys::getAppId, (Object)appId)).eq(FunctionSys::getPid, (Object)pid)).orderByAsc(FunctionSys::getSort);
                List list = this.list((Wrapper)wrapper);
                if (list.size() <= 0) break;
                FunctionSys functionSys = (FunctionSys)list.get(0);
                Integer sortUp = functionSys.getSort();
                this.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"f_id", (Object)id)).set((Object)"f_sort", (Object)sortUp));
                this.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"f_id", (Object)functionSys.getId())).set((Object)"f_sort", (Object)sort));
                break;
            }
            case 2: {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lt(FunctionSys::getSort, (Object)sort)).eq(FunctionSys::getAppId, (Object)appId)).eq(FunctionSys::getPid, (Object)pid)).orderByDesc(FunctionSys::getSort);
                List lists = this.list((Wrapper)wrapper);
                if (lists.size() <= 0) break;
                FunctionSys functionSys = (FunctionSys)lists.get(0);
                Integer sortUp = functionSys.getSort();
                this.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"f_id", (Object)id)).set((Object)"f_sort", (Object)sortUp));
                this.update((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"f_id", (Object)functionSys.getId())).set((Object)"f_sort", (Object)sort));
            }
        }
    }

    @Override
    public List<String> queryIds() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{FunctionSys::getId});
        List ids = this.listObjs((Wrapper)wrapper, a -> String.valueOf(a.toString()));
        return ids;
    }

    @Override
    public void deleteByappId(String appId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(FunctionSys::getAppId, (Object)appId);
        this.functionSysMapper.delete((Wrapper)wrapper);
    }

    private List<FunctionSys> getTree(List<FunctionSys> records) {
        for (FunctionSys record : records) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            String pid = record.getId();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(FunctionSys::getPid, (Object)pid)).eq(FunctionSys::getState, (Object)1)).orderByAsc(FunctionSys::getSort);
            List list = this.list((Wrapper)wrapper);
            if (list.size() <= 0) continue;
            record.setChildren(this.getTree(list));
        }
        return records;
    }

    private String getRole(String userId, String token) throws Exception {
        String rids = "";
        SysUserDTO sysUserDTO = this.tokenService.querySysUserByUserId(token, userId);
        List roleIds = sysUserDTO.getRoles().stream().map(f -> f.getId()).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(FunctionRole::getRoleId, roleIds);
        List list = this.functionRoleSysService.list((Wrapper)wrapper);
        if (list.size() == 0) {
            return rids;
        }
        rids = ((FunctionRole)list.get(0)).getFunctions();
        if (list.size() > 1) {
            for (FunctionRole role : list) {
                rids = rids + role.getFunctions() + ",";
            }
            List<String> split = Arrays.asList(rids.split(","));
            split = split.stream().distinct().collect(Collectors.toList());
            rids = StrUtil.join((CharSequence)"", split);
        }
        return rids;
    }
}

