/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.govt.service.impl;

import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.dto.sysparam.SysParamGroupDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.ns.govt.entity.SysNews;
import com.geoway.ns.govt.mapper.SysNewsMapper;
import com.geoway.ns.govt.service.SysNewsService;
import com.geoway.ns.sys.domain.FileServerResult;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.FileUploadResponse;
import com.geoway.ns.sys.service.FileServerService;
import com.geoway.ns.sys.utils.BaseTreeUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysNewsServiceImpl
extends ServiceImpl<SysNewsMapper, SysNews>
implements SysNewsService {
    @Resource
    private SysParamsService sysParamsService;
    @Autowired
    FileServerService fileServerService;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final TreeNodeConfig treeNodeConfig = new TreeNodeConfig().setParentIdKey("pid").setWeightKey("sort").setIdKey("id");

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addSysNews(SysNews sysNews) throws Exception {
        this.judgeSameName(sysNews);
        sysNews.setCreatetime(new Date());
        Integer maxSort = ((SysNewsMapper)this.baseMapper).queryMaxSort(sysNews.getPid());
        sysNews.setSort(maxSort + 1);
        this.save(sysNews);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSysNews(SysNews sysNews) throws Exception {
        if (StrUtil.isBlank((CharSequence)sysNews.getId())) {
            throw new Exception("\u65b0\u95fb\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        this.judgeSameName(sysNews);
        this.saveOrUpdate(sysNews);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSysNews(SysNews sysNews) throws Exception {
        if (StrUtil.isBlank((CharSequence)sysNews.getId())) {
            throw new Exception("\u65b0\u95fb\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        List<String> idList = ((SysNewsMapper)this.baseMapper).queryChildrenSysNewsListById(sysNews.getId());
        if (idList != null && !idList.isEmpty()) {
            this.removeByIds(idList);
        }
    }

    @Override
    public IPage<SysNews> querySysNews(SysNews sysNews) throws Exception {
        if (ObjectUtil.isEmpty((Object)sysNews.getPage()) || ObjectUtil.isEmpty((Object)sysNews.getRows())) {
            throw new Exception("\u5206\u9875\u67e5\u8be2\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5173\u7cfb\u6e90\uff01");
        }
        Page sysNewsPage = new Page((long)sysNews.getPage().intValue(), (long)sysNews.getRows().intValue());
        return ((SysNewsMapper)this.baseMapper).querySysNews((Page<SysNews>)sysNewsPage, sysNews);
    }

    @Override
    public List<Tree<String>> querySysNewsTree(SysNews sysNews) throws IOException {
        List<Object> sysNewsTree = new ArrayList<Tree<String>>();
        List<SysNews> sysNewsList = ((SysNewsMapper)this.baseMapper).querySysNews(sysNews);
        if (sysNewsList != null && !sysNewsList.isEmpty()) {
            SysNews tempSysNews = SysNews.builder().idList(sysNewsList.stream().map(SysNews::getId).collect(Collectors.toList())).build();
            sysNewsList = ((SysNewsMapper)this.baseMapper).querySysNews(tempSysNews);
            sysNewsTree = BaseTreeUtil.listBuildTree(sysNewsList, SysNews.class, (TreeNodeConfig)this.treeNodeConfig);
        }
        return sysNewsTree;
    }

    private void buildFileTree(String rootPath, List<Tree<String>> childList, String parentId, Integer parentLevel) throws IOException {
        File rootDir = new File(rootPath);
        if (!rootDir.exists()) {
            System.err.println("\u76ee\u5f55\u4e0d\u5b58\u5728\uff1a" + rootPath);
            return;
        }
        if (!rootDir.isDirectory()) {
            System.err.println("\u4e0d\u662f\u5408\u6cd5\u76ee\u5f55\uff1a" + rootPath);
            return;
        }
        if (!rootDir.canRead()) {
            System.err.println("\u65e0\u76ee\u5f55\u8bfb\u53d6\u6743\u9650\uff1a" + rootPath);
            return;
        }
        File[] files = rootDir.listFiles(file -> !file.isHidden());
        if (files == null || files.length == 0) {
            return;
        }
        for (File file2 : files) {
            String rootAbsPath;
            String fileAbsolutePath = file2.getAbsolutePath();
            String fileRelativePath = fileAbsolutePath.replace(rootAbsPath = rootDir.getAbsolutePath(), "");
            if (fileRelativePath.startsWith(File.separator)) {
                fileRelativePath = fileRelativePath.substring(1);
            }
            String nodeId = fileRelativePath;
            BasicFileAttributes attributes = Files.readAttributes(Paths.get(fileAbsolutePath, new String[0]), BasicFileAttributes.class, new LinkOption[0]);
            Instant createInstant = attributes.creationTime().toInstant();
            LocalDateTime createTime = LocalDateTime.ofInstant(createInstant, ZoneId.systemDefault());
            String nodeLabel = file2.getName();
            Integer nodeLevel = file2.isDirectory() ? Integer.valueOf(1) : Integer.valueOf(2);
            Tree node = new Tree();
            node.put((Object)"id", (Object)nodeId);
            node.put((Object)"title", (Object)nodeLabel);
            node.put((Object)"type", (Object)nodeLabel);
            node.put((Object)"creater", (Object)"admin");
            node.put((Object)"createtime", (Object)FORMATTER.format(createTime));
            node.put((Object)"isopen", (Object)"1");
            node.put((Object)"pid", (Object)parentId);
            node.put((Object)"level", (Object)nodeLevel);
            if (file2.isDirectory()) {
                ArrayList<Tree<String>> subChildList = new ArrayList<Tree<String>>();
                this.buildFileTree(fileAbsolutePath, subChildList, nodeId, nodeLevel);
                node.setChildren(subChildList);
            } else {
                node.put((Object)"files", (Object)("[{\"nginxUrl\":\"" + fileRelativePath + "\",\"fileName\":\"" + nodeLabel + "\",\"previewUrl\":\"" + fileAbsolutePath + "\",\"absolutePath\":\"" + fileAbsolutePath + "\",\"id\":\"" + nodeId + "\"}]"));
            }
            childList.add((Tree<String>)node);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sortSysNews(String id, Integer sortType) {
        List<SysNews> sysNewsList = ((SysNewsMapper)this.baseMapper).queryParentSysNewsListById(id);
        if (ObjectUtil.isNotEmpty(sysNewsList)) {
            boolean downFlag;
            if (sysNewsList.size() == 1) {
                return;
            }
            int index = IntStream.range(0, sysNewsList.size()).filter(i -> id.equals(((SysNews)sysNewsList.get(i)).getId())).findFirst().orElse(-1);
            boolean moveFlag = index == 0 && (sortType == 0 || sortType == 1);
            boolean bl = downFlag = index == sysNewsList.size() - 1 && (sortType == 2 || sortType == 3);
            if (moveFlag || downFlag) {
                return;
            }
            int sort = 0;
            UpdateWrapper sysNewsUpdateWrapper = new UpdateWrapper();
            if (sortType == 0 || sortType == 3) {
                String pid = sysNewsList.get(0).getPid();
                ((LambdaUpdateWrapper)sysNewsUpdateWrapper.lambda().eq(SysNews::getId, (Object)id)).eq(SysNews::getPid, (Object)pid);
            }
            switch (sortType) {
                case 0: {
                    sort = sysNewsList.get(0).getSort();
                    sysNewsUpdateWrapper.lambda().set(SysNews::getSort, (Object)(sort - 1));
                    this.update((Wrapper)sysNewsUpdateWrapper);
                    break;
                }
                case 1: {
                    sort = sysNewsList.get(index - 1).getSort();
                    sysNewsList.get(index - 1).setSort(sysNewsList.get(index).getSort());
                    sysNewsList.get(index).setSort(sort);
                    this.saveOrUpdate(sysNewsList.get(index));
                    this.saveOrUpdate(sysNewsList.get(index - 1));
                    break;
                }
                case 2: {
                    sort = sysNewsList.get(index).getSort();
                    sysNewsList.get(index).setSort(sysNewsList.get(index + 1).getSort());
                    sysNewsList.get(index + 1).setSort(sort);
                    this.saveOrUpdate(sysNewsList.get(index));
                    this.saveOrUpdate(sysNewsList.get(index + 1));
                    break;
                }
                case 3: {
                    sort = sysNewsList.get(sysNewsList.size() - 1).getSort();
                    sysNewsUpdateWrapper.lambda().set(SysNews::getSort, (Object)(sort + 1));
                    this.update((Wrapper)sysNewsUpdateWrapper);
                    break;
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONArray addSysNewsFile(String sysid, MultipartFile file, SysNews sysNews) throws Exception {
        SysNews originSysNews = (SysNews)this.getById((Serializable)((Object)sysNews.getId()));
        String serverId = this.getStorageServerId(sysid);
        FileServerResponse fileServerResponse = this.fileServerService.sendFileToServerOnSpeFolder(serverId, file, "news");
        FileUploadResponse fileUploadResponse = fileServerResponse.convertToFileUploadResponse();
        JSONArray fileArray = new JSONArray();
        if (StrUtil.isNotBlank((CharSequence)originSysNews.getFiles())) {
            fileArray = JSONArray.parseArray((String)originSysNews.getFiles());
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("absolutePath", (Object)fileUploadResponse.getAbsolutePath());
        jsonObject.put("id", (Object)IdUtil.simpleUUID());
        jsonObject.put("nginxUrl", (Object)fileUploadResponse.getRelativePath());
        jsonObject.put("fileName", (Object)sysNews.getUploadFileName());
        jsonObject.put("previewUrl", (Object)fileUploadResponse.getObjectUrl());
        fileArray.add((Object)jsonObject);
        originSysNews.setFiles(fileArray.toJSONString());
        this.saveOrUpdate(originSysNews);
        return fileArray;
    }

    @Override
    public String deleteSysNewsFile(String sysid, String id, String uuid) throws Exception {
        SysNews sysNews = (SysNews)this.getById((Serializable)((Object)id));
        if (ObjectUtil.isNull((Object)sysNews) && StrUtil.isNotBlank((CharSequence)sysNews.getFiles())) {
            String message = "\u65b0\u95fb\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!";
            throw new Exception(message);
        }
        JSONArray jsonArray = JSON.parseArray((String)sysNews.getFiles());
        if (jsonArray == null || jsonArray.size() <= 0) {
            String message = "\u8be5\u65b0\u95fb\u5bf9\u5e94\u7684\u6587\u4ef6\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!";
            throw new Exception(message);
        }
        if (StrUtil.isNotBlank((CharSequence)uuid)) {
            JSONObject jsonObject = new JSONObject();
            for (int i = 0; i < jsonArray.size(); ++i) {
                jsonObject = jsonArray.getJSONObject(i);
                if (!uuid.equals(jsonObject.get((Object)"id"))) continue;
                jsonArray.remove(i);
                break;
            }
            if (!JSONUtil.isNull((Object)jsonObject)) {
                String serverId = this.getStorageServerId(sysid);
                String path = jsonObject.get((Object)"absolutePath").toString();
                String[] strings = path.split("@");
                if (ObjectUtil.isNotEmpty((Object)strings) && strings.length > 1) {
                    this.fileServerService.deleteFile(serverId, strings[1]);
                }
            }
        } else {
            String message = "\u8be5\u65b0\u95fb\u5bf9\u5e94\u7684\u6587\u4ef6\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!";
            throw new Exception(message);
        }
        sysNews.setFiles(jsonArray.toJSONString());
        this.saveOrUpdate(sysNews);
        return jsonArray.toJSONString();
    }

    private void judgeSameName(SysNews sysNews) throws Exception {
        if (StrUtil.isBlank((CharSequence)sysNews.getPid())) {
            throw new Exception("\u65b0\u95fb\u6570\u636e\u5bf9\u5e94\u7684\u7236\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        if (ObjectUtil.isEmpty((Object)sysNews.getLevel())) {
            throw new Exception("\u65b0\u95fb\u6570\u636e\u7ea7\u522b\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        QueryWrapper sysNewsQueryWrapper = new QueryWrapper();
        sysNewsQueryWrapper.lambda().eq(SysNews::getPid, (Object)sysNews.getPid());
        if (StrUtil.isNotBlank((CharSequence)sysNews.getId())) {
            sysNewsQueryWrapper.lambda().ne(SysNews::getId, (Object)sysNews.getId());
        }
        String typeName = "";
        switch (sysNews.getLevel()) {
            case 1: {
                String string = typeName = sysNews.getPid().equals("-1") ? "\u6a21\u5757\u540d\u79f0" : "\u65b0\u95fb\u76ee\u5f55";
                if (StrUtil.isBlank((CharSequence)sysNews.getType())) {
                    throw new Exception(typeName + "\u540d\u79f0\u4e0d\u5b58\u5728!");
                }
                ((LambdaQueryWrapper)sysNewsQueryWrapper.lambda().eq(SysNews::getType, (Object)sysNews.getType())).eq(SysNews::getLevel, (Object)1);
                break;
            }
            case 2: {
                typeName = "\u65b0\u95fb\u6807\u9898";
                if (StrUtil.isBlank((CharSequence)sysNews.getTitle())) {
                    throw new Exception(typeName + "\u540d\u79f0\u4e0d\u5b58\u5728!");
                }
                ((LambdaQueryWrapper)sysNewsQueryWrapper.lambda().eq(SysNews::getTitle, (Object)sysNews.getTitle())).eq(SysNews::getLevel, (Object)2);
                break;
            }
            default: {
                throw new Exception("\u65b0\u95fb\u6570\u636e\u7c7b\u578b\u4e0d\u5b58\u5728!");
            }
        }
        long countRule = this.count((Wrapper)sysNewsQueryWrapper);
        if (countRule > 0L) {
            throw new Exception("\u65b0\u5efa\u5931\u8d25\uff1a\u5b58\u5728\u540c\u540d" + typeName + "\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
    }

    @Override
    public String getStorageServerId(String sysid) {
        SysParamDTO sysParamDTO;
        String serverId = this.fileServerService.findDefault().getId();
        SysParamGroupDTO sysParamGroupDTO = this.sysParamsService.getGroupDetail("sysNews-filestorage");
        if (sysParamGroupDTO != null && (sysParamDTO = this.sysParamsService.getDetail("sysNews-filestorage", "value")) != null) {
            JSONArray jsonArray = JSON.parseArray((String)sysParamDTO.getValue());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObj = jsonArray.getJSONObject(i);
                if (!jsonObj.getString("id").equals(sysid) || !StringUtils.isNotBlank((CharSequence)jsonObj.getString("value"))) continue;
                serverId = jsonObj.getString("value");
            }
        }
        return serverId;
    }

    @Override
    public FileServerResult getStorageServerIdByPath(String path) {
        return this.fileServerService.findFileServerByPath(path);
    }

    @Override
    public String getStorageTyep(String sysid) {
        SysParamDTO sysParamDTO;
        String type = "1";
        SysParamGroupDTO sysParamGroupDTO = this.sysParamsService.getGroupDetail("sysNews-filestorage");
        if (sysParamGroupDTO != null && (sysParamDTO = this.sysParamsService.getDetail("sysNews-filestorage", "value")) != null) {
            JSONArray jsonArray = JSON.parseArray((String)sysParamDTO.getValue());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObj = jsonArray.getJSONObject(i);
                if (!jsonObj.getString("id").equals(sysid) || !StringUtils.isNotBlank((CharSequence)jsonObj.getString("type"))) continue;
                type = jsonObj.getString("type");
            }
        }
        return type;
    }
}

