/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.govt.controller;

import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.dto.sysparam.SysParamGroupDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.ns.govt.entity.SysNews;
import com.geoway.ns.govt.service.SysNewsService;
import com.geoway.ns.sys.domain.FileServerResult;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.EasyUIResponse;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.FileUploadResponse;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.FileServerService;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.utils.FileUploadUtil;
import com.geoway.ns.sys.utils.MyRequestUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u65b0\u95fb\u901a\u77e5"})
@RequestMapping(value={"/sysNews"})
public class SysNewsController {
    @Resource
    private SysNewsService sysNewsService;
    @Resource
    private ITokenService iTokenService;
    @Autowired
    FileServerService fileServerService;
    @Autowired
    FileUploadUtil fileUploadUtil;
    @Resource
    private FileStorageService fileStorageService;
    @Resource
    private SysParamsService sysParamsService;

    @ApiOperation(value="1-\u65b0\u589e\u6570\u636e")
    @PostMapping(value={"/addSysNews"}, produces={"application/json"})
    public BaseResponse addSysNews(HttpServletRequest request, @ModelAttribute SysNews sysNews) {
        DataResponse response = new DataResponse();
        try {
            SysUserDTO sysUser = this.iTokenService.querySysUserByToken(MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request), Boolean.valueOf(true));
            sysNews.setCreater(sysUser.getUsername());
            this.sysNewsService.addSysNews(sysNews);
            response.setResult((Object)sysNews);
            response.setShowData(true);
            response.setMessage("\u65b0\u589e\u6570\u636e\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="2-\u5220\u9664\u6570\u636e")
    @PostMapping(value={"/deleteSysNews"}, produces={"application/json"})
    public BaseResponse deleteSysNews(@ModelAttribute SysNews sysNews) {
        DataResponse response = new DataResponse();
        try {
            this.sysNewsService.deleteSysNews(sysNews);
            response.setResult((Object)"\u5220\u9664\u6570\u636e\u6210\u529f\uff01");
            response.setShowData(true);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="3-\u4fee\u6539\u76ee\u5f55")
    @PostMapping(value={"/updateSysNews"}, produces={"application/json"})
    public BaseResponse updateSysNews(@ModelAttribute SysNews sysNews) {
        DataResponse response = new DataResponse();
        try {
            this.sysNewsService.updateSysNews(sysNews);
            response.setResult((Object)sysNews);
            response.setShowData(true);
            response.setMessage("\u66f4\u65b0\u6570\u636e\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="4-\u5206\u9875\u67e5\u8be2\u76ee\u5f55")
    @GetMapping(value={"/querySysNews"}, produces={"application/json"})
    public EasyUIResponse querySysNews(@ModelAttribute SysNews sysNews) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            IPage<SysNews> sysNewsPageData = this.sysNewsService.querySysNews(sysNews);
            response.setRows(sysNewsPageData.getRecords());
            response.setTotal(Long.valueOf(sysNewsPageData.getTotal()));
        }
        catch (Exception e) {
            return EasyUIResponse.buildFailuaResponse((Exception)e);
        }
        return response;
    }

    @ApiOperation(value="5-\u67e5\u8be2\u76ee\u5f55\u6811")
    @GetMapping(value={"/querySysNewsTree"}, produces={"application/json"})
    public BaseResponse querySysNewsTree(@ModelAttribute SysNews sysNews) {
        DataResponse response = new DataResponse();
        try {
            List<Tree<String>> sysNewsTree = this.sysNewsService.querySysNewsTree(sysNews);
            response.setResult(sysNewsTree);
            response.setShowData(true);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="6-\u5bf9\u6570\u636e\u8fdb\u884c\u6392\u5e8f")
    @PostMapping(value={"sortSysNews"}, produces={"application/json"})
    public BaseResponse sortSysNews(@RequestParam(value="id") String id, @RequestParam(value="sortType") Integer sortType) {
        DataResponse response = new DataResponse();
        try {
            this.sysNewsService.sortSysNews(id, sortType);
            response.setResult((Object)"\u6570\u636e\u6392\u5e8f\u64cd\u4f5c\u6210\u529f");
            response.setShowData(true);
        }
        catch (Exception ex) {
            return BaseResponse.error((Exception)ex);
        }
        return response;
    }

    @ApiOperation(value="7-\u65b0\u589e\u9644\u4ef6")
    @PostMapping(value={"/addSysNewsFile"})
    public Map<String, Object> addSysNewsFile(@RequestParam(value="sysid") String sysid, @RequestParam(value="fmFileData") MultipartFile file, @ModelAttribute SysNews sysNews) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("status", "OK");
        map.put("message", "\u65b0\u589e\u6587\u4ef6\u6210\u529f");
        try {
            if (StrUtil.isBlank((CharSequence)sysNews.getId()) || StrUtil.isBlank((CharSequence)sysNews.getUploadFileName())) {
                throw new IllegalAccessException("\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            JSONArray fileArray = this.sysNewsService.addSysNewsFile(sysid, file, sysNews);
            map.put("newsInfo", fileArray.toJSONString());
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("status", "FAILURE");
            map.put("message", "\u65b0\u589e\u6587\u4ef6\u5931\u8d25!\u539f\u56e0\u662f:" + e.getMessage());
        }
        return map;
    }

    @ApiOperation(value="8-\u4e0a\u4f20\u9644\u4ef6")
    @PostMapping(value={"/uploadSysNewsFile"})
    public BaseResponse uploadSysNewsFile(@RequestParam(value="sysid") String sysid, @RequestParam(value="file") MultipartFile file) {
        DataResponse baseObjectResponse = new DataResponse();
        try {
            String serverId = this.sysNewsService.getStorageServerId(sysid);
            FileServerResponse fileServerResponse = this.fileServerService.sendFileToServerOnSpeFolder(serverId, file, "news");
            FileUploadResponse fileUploadResponse = fileServerResponse.convertToFileUploadResponse();
            baseObjectResponse.setResult((Object)fileUploadResponse);
            baseObjectResponse.setShowData(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)e.getMessage());
        }
        return baseObjectResponse;
    }

    @ApiOperation(value="9-\u4e0b\u8f7d\u9644\u4ef6")
    @GetMapping(value={"/downloadSysNewsFile"})
    public void downloadSysNewsFile(@RequestParam(value="sysid") String sysid, @RequestParam(value="absolutePath") String absolutePath, HttpServletRequest request, HttpServletResponse response) {
        try {
            FileServerResult fileServerResult = this.sysNewsService.getStorageServerIdByPath(absolutePath);
            if (fileServerResult.getFileServer() != null) {
                this.fileStorageService.downloadFile(fileServerResult.getFileServer().getId(), absolutePath, request, response);
            } else {
                String serverId = this.sysNewsService.getStorageServerId(sysid);
                this.fileStorageService.downloadFile(serverId, absolutePath, request, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ApiOperation(value="10-\u5220\u9664\u9644\u4ef6")
    @PostMapping(value={"/deleteSysNewsFile"})
    public Map<String, Object> deleteSysNewsFile(@RequestParam(value="sysid") String sysid, @RequestParam(value="id") String id, @RequestParam(value="uuid") String uuid, @RequestParam(value="path", required=false) String path, @RequestParam(value="name", required=false) String name) {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>(4);
        rtnMap.put("status", "OK");
        rtnMap.put("message", "\u5220\u9664\u6587\u4ef6\u6210\u529f");
        try {
            String newsInfo = this.sysNewsService.deleteSysNewsFile(sysid, id, uuid);
            rtnMap.put("newsInfo", newsInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            rtnMap.put("status", "FAILURE");
            rtnMap.put("message", "\u5220\u9664\u6587\u4ef6\u5931\u8d25!\u539f\u56e0\u662f:" + e.getMessage());
        }
        return rtnMap;
    }

    @ApiOperation(value="11-\u8be6\u60c5")
    @RequestMapping(value={"/detail"}, method={RequestMethod.GET})
    public BaseResponse detail(@RequestParam(value="id") String id) {
        DataResponse responseDataBase = new DataResponse();
        try {
            responseDataBase.setResult(this.sysNewsService.getById((Serializable)((Object)id)));
            responseDataBase.setShowData(true);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return responseDataBase;
    }

    @ApiOperation(value="12-\u8bfb\u53d6\u5bf9\u8c61\u5b58\u50a8\u914d\u7f6e")
    @GetMapping(value={"/filestorage/list"})
    public Response<List<DataSourceDTO>> filestorageList(@RequestParam(required=false) String sysid, @RequestParam(required=false) String types, @RequestParam(required=false) String keyword, @RequestParam(required=false) String category) {
        SysParamDTO sysParamDTO;
        List sourceTypes = null;
        if (StringUtil.isNotEmpty((String)types)) {
            sourceTypes = StringUtil.split((String)types, (String)",", t -> DataSourceTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        }
        List databaseDTOList = this.fileStorageService.listFileStorage(sourceTypes, keyword, category);
        SysParamGroupDTO sysParamGroupDTO = this.sysParamsService.getGroupDetail("sysNews-filestorage");
        if (sysParamGroupDTO != null && (sysParamDTO = this.sysParamsService.getDetail("sysNews-filestorage", "value")) != null) {
            JSONArray jsonArray = JSON.parseArray((String)sysParamDTO.getValue());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObj = jsonArray.getJSONObject(i);
                if (!jsonObj.getString("id").equals(sysid)) continue;
                databaseDTOList.forEach(p -> {
                    p.setIsDefault(Boolean.valueOf(false));
                    if (p.getKey().equals(jsonObj.getString("value"))) {
                        p.setIsDefault(Boolean.valueOf(true));
                    }
                });
            }
        }
        return Response.ok((Object)databaseDTOList);
    }

    @ApiOperation(value="13-\u8bbe\u7f6e\u5bf9\u8c61\u5b58\u50a8\u914d\u7f6e")
    @PostMapping(value={"/filestorage/default"})
    public Response filestorageDefault(@RequestParam(value="value") String value) {
        DataResponse responseDataBase = new DataResponse();
        try {
            Long groupId = 0L;
            SysParamGroupDTO sysParamGroupDTO = this.sysParamsService.getGroupDetail("sysNews-filestorage");
            if (sysParamGroupDTO == null) {
                SysParamGroupDTO groupDTO = new SysParamGroupDTO();
                groupDTO.setKey("sysNews-filestorage");
                groupDTO.setName("\u901a\u77e5\u516c\u544a-\u5b58\u50a8\u6a21\u5f0f");
                groupId = this.sysParamsService.addParamGroup(groupDTO);
            } else {
                groupId = sysParamGroupDTO.getId();
            }
            SysParamDTO sysParamDTO = this.sysParamsService.getDetail("sysNews-filestorage", "value");
            if (sysParamDTO == null) {
                SysParamDTO paramDTO = new SysParamDTO();
                paramDTO.setDesc("json\u683c\u5f0f\u5b58\u50a8\uff0c\u6a21\u5757\u5b58\u50a8\u914d\u7f6e");
                paramDTO.setGroupId(groupId);
                paramDTO.setGroupKey("sysNews-filestorage");
                paramDTO.setKey("value");
                paramDTO.setValue(value);
                this.sysParamsService.addSysParam(paramDTO);
            } else {
                sysParamDTO.setValue(value);
                this.sysParamsService.updateSysParam(sysParamDTO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
        return Response.ok();
    }

    @ApiOperation(value="14-\u9884\u89c8\u6587\u4ef6")
    @GetMapping(value={"/filestorage/view"})
    public void viewFile(@RequestParam(required=false) String sysid, String filePath, HttpServletRequest request, HttpServletResponse response) {
        FileServerResult fileServerResult = this.sysNewsService.getStorageServerIdByPath(filePath);
        if (fileServerResult.getFileServer() != null) {
            this.fileStorageService.viewFile(fileServerResult.getFileServer().getId(), fileServerResult.getPath(), request, response);
        } else {
            String serverId = this.sysNewsService.getStorageServerId(sysid);
            this.fileStorageService.viewFile(serverId, filePath, request, response);
        }
    }
}

