/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.hztj.controller;

import cn.hutool.core.util.StrUtil;
import com.geoway.ns.hztj.domain.Hztj;
import com.geoway.ns.hztj.service.HztjService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.google.gson.Gson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u6c47\u603b\u7edf\u8ba1"})
@Controller
@RequestMapping(value={"/hztj"})
public class HztjController {
    private static final Logger log = LoggerFactory.getLogger(HztjController.class);
    @Autowired
    private HztjService hztjService;

    @ApiOperation(value="\u5220\u9664\u6c47\u603b\u7edf\u8ba1\u4e00\u6761\u8bb0\u5f55")
    @RequestMapping(value={"/deleteById.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deleteById(HttpServletRequest request, @RequestParam(value="id") String id) {
        BaseResponse response = new BaseResponse();
        try {
            this.hztjService.deleteOne(id);
        }
        catch (Exception ex) {
            return BaseResponse.error((Exception)ex);
        }
        return response;
    }

    @ApiOperation(value="\u5217\u8868\u76ee\u5f55\u6811\u67e5\u8be2")
    @RequestMapping(value={"/listTree.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse listTree(HttpServletRequest request, @RequestParam(value="filterParam", required=false) String filterParam) {
        DataResponse response = new DataResponse();
        try {
            if (StrUtil.isBlank((CharSequence)filterParam)) {
                filterParam = "";
            }
            String sortParam = "SORT_sort_ASC";
            List<Hztj> catalogs = this.hztjService.queryByFilter(filterParam, sortParam);
            response.setResult(catalogs);
        }
        catch (Exception ex) {
            return BaseResponse.error((Exception)ex);
        }
        return response;
    }

    @ApiOperation(value="\u4fee\u6539\u6c47\u603b\u7edf\u8ba1\u4e00\u6761\u8bb0\u5f55")
    @RequestMapping(value={"/addClassify.do"}, method={RequestMethod.POST}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public void addClassify(HttpServletResponse httpResponse, @ModelAttribute Hztj rsClassify) {
        BaseResponse response = new BaseResponse();
        try {
            this.hztjService.saveOne(rsClassify);
        }
        catch (Exception ex) {
            response.setMessage(ex.getMessage());
            response.setStatus("FAILURE");
        }
        try {
            Gson gson = new Gson();
            String jsonResult = gson.toJson((Object)response);
            httpResponse.getWriter().write(jsonResult);
            httpResponse.getWriter().flush();
        }
        catch (Exception ex) {
            log.debug(ex.getMessage());
        }
    }

    @ApiOperation(value="\u6392\u5e8f")
    @RequestMapping(value={"/sort.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse sort(HttpServletRequest request, String id, String sortType) {
        BaseResponse response = new BaseResponse();
        try {
            this.hztjService.sort(id, Integer.parseInt(sortType));
        }
        catch (Exception ex) {
            return BaseResponse.error((Exception)ex);
        }
        return response;
    }

    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4")
    @RequestMapping(value={"/setDefault.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse setDefault(HttpServletRequest request, @RequestParam(value="id") String id) {
        BaseResponse response = new BaseResponse();
        try {
            this.hztjService.setDefault(id);
        }
        catch (Exception ex) {
            return BaseResponse.error((Exception)ex);
        }
        return response;
    }

    @ApiOperation(value="\u975e\u6811\u5217\u8868")
    @RequestMapping(value={"/listNoTree.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse listNoTree(HttpServletRequest request, @RequestParam(value="filterParam", required=false) String filterParam) {
        DataResponse response = new DataResponse();
        try {
            if (StrUtil.isBlank((CharSequence)filterParam)) {
                filterParam = "";
            }
            String sortParam = "SORT_sort_ASC";
            List<Hztj> catalogs = this.hztjService.queryByFilterNoTree(filterParam, sortParam);
            response.setResult(catalogs);
        }
        catch (Exception ex) {
            return BaseResponse.error((Exception)ex);
        }
        return response;
    }

    @ApiOperation(value="\u53d6\u6d88\u9ed8\u8ba4")
    @RequestMapping(value={"/cancelDefault.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse cancelDefault(HttpServletRequest request, String id) {
        BaseResponse response = new BaseResponse();
        try {
            this.hztjService.cancelSetDefault(id);
        }
        catch (Exception ex) {
            return BaseResponse.error((Exception)ex);
        }
        return response;
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/list.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse listByCatalogType(HttpServletRequest request, @RequestParam(value="filterParam", required=false) String filterParam) {
        DataResponse response = new DataResponse();
        try {
            if (StrUtil.isBlank((CharSequence)filterParam)) {
                filterParam = "";
            }
            String sortParam = "SORT_sort_ASC";
            List<Hztj> catalogs = this.hztjService.queryByFilter(filterParam, sortParam);
            response.setResult(catalogs);
        }
        catch (Exception ex) {
            return BaseResponse.error((Exception)ex);
        }
        return response;
    }

    @ApiOperation(value="\u6309\u4e0a\u7ea7\u76ee\u5f55\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/listAllByParentId.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse listAllByParentId(HttpServletRequest request, @RequestParam(value="id", required=true) String id) {
        DataResponse response = new DataResponse();
        try {
            if (StrUtil.isBlank((CharSequence)id)) {
                throw new IllegalAccessException("\u62a5\u8868\u7c7b\u578b\u4e0d\u5b58\u5728");
            }
            List<Hztj> catalogs = this.hztjService.queryByFilter(id);
            response.setResult(catalogs);
        }
        catch (Exception ex) {
            return BaseResponse.error((Exception)ex);
        }
        return response;
    }

    @ApiOperation(value="\u6309id\u67e5\u8be2")
    @RequestMapping(value={"/findById.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findById(HttpServletRequest request, @RequestParam(value="id") String id) {
        DataResponse response = new DataResponse();
        try {
            Hztj rsClassify = this.hztjService.findOne(id);
            response.setResult((Object)rsClassify);
        }
        catch (Exception ex) {
            return BaseResponse.error((Exception)ex);
        }
        return response;
    }

    @ApiOperation(value="\u6309\u964d\u5e8f\u6392\u5e8f")
    @RequestMapping(value={"/findMaxSort.json"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse findMaxSort(@RequestParam(value="pid") String pid) {
        DataResponse response = new DataResponse();
        try {
            if (pid == null) {
                pid = "-1";
            }
            int maxSort = this.hztjService.queryMaxSortByPid(pid);
            response.setResult((Object)maxSort);
        }
        catch (Exception ex) {
            return BaseResponse.error((Exception)ex);
        }
        return response;
    }
}

