/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.indicator.service.imp.contentview;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.geoway.ns.indicator.annotation.ContentViewXMAnnotation;
import com.geoway.ns.indicator.dto.XMConfig;
import com.geoway.ns.indicator.entity.TbIndexContentViewConfig;
import com.geoway.ns.indicator.service.IContentViewXM;
import com.geoway.ns.indicator.service.IContentViewXMFactory;
import com.geoway.ns.indicator.service.TbIndexContentViewConfigService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContentViewXMFactoryImpl
implements IContentViewXMFactory {
    @Autowired
    private TbIndexContentViewConfigService indexContentViewConfigService;

    @Override
    public List headerTypes() {
        Map mapContentViews = SpringUtil.getBeansOfType(IContentViewXM.class);
        JSONObject objHeaderType = null;
        ArrayList<JSONObject> lstHeaderTypes = new ArrayList<JSONObject>();
        IContentViewXM contentView = null;
        ContentViewXMAnnotation annotation = null;
        for (String key : mapContentViews.keySet()) {
            contentView = (IContentViewXM)mapContentViews.get(key);
            annotation = contentView.getClass().getAnnotation(ContentViewXMAnnotation.class);
            if (annotation == null || StringUtils.isEmpty((CharSequence)annotation.headerType())) continue;
            objHeaderType = new JSONObject();
            objHeaderType.put("name", (Object)annotation.headerType());
            objHeaderType.put("alias", (Object)annotation.headerTypeAlias());
            lstHeaderTypes.add(objHeaderType);
        }
        return lstHeaderTypes;
    }

    @Override
    public List listXM(String indexId) {
        TbIndexContentViewConfig config = this.indexContentViewConfigService.findConfig(indexId);
        if (config == null) {
            throw new RuntimeException("\u6307\u6807\u4e0d\u5b58\u5728");
        }
        IContentViewXM contentView = this.findContentView(config);
        if (contentView == null) {
            throw new RuntimeException("\u6307\u6807\u6302\u63a5\u7684\u5185\u5bb9\u67e5\u770b\u65b9\u5f0f\u4e0d\u5b58\u5728");
        }
        return contentView.listXM(config);
    }

    @Override
    public void contentByExcel(HttpServletResponse response, String indexId, String xmmc) throws Exception {
        TbIndexContentViewConfig config = this.indexContentViewConfigService.findConfig(indexId);
        if (config == null) {
            throw new RuntimeException("\u6307\u6807\u4e0d\u5b58\u5728");
        }
        IContentViewXM contentView = this.findContentView(config);
        if (contentView == null) {
            throw new RuntimeException("\u6307\u6807\u6302\u63a5\u7684\u5185\u5bb9\u67e5\u770b\u65b9\u5f0f\u4e0d\u5b58\u5728");
        }
        contentView.contentByExcel(response, config, xmmc);
    }

    private IContentViewXM findContentView(TbIndexContentViewConfig config) {
        XMConfig xmConfig = null;
        if (config.getTag() == null && !StringUtils.isEmpty((CharSequence)config.getOtherConfig())) {
            xmConfig = (XMConfig)JSON.parseObject((String)config.getOtherConfig(), XMConfig.class);
            config.setTag(xmConfig);
        }
        if (xmConfig == null || StringUtils.isEmpty((CharSequence)xmConfig.getHeaderType())) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u8868\u5934\u6837\u5f0f");
        }
        if (xmConfig == null || StringUtils.isEmpty((CharSequence)xmConfig.getXmmcFieldName())) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u9879\u76ee\u540d\u79f0\u5b57\u6bb5");
        }
        Map mapContentViews = SpringUtil.getBeansOfType(IContentViewXM.class);
        IContentViewXM contentView = null;
        ContentViewXMAnnotation annotation = null;
        for (String key : mapContentViews.keySet()) {
            contentView = (IContentViewXM)mapContentViews.get(key);
            annotation = contentView.getClass().getAnnotation(ContentViewXMAnnotation.class);
            if (annotation == null || StringUtils.isEmpty((CharSequence)annotation.headerType()) || !Objects.equals(annotation.headerType(), xmConfig.getHeaderType())) continue;
            return contentView;
        }
        return null;
    }
}

