/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.indicator.service.imp;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.indicator.annotation.ContentViewAnnotation;
import com.geoway.ns.indicator.entity.TbIndexContentViewConfig;
import com.geoway.ns.indicator.mapper.TbIndexContentViewConfigMapper;
import com.geoway.ns.indicator.service.IContentViewXM;
import com.geoway.ns.indicator.service.TbIndexContentViewConfigService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TbIndexContentViewConfigServiceImpl
extends ServiceImpl<TbIndexContentViewConfigMapper, TbIndexContentViewConfig>
implements TbIndexContentViewConfigService {
    @Override
    public TbIndexContentViewConfig findConfig(String indexId) {
        TbIndexContentViewConfig config = (TbIndexContentViewConfig)this.getOne((Wrapper)Wrappers.lambdaQuery(TbIndexContentViewConfig.class).eq(TbIndexContentViewConfig::getIndexId, (Object)indexId));
        return config;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean config(TbIndexContentViewConfig config) {
        if (config == null) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)config.getId())) {
            config.setId(UUID.randomUUID().toString());
        }
        return this.saveOrUpdate(config);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteConfig(String indexId) {
        return this.remove((Wrapper)Wrappers.lambdaQuery(TbIndexContentViewConfig.class).eq(TbIndexContentViewConfig::getIndexId, (Object)indexId));
    }

    @Override
    public List viewTypes() {
        HashMap<String, JSONObject> mapViewTypes = new HashMap<String, JSONObject>();
        Map mapContentViews = SpringUtil.getBeansOfType(IContentViewXM.class);
        JSONObject objViewType = null;
        IContentViewXM contentView = null;
        ContentViewAnnotation annotation = null;
        for (String key : mapContentViews.keySet()) {
            contentView = (IContentViewXM)mapContentViews.get(key);
            annotation = contentView.getClass().getAnnotation(ContentViewAnnotation.class);
            if (annotation == null || StringUtils.isEmpty((CharSequence)annotation.viewType()) || mapViewTypes.containsKey(annotation.viewType())) continue;
            objViewType = new JSONObject();
            objViewType.put("name", (Object)annotation.viewType());
            objViewType.put("alias", (Object)annotation.viewTypeAlias());
            mapViewTypes.put(annotation.viewType(), objViewType);
        }
        return Arrays.asList(mapViewTypes.values().toArray());
    }
}

