/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.indicator.service.imp.contentview;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.charts.dto.StatIndicatorDTO;
import com.geoway.adf.dms.charts.service.StatIndicatorService;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.ns.indicator.dto.XMConfig;
import com.geoway.ns.indicator.entity.TbIndexContentViewConfig;
import com.geoway.ns.indicator.service.IContentViewXM;
import com.geoway.ns.sys.utils.UpAndDownloadUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ResourceUtils;

public abstract class BaseContentViewXM
implements IContentViewXM {
    protected final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Resource
    protected StatIndicatorService countStatConfigService;
    @Resource
    protected DataSourceService dataSourceService;

    @Override
    public List listXM(TbIndexContentViewConfig config) {
        XMConfig xmConfig = (XMConfig)config.getTag();
        StatIndicatorDTO indicator = this.countStatConfigService.getIndicatorDetail(config.getIndexId());
        String datasetId = indicator.getDatasetId();
        QueryFilterDTO filterBasicDTO = new QueryFilterDTO();
        filterBasicDTO.setFields(xmConfig.getXmmcFieldName());
        List lstXM = this.dataSourceService.queryDataFieldUniqValues(datasetId, (QueryFilterBasicDTO)filterBasicDTO, Integer.valueOf(-1));
        return lstXM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportToExcel(HttpServletResponse response, TbIndexContentViewConfig config, String xmmc, String excelTemplate, String outExcelName) throws Exception {
        InputStream templateStream = this.getExcelTemplateStream(excelTemplate);
        String curProjectPath = System.getProperty("user.dir");
        String tempDirPath = curProjectPath + File.separator + UUID.randomUUID().toString();
        File tempDirFile = new File(tempDirPath);
        tempDirFile.mkdir();
        try {
            String outputPath = tempDirPath + File.separator + outExcelName;
            this.generateExcel(config, xmmc, templateStream, outputPath);
            UpAndDownloadUtil.downloadFile((HttpServletResponse)response, (String)outputPath);
        }
        finally {
            FileUtils.deleteQuietly((File)tempDirFile);
            if (templateStream != null) {
                templateStream.close();
            }
        }
    }

    protected InputStream getExcelTemplateStream(String excelTemplate) throws Exception {
        String curProjectPath = System.getProperty("user.dir");
        InputStream templateStream = null;
        String templatePath = curProjectPath + File.separator + excelTemplate;
        File templateFile = new File(templatePath);
        templateStream = templateFile.exists() && templateFile.isFile() ? new FileInputStream(templateFile) : ResourceUtils.getURL((String)("classpath:" + excelTemplate)).openStream();
        return templateStream;
    }

    private void generateExcel(TbIndexContentViewConfig config, String xmmc, InputStream templateStream, String outExcelPath) throws Exception {
        XMConfig xmConfig = (XMConfig)config.getTag();
        StatIndicatorDTO indicator = this.countStatConfigService.getIndicatorDetail(config.getIndexId());
        String datasetId = indicator.getDatasetId();
        QueryFilterDTO filterDTO = new QueryFilterDTO();
        List indicatorFields = ListUtil.convertAll((List)indicator.getIndicatorFields(), FieldDTO::getName);
        List groupFields = ListUtil.convertAll((List)indicator.getGroupFields(), FieldDTO::getName);
        indicatorFields.forEach(g -> {
            if (!groupFields.contains(g)) {
                groupFields.add(g);
            }
        });
        filterDTO.setFields(StringUtils.join((Iterable)groupFields, (String)","));
        filterDTO.setReturnGeometry(Boolean.valueOf(false));
        filterDTO.setReturnCount(Boolean.valueOf(false));
        filterDTO.setCondition(String.format("%s = '%s'", xmConfig.getXmmcFieldName(), xmmc));
        DataQueryResult queryResult = this.dataSourceService.queryData(datasetId, filterDTO);
        JSONObject objResult = new JSONObject();
        objResult.put("xmmc", (Object)xmmc);
        objResult.put("exportTime", (Object)this.dateFormat.format(new Date()));
        List<Map<String, Object>> lstData = this.commonConvertData(indicator, queryResult);
        this.convertUnit(indicator, lstData);
        try (ExcelWriter excelWriter = EasyExcel.write((String)outExcelPath).withTemplate(templateStream).build();){
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
            excelWriter.fill(lstData, fillConfig, writeSheet);
            excelWriter.fill((Object)objResult, writeSheet);
        }
    }

    private List<Map<String, Object>> commonConvertData(StatIndicatorDTO indicator, DataQueryResult queryResult) {
        if (queryResult.getData().size() == 0) {
            return null;
        }
        List indicatorFields = ListUtil.convertAll((List)indicator.getIndicatorFields(), FieldDTO::getName);
        indicatorFields = ListUtil.convertAll((List)indicatorFields, String::toLowerCase);
        ArrayList<Map<String, Object>> lstData = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> mapZJ = new HashMap<String, Object>();
        mapZJ.put("num", queryResult.getData().size() + 1);
        mapZJ.put("xmc", "\u603b\u8ba1");
        Map attributes = null;
        HashMap attributesLower = null;
        for (int i = 0; i < queryResult.getData().size(); ++i) {
            attributes = ((FeatureResult)queryResult.getData().get(i)).getAttributes();
            attributesLower = new HashMap();
            for (Map.Entry entry : attributes.entrySet()) {
                Double curValue;
                String entryKeyLower = ((String)entry.getKey()).toLowerCase();
                if (mapZJ.containsKey(entryKeyLower)) {
                    if (indicatorFields.contains(entryKeyLower)) {
                        curValue = 0.0;
                        if (entry.getValue() != null) {
                            curValue = Double.parseDouble(entry.getValue().toString());
                        }
                        mapZJ.put(entryKeyLower, (Double)mapZJ.get(entryKeyLower) + curValue);
                    }
                } else if (indicatorFields.contains(entryKeyLower)) {
                    curValue = 0.0;
                    if (entry.getValue() != null) {
                        curValue = Double.parseDouble(entry.getValue().toString());
                    }
                    mapZJ.put(entryKeyLower, curValue);
                } else {
                    mapZJ.put(entryKeyLower, "-");
                }
                attributesLower.put(entryKeyLower, entry.getValue());
            }
            attributesLower.put("num", i + 1);
            lstData.add(attributesLower);
        }
        lstData.add(mapZJ);
        return lstData;
    }

    private void convertUnit(StatIndicatorDTO indicator, List<Map<String, Object>> lstData) {
        List indicatorFields = ListUtil.convertAll((List)indicator.getIndicatorFields(), FieldDTO::getName);
        indicatorFields = ListUtil.convertAll((List)indicatorFields, String::toLowerCase);
        for (Map<String, Object> data : lstData) {
            for (String indicatorField : indicatorFields) {
                if (!data.containsKey(indicatorField)) continue;
                Double curValue = 0.0;
                if (data.get(indicatorField) != null) {
                    curValue = Double.parseDouble(data.get(indicatorField).toString()) / 10000.0;
                }
                data.put(indicatorField, this.setDoubleScale(curValue, 4));
            }
        }
    }

    private double setDoubleScale(double value, int scale) {
        BigDecimal bg = new BigDecimal(Double.toString(value));
        double retainedValue = bg.setScale(scale, 4).doubleValue();
        return retainedValue;
    }
}

