/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.indicator.service.imp.contentview;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.charts.dto.StatIndicatorDTO;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.ns.indicator.annotation.ContentViewAnnotation;
import com.geoway.ns.indicator.annotation.ContentViewXMAnnotation;
import com.geoway.ns.indicator.dto.XMConfig;
import com.geoway.ns.indicator.dto.XZDLHCRecord;
import com.geoway.ns.indicator.entity.TbIndexContentViewConfig;
import com.geoway.ns.indicator.service.imp.contentview.BaseContentViewXM;
import com.geoway.ns.sys.utils.UpAndDownloadUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
@ContentViewAnnotation(viewType="ByXM", viewTypeAlias="\u6309\u9879\u76ee\u5217\u8868\u5f62\u5f0f")
@ContentViewXMAnnotation(headerType="XZDLHC", headerTypeAlias="\u73b0\u72b6\u5730\u7c7b\u6838\u67e5\u7ed3\u679c")
public class XZDLHCContentViewXM
extends BaseContentViewXM {
    private final String excelTemplate = "data/template/03-XZDLHC.xlsx";
    private final String outExcelName = "\u73b0\u72b6\u5730\u7c7b\u6838\u67e5\u7ed3\u679c\u8868.xlsx";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contentByExcel(HttpServletResponse response, TbIndexContentViewConfig config, String xmmc) throws Exception {
        InputStream templateStream = this.getExcelTemplateStream("data/template/03-XZDLHC.xlsx");
        String curProjectPath = System.getProperty("user.dir");
        String tempDirPath = curProjectPath + File.separator + UUID.randomUUID().toString();
        File tempDirFile = new File(tempDirPath);
        tempDirFile.mkdir();
        try {
            String outputPath = tempDirPath + File.separator + "\u73b0\u72b6\u5730\u7c7b\u6838\u67e5\u7ed3\u679c\u8868.xlsx";
            this.generateExcel(config, xmmc, templateStream, outputPath);
            UpAndDownloadUtil.downloadFile((HttpServletResponse)response, (String)outputPath);
        }
        finally {
            FileUtils.deleteQuietly((File)tempDirFile);
            if (templateStream != null) {
                templateStream.close();
            }
        }
    }

    private void generateExcel(TbIndexContentViewConfig config, String xmmc, InputStream templateStream, String outExcelPath) throws Exception {
        XMConfig xmConfig = (XMConfig)config.getTag();
        StatIndicatorDTO indicator = this.countStatConfigService.getIndicatorDetail(config.getIndexId());
        String datasetId = indicator.getDatasetId();
        QueryFilterDTO filterDTO = new QueryFilterDTO();
        XZDLHCFields xzdlhcFields = this.queryFields(indicator);
        filterDTO.setFields(xzdlhcFields.toString());
        filterDTO.setReturnGeometry(Boolean.valueOf(false));
        filterDTO.setReturnCount(Boolean.valueOf(false));
        filterDTO.setCondition(String.format("%s = '%s'", xmConfig.getXmmcFieldName(), xmmc));
        DataQueryResult queryResult = this.dataSourceService.queryData(datasetId, filterDTO);
        String year = "xxxx";
        if (queryResult.getData() != null && queryResult.getData().size() > 0) {
            year = ((FeatureResult)queryResult.getData().get(0)).getAttributes().get(xzdlhcFields.timeField).toString();
        }
        JSONObject objResult = new JSONObject();
        objResult.put("xmmc", (Object)xmmc);
        objResult.put("year", (Object)year);
        objResult.put("exportTime", (Object)this.dateFormat.format(new Date()));
        List<XZDLHCRecord> records = this.caculateDLMJ(queryResult, xzdlhcFields);
        try (ExcelWriter excelWriter = EasyExcel.write((String)outExcelPath).withTemplate(templateStream).build();){
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
            excelWriter.fill(records, fillConfig, writeSheet);
            excelWriter.fill((Object)objResult, writeSheet);
        }
    }

    private XZDLHCFields queryFields(StatIndicatorDTO indicator) throws Exception {
        if (StringUtils.isEmpty((CharSequence)indicator.getTimeField())) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u65f6\u5e8f\u5b57\u6bb5");
        }
        XZDLHCFields xzdlhcFields = new XZDLHCFields();
        xzdlhcFields.timeField = indicator.getTimeField();
        for (FieldDTO fieldDTO : indicator.getGroupFields()) {
            if (fieldDTO.getName().toLowerCase().contains("dlbm")) {
                xzdlhcFields.dlbmFieldName = fieldDTO.getName().toLowerCase();
            }
            if (!fieldDTO.getName().toLowerCase().contains("dkmc")) continue;
            xzdlhcFields.dkmcFieldName = fieldDTO.getName().toLowerCase();
        }
        for (FieldDTO fieldDTO : indicator.getIndicatorFields()) {
            if (!fieldDTO.getName().toLowerCase().contains("mj")) continue;
            xzdlhcFields.dlmjFieldName = fieldDTO.getName().toLowerCase();
        }
        if (StringUtils.isEmpty((CharSequence)xzdlhcFields.dlbmFieldName)) {
            throw new RuntimeException("\u5206\u7ec4\u5b57\u6bb5\u4e2d\u672a\u5339\u914d\u5230\u5730\u7c7b\u7f16\u7801\u5b57\u6bb5");
        }
        if (StringUtils.isEmpty((CharSequence)xzdlhcFields.dkmcFieldName)) {
            throw new RuntimeException("\u5206\u7ec4\u5b57\u6bb5\u4e2d\u672a\u5339\u914d\u5230\u5730\u5757\u540d\u79f0\u5b57\u6bb5");
        }
        if (StringUtils.isEmpty((CharSequence)xzdlhcFields.dlmjFieldName)) {
            throw new RuntimeException("\u7edf\u8ba1\u5b57\u6bb5\u4e2d\u672a\u5339\u914d\u5230\u9762\u79ef\u5b57\u6bb5");
        }
        return xzdlhcFields;
    }

    private List<XZDLHCRecord> caculateDLMJ(DataQueryResult queryResult, XZDLHCFields xzdlhcFields) {
        if (queryResult.getData() == null || queryResult.getData().size() == 0) {
            return new ArrayList<XZDLHCRecord>();
        }
        HashMap<String, XZDLHCRecord> mapRecords = new HashMap<String, XZDLHCRecord>();
        String dkmc = null;
        String dlbm = null;
        double dlmj = 0.0;
        XZDLHCRecord totalRecord = new XZDLHCRecord();
        totalRecord.setDkmc("\u603b\u8ba1");
        XZDLHCRecord tempRecord = null;
        for (FeatureResult featureResult : queryResult.getData()) {
            dkmc = featureResult.getAttributes().get(xzdlhcFields.dkmcFieldName).toString();
            dlbm = featureResult.getAttributes().get(xzdlhcFields.dlbmFieldName).toString();
            dlmj = Double.parseDouble(featureResult.getAttributes().get(xzdlhcFields.dlmjFieldName).toString());
            dlmj = this.convertDoubleScale(dlmj / 10000.0, 4);
            if (mapRecords.containsKey(dkmc)) {
                tempRecord = (XZDLHCRecord)mapRecords.get(dkmc);
            } else {
                tempRecord = new XZDLHCRecord();
                tempRecord.setDkmc(dkmc);
                mapRecords.put(dkmc, tempRecord);
            }
            tempRecord.addDlmj(dlbm, dlmj);
            totalRecord.addDlmj(dlbm, dlmj);
        }
        List<XZDLHCRecord> records = mapRecords.values().stream().collect(Collectors.toList());
        records.add(totalRecord);
        for (int i = 0; i < records.size(); ++i) {
            records.get(i).setNum(i + 1);
        }
        return records;
    }

    private void convertUnit(List<XZDLHCRecord> records) throws Exception {
        Double fieldValue = null;
        for (XZDLHCRecord record : records) {
            for (Field field : record.getClass().getDeclaredFields()) {
                if ("num".equals(field.getName()) || "dkmc".equals(field.getName())) continue;
                field.setAccessible(true);
                fieldValue = (Double)field.get(record);
                fieldValue = this.convertDoubleScale(fieldValue / 10000.0, 4);
                field.set(record, fieldValue);
            }
        }
    }

    private double convertDoubleScale(double value, int scale) {
        BigDecimal bg = new BigDecimal(Double.toString(value));
        double retainedValue = bg.setScale(scale, 4).doubleValue();
        return retainedValue;
    }

    class XZDLHCFields {
        private String timeField;
        private String dkmcFieldName;
        private String dlbmFieldName;
        private String dlmjFieldName;

        XZDLHCFields() {
        }

        public String toString() {
            StringBuilder queryFieldBuilder = new StringBuilder();
            queryFieldBuilder.append(this.timeField).append(",");
            queryFieldBuilder.append(this.dkmcFieldName).append(",");
            queryFieldBuilder.append(this.dlbmFieldName).append(",");
            queryFieldBuilder.append(this.dlmjFieldName);
            return queryFieldBuilder.toString();
        }
    }
}

