/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.mdc.utils;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.WKTReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Stack;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ExpressionCalculator {
    private static final GeometryFactory GEOM_FACTORY = new GeometryFactory();

    private static double applyOperation(double a, double b, char op) {
        switch (op) {
            case '+': {
                return a + b;
            }
            case '-': {
                return a - b;
            }
            case '*': {
                return a * b;
            }
            case '/': {
                if (b == 0.0) {
                    throw new ArithmeticException("\u9664\u96f6\u9519\u8bef");
                }
                return a / b;
            }
        }
        return 0.0;
    }

    private static boolean hasPrecedence(char op1, char op2) {
        if (op2 == '(' || op2 == ')') {
            return false;
        }
        return !(op1 != '*' && op1 != '/' || op2 != '+' && op2 != '-');
    }

    public static double evaluateField(String expression, ResultSet resultSet) {
        Stack<Double> values = new Stack<Double>();
        Stack<Character> ops = new Stack<Character>();
        for (int i = 0; i < expression.length(); ++i) {
            StringBuilder sb;
            char c2 = expression.charAt(i);
            if (c2 == ' ') continue;
            if (Character.isDigit(c2)) {
                sb = new StringBuilder();
                while (i < expression.length() && (Character.isDigit(expression.charAt(i)) || expression.charAt(i) == '.')) {
                    sb.append(expression.charAt(i++));
                }
                --i;
                values.push(Double.parseDouble(sb.toString()));
                continue;
            }
            if (c2 == '(') {
                ops.push(Character.valueOf(c2));
                continue;
            }
            if (c2 == ')') {
                while (((Character)ops.peek()).charValue() != '(') {
                    values.push(ExpressionCalculator.applyOperation((Double)values.pop(), (Double)values.pop(), ((Character)ops.pop()).charValue()));
                }
                ops.pop();
                continue;
            }
            if (c2 == '+' || c2 == '-' || c2 == '*' || c2 == '/') {
                while (!ops.empty() && ExpressionCalculator.hasPrecedence(c2, ((Character)ops.peek()).charValue())) {
                    values.push(ExpressionCalculator.applyOperation((Double)values.pop(), (Double)values.pop(), ((Character)ops.pop()).charValue()));
                }
                ops.push(Character.valueOf(c2));
                continue;
            }
            sb = new StringBuilder();
            while (i < expression.length() && (Character.isDigit(expression.charAt(i)) || expression.charAt(i) == '.')) {
                sb.append(expression.charAt(i++));
            }
            --i;
            try {
                String value = resultSet.getString(sb.toString());
                values.push(Double.parseDouble(value));
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        while (!ops.empty()) {
            values.push(ExpressionCalculator.applyOperation((Double)values.pop(), (Double)values.pop(), ((Character)ops.pop()).charValue()));
        }
        return (Double)values.pop();
    }

    public static double evaluate(String expression) {
        Stack<Double> values = new Stack<Double>();
        Stack<Character> ops = new Stack<Character>();
        for (int i = 0; i < expression.length(); ++i) {
            char c2 = expression.charAt(i);
            if (c2 == ' ') continue;
            if (Character.isDigit(c2)) {
                StringBuilder sb = new StringBuilder();
                while (i < expression.length() && (Character.isDigit(expression.charAt(i)) || expression.charAt(i) == '.')) {
                    sb.append(expression.charAt(i++));
                }
                --i;
                values.push(Double.parseDouble(sb.toString()));
                continue;
            }
            if (c2 == '(') {
                ops.push(Character.valueOf(c2));
                continue;
            }
            if (c2 == ')') {
                while (((Character)ops.peek()).charValue() != '(') {
                    values.push(ExpressionCalculator.applyOperation((Double)values.pop(), (Double)values.pop(), ((Character)ops.pop()).charValue()));
                }
                ops.pop();
                continue;
            }
            if (c2 != '+' && c2 != '-' && c2 != '*' && c2 != '/') continue;
            while (!ops.empty() && ExpressionCalculator.hasPrecedence(c2, ((Character)ops.peek()).charValue())) {
                values.push(ExpressionCalculator.applyOperation((Double)values.pop(), (Double)values.pop(), ((Character)ops.pop()).charValue()));
            }
            ops.push(Character.valueOf(c2));
        }
        while (!ops.empty()) {
            values.push(ExpressionCalculator.applyOperation((Double)values.pop(), (Double)values.pop(), ((Character)ops.pop()).charValue()));
        }
        return (Double)values.pop();
    }

    public static Geometry wktToGeometry(String wkt) throws Exception {
        return new WKTReader(GEOM_FACTORY).read(wkt);
    }

    public static String createPointWKT(double x, double y) {
        return String.format("POINT(%f %f)", x, y);
    }

    public static Geometry transformGeometry(Geometry geom, String sourceCRS, String targetCRS) throws Exception {
        CoordinateReferenceSystem source = CRS.decode((String)sourceCRS);
        CoordinateReferenceSystem target = CRS.decode((String)targetCRS);
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target);
        return JTS.transform((Geometry)geom, (MathTransform)transform);
    }

    public static double calculateTransformedDistance(double x1, double y1, double x2, double y2, String sourceCRS, String targetCRS) throws Exception {
        Geometry p1 = ExpressionCalculator.wktToGeometry(ExpressionCalculator.createPointWKT(x1, y1));
        Geometry p2 = ExpressionCalculator.wktToGeometry(ExpressionCalculator.createPointWKT(x2, y2));
        Geometry transformedP1 = ExpressionCalculator.transformGeometry(p1, sourceCRS, targetCRS);
        Geometry transformedP2 = ExpressionCalculator.transformGeometry(p2, sourceCRS, targetCRS);
        return transformedP1.distance(transformedP2);
    }

    public static void main(String[] args) {
        String expr = "3 + (4 * 2) - 6 / 3";
        System.out.println(ExpressionCalculator.evaluate(expr));
    }
}

