CREATE TABLE IF NOT EXISTS tb_mdc_autoimport_rel (
	f_id varchar(64) NOT NULL,
	f_taskid varchar(64) NULL,
	f_tablename varchar(100) NULL,
	f_im_tablename varchar(100) NULL,
	f_fieldname varchar(50) NULL,
	f_im_fieldname varchar(50) NULL,
	f_order int4 NULL,
	f_tag varchar(200) NULL,
	f_fieldalias varchar(100) NULL,
	f_im_fieldalias varchar(100) NULL,
	f_syscode varchar(50) NULL,
	f_bz text NULL,
	f_fieldtype int2 NULL,
	f_version varchar(50) NULL,
	CONSTRAINT tb_mdc_autoimport_rel_pkey PRIMARY KEY (f_id)
);

-- Column comments
COMMENT ON COLUMN tb_mdc_autoimport_rel.f_id IS '关键字';
COMMENT ON COLUMN tb_mdc_autoimport_rel.f_taskid IS '任务对象id(大部分配置的是tableid)';
COMMENT ON COLUMN tb_mdc_autoimport_rel.f_tablename IS '数据库中的表名';
COMMENT ON COLUMN tb_mdc_autoimport_rel.f_im_tablename IS '待导入字段的表名';
COMMENT ON COLUMN tb_mdc_autoimport_rel.f_fieldname IS '数据库中的字段名称';
COMMENT ON COLUMN tb_mdc_autoimport_rel.f_im_fieldname IS '待导入字段的名称';
COMMENT ON COLUMN tb_mdc_autoimport_rel.f_order IS '排序';
COMMENT ON COLUMN tb_mdc_autoimport_rel.f_tag IS '自定义tag';
COMMENT ON COLUMN tb_mdc_autoimport_rel.f_fieldalias IS '数据库中的字段描述';
COMMENT ON COLUMN tb_mdc_autoimport_rel.f_im_fieldalias IS '待导入字段的描述';
COMMENT ON COLUMN tb_mdc_autoimport_rel.f_syscode IS '子系统编码';
COMMENT ON COLUMN tb_mdc_autoimport_rel.f_bz IS '备注';
COMMENT ON COLUMN tb_mdc_autoimport_rel.f_fieldtype IS '字段类型：0或者NULL为普通字段，1主键字段，2shape字段';
COMMENT ON COLUMN tb_mdc_autoimport_rel.f_version IS '表结构所属任务结构版本号';