/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.mdc.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class UriUtils {
    public static Map<String, String> getUrlParams(String url) {
        String[] paramPairs;
        HashMap<String, String> params = new HashMap<String, String>();
        if (url == null || url.isEmpty()) {
            return params;
        }
        int queryStartIndex = url.indexOf("?");
        if (queryStartIndex == -1) {
            return params;
        }
        String queryString = url.substring(queryStartIndex + 1);
        int fragmentIndex = queryString.indexOf("#");
        if (fragmentIndex != -1) {
            queryString = queryString.substring(0, fragmentIndex);
        }
        for (String paramPair : paramPairs = queryString.split("&")) {
            String value;
            if (paramPair.isEmpty()) continue;
            String[] keyValue = paramPair.split("=", 2);
            String key = UriUtils.decode(keyValue[0]);
            String string = value = keyValue.length > 1 ? UriUtils.decode(keyValue[1]) : "";
            if (key == null || key.isEmpty()) continue;
            params.put(key, value);
        }
        return params;
    }

    private static String decode(String encoded) {
        try {
            return URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return encoded;
        }
    }
}

