/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.mdc.controller;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.catalog.dto.query.FeatureQueryFilterDTO;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.edit.DataBatchDeleteDTO;
import com.geoway.adf.dms.datasource.dto.edit.GeoDataEditDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.ns.mdc.filter.RestFilter;
import com.geoway.ns.mdc.service.IDataCenterService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.service.ITokenService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/dataCenter"})
public class DataCenterControler {
    @Autowired
    private IDataCenterService dataCenterService;
    @Autowired
    RestFilter filter;
    @Autowired
    protected ITokenService tokenService;

    @RequestMapping(value={"/{taskid}/uploadfile"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse uploadfile(HttpServletRequest request, @PathVariable(value="taskid") String taskid, @RequestParam(value="file", required=true) MultipartFile file, String params) {
        try {
            String userId = this.tokenService.queryCurrentSysUserId();
            if (StringUtils.isEmpty((String)userId)) {
                this.filter.urlValid(request);
            }
            return this.dataCenterService.uploadFile(taskid, file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/{taskid}/addData"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse add(HttpServletRequest request, @PathVariable(value="taskid") String taskid, @RequestBody JSONObject postData) {
        try {
            String userId = this.tokenService.queryCurrentSysUserId();
            if (StringUtils.isEmpty((String)userId)) {
                this.filter.urlValid(request);
            }
            this.dataCenterService.addData(taskid, postData);
            return BaseResponse.success((String)"\u4e0a\u4f20\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/{taskid}/{tablename}/addData"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse addTableData(HttpServletRequest request, @PathVariable(value="taskid") String taskid, @PathVariable(value="tablename") String tablename, @RequestBody JSONObject postData) {
        try {
            String userId = this.tokenService.queryCurrentSysUserId();
            if (StringUtils.isEmpty((String)userId)) {
                this.filter.urlValid(request);
            }
            this.dataCenterService.addData(taskid, tablename, postData);
            return BaseResponse.success((String)"\u4e0a\u4f20\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.buildFailuaResponse((Exception)e);
        }
    }

    @RequestMapping(value={"/{taskid}/{tablename}/query"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Response<DataQueryResult> queryData(HttpServletRequest request, @PathVariable(value="taskid") String taskid, @PathVariable(value="tablename") String tablename, @RequestBody FeatureQueryFilterDTO queryFilterDTO, @RequestParam(value="fieldConvert", required=false, defaultValue="true") Boolean fieldConvert) {
        try {
            String userId = this.tokenService.queryCurrentSysUserId();
            if (StringUtils.isEmpty((String)userId)) {
                this.filter.urlValid(request);
            }
            return Response.ok((Object)this.dataCenterService.queryData(taskid, tablename, queryFilterDTO, fieldConvert));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/{taskid}/{tablename}/query/feature"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Response<DataQueryResult> queryFetureData(HttpServletRequest request, @PathVariable(value="taskid") String taskid, @PathVariable(value="tablename") String tablename, Long objectId, @RequestParam(value="fieldConvert", required=false, defaultValue="true") Boolean fieldConvert) {
        try {
            String userId = this.tokenService.queryCurrentSysUserId();
            if (StringUtils.isEmpty((String)userId)) {
                this.filter.urlValid(request);
            }
            return Response.ok((Object)this.dataCenterService.queryByObjectId(taskid, tablename, objectId, fieldConvert));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/{taskid}/{tablename}/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deleteTableData(HttpServletRequest request, @PathVariable(value="taskid") String taskid, @PathVariable(value="tablename") String tablename, Long objectId) {
        try {
            String userId = this.tokenService.queryCurrentSysUserId();
            if (StringUtils.isEmpty((String)userId)) {
                this.filter.urlValid(request);
            }
            if (this.dataCenterService.deleteByObjectId(taskid, tablename, objectId).booleanValue()) {
                return BaseResponse.success((String)"\u5220\u9664\u6210\u529f");
            }
            return BaseResponse.success((String)"\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/{taskid}/{tablename}/deleteByFilter"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deleteByFilter(HttpServletRequest request, @PathVariable(value="taskid") String taskid, @PathVariable(value="tablename") String tablename, @RequestBody DataBatchDeleteDTO dataBatchDeleteDTO) {
        try {
            String userId = this.tokenService.queryCurrentSysUserId();
            if (StringUtils.isEmpty((String)userId)) {
                this.filter.urlValid(request);
            }
            if (this.dataCenterService.deleteByFiter(taskid, tablename, dataBatchDeleteDTO) > 0L) {
                return BaseResponse.success((String)"\u5220\u9664\u6210\u529f");
            }
            return BaseResponse.success((String)"\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/{taskid}/{tablename}/updateToFirst"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="7-\u7f6e\u9876")
    public BaseResponse updateToFirst(HttpServletRequest request, @PathVariable(value="taskid") String taskid, @PathVariable(value="tablename") String tablename, Long objectId) {
        boolean res = this.dataCenterService.updateToFirst(taskid, tablename, objectId);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/{taskid}/{tablename}/updateToLast"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="8-\u7f6e\u5e95")
    public BaseResponse updateToLast(HttpServletRequest request, @PathVariable(value="taskid") String taskid, @PathVariable(value="tablename") String tablename, Long objectId) {
        boolean res = this.dataCenterService.updateToLast(taskid, tablename, objectId);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/{taskid}/{tablename}/updateToPre"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="9-\u4e0a\u79fb")
    public BaseResponse updateToPre(HttpServletRequest request, @PathVariable(value="taskid") String taskid, @PathVariable(value="tablename") String tablename, Long objectId) {
        boolean res = this.dataCenterService.updateToPre(taskid, tablename, objectId);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/{taskid}/{tablename}/updateToSuffix"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="10-\u4e0b\u79fb")
    public BaseResponse updateToSuffix(HttpServletRequest request, @PathVariable(value="taskid") String taskid, @PathVariable(value="tablename") String tablename, Long objectId) {
        boolean res = this.dataCenterService.updateToSuffix(taskid, tablename, objectId);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/{taskid}/{tablename}/moveSort"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="10-\u62d6\u62fd\u6392\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="objectId", value="\u66f4\u65b0\u5143\u7d20\u7684id", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="targetOrder", value="\u76ee\u6807\u4f4d\u7f6e\u5143\u7d20\u7684\u5e8f\u53f7", required=true, dataTypeClass=Integer.class)})
    public BaseResponse moveSort(Long objectId, @PathVariable(value="taskid") String taskid, @PathVariable(value="tablename") String tablename, Long targetOrder) {
        boolean res = this.dataCenterService.sort(taskid, tablename, objectId, targetOrder);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @ApiOperation(value="03-\u66f4\u65b0\u6570\u636e")
    @RequestMapping(value={"/{taskid}/{tablename}/update"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse updateData(@PathVariable(value="taskid") String taskid, @PathVariable(value="tablename") String tablename, @RequestBody GeoDataEditDTO geoDataEdit) {
        try {
            if (StringUtils.isEmpty((String)taskid) || StringUtils.isEmpty((String)tablename) || geoDataEdit == null) {
                return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean result = this.dataCenterService.updateData(taskid, tablename, geoDataEdit);
            if (result) {
                return BaseResponse.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return BaseResponse.success((String)"\u66f4\u65b0\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)("\u66f4\u65b0\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage()));
        }
    }
}

