/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.mdc.filter;

import com.geoway.ns.mdc.domain.MdcApplication;
import com.geoway.ns.mdc.mapper.MdcApplicationMapper;
import com.geoway.ns.mdc.utils.EncryptUtil;
import com.geoway.ns.mdc.utils.UriUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.validator.UrlValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class RestFilter {
    @Autowired
    MdcApplicationMapper appDao;

    public void urlValid(HttpServletRequest request) throws Exception {
        String url = request.getRequestURL().toString();
        if (StringUtils.isNotEmpty((String)request.getQueryString())) {
            url = String.format("%s?%s", url, request.getQueryString());
        }
        String urls = url.replace("http", "https");
        this.checkUrl(url);
    }

    public void checkUrl(String url) throws Exception {
        Date reqDate;
        if (!new UrlValidator().isValid(url)) {
            throw new Exception(String.format("url\u683c\u5f0f\u5f02\u5e38:[%s]", url));
        }
        Map<String, String> params = UriUtils.getUrlParams(url);
        HashSet<String> set = new HashSet<String>();
        set.add("appkey");
        set.add("timestamp");
        set.add("sign");
        if (!params.keySet().containsAll(set)) {
            throw new Exception("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        String timestamp = params.get("timestamp");
        try {
            reqDate = new Date(Long.valueOf(timestamp));
        }
        catch (Exception e) {
            throw new Exception("\u8bf7\u6c42\u65f6\u95f4\u6233\u9519\u8bef");
        }
        int minuteValid = 10;
        if (DateUtils.addMinutes((Date)reqDate, (int)minuteValid).getTime() < System.currentTimeMillis()) {
            throw new Exception("\u8bf7\u6c42\u903e\u671f");
        }
        String appkey = params.get("appkey");
        MdcApplication app = this.appDao.findByAppKey(appkey);
        if (app == null) {
            throw new Exception("appkey\u65e0\u6548\u6216\u88ab\u7981\u7528");
        }
        try {
            this.checkSign(url, params, app);
        }
        catch (Exception e) {
            throw new Exception("\u7b7e\u540d\u9a8c\u8bc1\u9519\u8bef" + e.getMessage());
        }
    }

    private void checkSign(String url, Map<String, String> params, MdcApplication app) {
        String sign = params.get("sign");
        String signParam = "sign=" + sign;
        String mark = "&";
        url = url.contains(signParam + mark) ? url.replace(signParam + mark, "") : url.replace(mark + "sign=" + sign, "");
        String urlSign = EncryptUtil.buildSign(url, app.getAppsecret());
        Assert.state((boolean)StringUtils.equals((String)sign, (String)urlSign));
    }
}

