/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.mdc.plugin;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.PinyinUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTileServiceCreateDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.RenderIndexService;
import com.geoway.adf.dms.datasource.util.FileStorageUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.gis.basic.a.c;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemType;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.ns.base.util.GaussXY2BL;
import com.geoway.ns.base.util.GeometryUtils;
import com.geoway.ns.mdc.domain.AutoimportRel;
import com.geoway.ns.mdc.service.IAutoImportService;
import com.geoway.ns.mdc.service.impl.AutoImportServiceImpl;
import com.geoway.ns.mdc.utils.SqliteTool;
import com.geoway.webstore.input.plugin.ImportPluginBase;
import com.geoway.webstore.input.plugin.data.IImportData;
import com.geoway.webstore.input.plugin.data.IImportUnit;
import com.geoway.webstore.input.plugin.data.ImportUnit;
import com.geoway.webstore.input.plugin.data.ImportVector;
import com.geoway.webstore.input.plugin.event.ImportScanUnitEventArgs;
import com.geoway.webstore.input.plugin.model.DataDuplicateStrategyEnum;
import com.geoway.webstore.input.plugin.model.ExecuteResult;
import com.geoway.webstore.input.plugin.model.ExecuteResultDetail;
import com.geoway.webstore.input.plugin.params.IImportParams;
import com.geoway.webstore.input.plugin.params.ImportSourceParams;
import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BgdcDBImportPlugin
extends ImportPluginBase {
    protected GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
    private VectorImportPluginTargetParams targetParams;
    private VectorImportPluginSettingParams settingParams;
    private IFeatureWorkspace targetWorkspace = null;
    IAutoImportService autoImportService = (IAutoImportService)SpringContextUtil.getBean(AutoImportServiceImpl.class);
    private DataSourceManager dataSourceManager = (DataSourceManager)SpringContextUtil.getBean(DataSourceManager.class);
    protected RenderIndexService renderIndexService = (RenderIndexService)SpringContextUtil.getBean(RenderIndexService.class);

    public void initialize(String sourceParamsStr, String targetParamsStr, String settingParamsStr) {
        this.sourceParams = (ImportSourceParams)JSONObject.parseObject((String)sourceParamsStr, ImportSourceParams.class);
        this.targetParams = (VectorImportPluginTargetParams)JSONObject.parseObject((String)settingParamsStr, VectorImportPluginTargetParams.class);
        this.settingParams = (VectorImportPluginSettingParams)JSONObject.parseObject((String)settingParamsStr, VectorImportPluginSettingParams.class);
    }

    public void scanData() {
        if (StringUtils.isNotEmpty((CharSequence)this.settingParams.getSourceFilePath())) {
            File sourceFile = new File(this.settingParams.getSourceFilePath());
            String fileName = FileUtil.getFileNameWithoutExtension((String)sourceFile.getName());
            ImportUnit importUnit = new ImportUnit();
            importUnit.setName(fileName);
            importUnit.setCode(fileName);
            importUnit.setPath(this.settingParams.getSourceFilePath());
            ImportVector importVector = new ImportVector();
            importVector.setName(fileName);
            importVector.setPath(this.settingParams.getSourceFilePath());
            importVector.setDatasetName(null);
            ImportScanUnitEventArgs args = new ImportScanUnitEventArgs((Object)this, (IImportUnit)importUnit, Collections.singletonList(importVector));
            this.onDataUnitScaned(args);
        } else if (this.settingParams.getInputDatas() != null && this.settingParams.getInputDatas().size() > 0) {
            ImportUnit importUnit = new ImportUnit();
            ArrayList<ImportVector> importDataList = new ArrayList<ImportVector>();
            Integer i = 0;
            while (i < this.settingParams.getInputDatas().size()) {
                VectorImportPluginInputDataParams inputData = this.settingParams.getInputDatas().get(i);
                if (i == 0) {
                    importUnit.setName(inputData.getTimePhase());
                    importUnit.setCode(inputData.getTimePhase());
                    importUnit.setPath(inputData.getSourceLayerName());
                }
                ImportVector importVector = new ImportVector();
                importVector.setName(inputData.getTargetLayerName());
                importVector.setPath(inputData.getSourceLayerName());
                importVector.setDatasetName(inputData.getTimePhase());
                importDataList.add(importVector);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            ImportScanUnitEventArgs args = new ImportScanUnitEventArgs((Object)this, (IImportUnit)importUnit, importDataList);
            this.onDataUnitScaned(args);
        } else {
            throw new RuntimeException("\u6ca1\u6709\u53ef\u4ee5\u5bfc\u5165\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e");
        }
    }

    public IImportData getImportData(Long dataId) {
        return ImportVector.getImportData((Long)dataId);
    }

    public ExecuteResult prepareImport() {
        ExecuteResult result = super.prepareImport();
        try {
            if (this.targetWorkspace == null) {
                this.targetWorkspace = this.geoDatabaseService.openGeoWorkspace(this.targetParams.getTargetDatabaseKey());
            }
            if (this.targetWorkspace == null) {
                result.setSuccess(Boolean.valueOf(false));
                result.setErrorMessage("\u6253\u5f00\u76ee\u6807\u6570\u636e\u5e93\u5931\u8d25\uff01");
                this.log.error("\u6253\u5f00\u76ee\u6807\u6570\u636e\u5e93\u5931\u8d25\uff01");
                return result;
            }
            return result;
        }
        catch (Exception e) {
            this.log.error("\u5165\u5e93\u5931\u8d25", (Throwable)e);
            result.setSuccess(Boolean.valueOf(false));
            result.setErrorMessage("\u5165\u5e93\u5931\u8d25:" + e.getMessage());
            this.onImportDataLog(result.getErrorMessage());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteResultDetail executeImport(IImportData importData) {
        this.currentImportData = importData;
        Date startTime = new Date();
        ExecuteResultDetail executeResult = new ExecuteResultDetail();
        String taskId = "com.geoway.ns.mdc.plugin.BgdcDBImportPlugin";
        try (Object srcWorkspace = null;){
            this.onImportDataLog(this.settingParams.getSourceFilePath() + " \u5f00\u59cb\u6267\u884c\u5165\u5e93...");
            String filePath = UploadPathConfig.getFileFullPath((String)importData.getPath());
            SqliteTool connPool = new SqliteTool(filePath);
            Connection connection = connPool.getConnection();
            System.out.println("connPool-------------------------------" + connPool);
            HashMap<String, IFeatureClass> targetTablename2FeatuerCalss = new HashMap<String, IFeatureClass>();
            Statement statement = connection.createStatement();
            System.out.println("statement-------------------------------" + statement);
            String dbInfosql = "select  version, createtime, updatetime, createuser, description from DB_INFO";
            ResultSet dbInfoResultSet = statement.executeQuery(dbInfosql);
            String version = "1.0";
            while (dbInfoResultSet.next()) {
                version = dbInfoResultSet.getString("version");
            }
            List<AutoimportRel> fieldLists = this.autoImportService.getAutoImportRel(taskId, version, null);
            Map<String, List<AutoimportRel>> targetTableName2Fields = fieldLists.stream().collect(Collectors.groupingBy(AutoimportRel::getTablename));
            Map<String, List<AutoimportRel>> srctableName2Fields = fieldLists.stream().collect(Collectors.groupingBy(AutoimportRel::getImTablename));
            DataDuplicateStrategyEnum duplicateStrategyEnum = DataDuplicateStrategyEnum.getByValue((Integer)this.sourceParams.getDataDuplicateStrategy());
            if (targetTableName2Fields != null && targetTableName2Fields.keySet() != null && targetTableName2Fields.keySet().size() > 0) {
                for (String targetTableName : targetTableName2Fields.keySet()) {
                    String realTargetTableName = targetTableName.replace("{YEAR}", ((ImportVector)importData).getDatasetName());
                    IFeatureClass targetFeatureClass = this.targetWorkspace.openFeatureClass(realTargetTableName);
                    if (targetFeatureClass == null) {
                        List<AutoimportRel> targetFieldsDef = targetTableName2Fields.get(targetTableName);
                        Fields targetFields = new Fields();
                        String[] geomField = new String[]{null};
                        String[] oidField = new String[]{null};
                        targetFieldsDef.forEach(arg_0 -> BgdcDBImportPlugin.lambda$executeImport$0(geomField, (IFields)targetFields, oidField, arg_0));
                        if (targetFields.findFieldIndex("f_importtime") < 0) {
                            targetFields.addField((IField)new Field("f_importtime", "\u5165\u5e93\u65f6\u95f4", FieldType.DateTime));
                        }
                        if ((targetFeatureClass = this.targetWorkspace.createFeatureClass(realTargetTableName, (IFields)targetFields, FeatureType.Polygon, geomField[0], null)) == null) {
                            executeResult.setSuccess(Boolean.valueOf(false));
                            executeResult.setErrorMessage("\u6253\u5f00\u76ee\u6807\u56fe\u5c42[" + targetTableName + "]\u5931\u8d25,\u4e14\u65b0\u5efa\u56fe\u5c42\u4ea6\u672a\u6210\u529f");
                            this.onImportDataLog(executeResult.getErrorMessage());
                            ExecuteResultDetail executeResultDetail = executeResult;
                            return executeResultDetail;
                        }
                        if (targetFeatureClass == null) continue;
                        targetFeatureClass.createSpatialIndex();
                        targetTablename2FeatuerCalss.put(targetTableName, targetFeatureClass);
                        this.onImportDataLog(String.format("\u76ee\u6807\u56fe\u5c42[%s]\u521b\u5efa\u6210\u529f", realTargetTableName));
                        continue;
                    }
                    targetTablename2FeatuerCalss.put(targetTableName, targetFeatureClass);
                    this.onImportDataLog(String.format("\u6253\u5f00\u76ee\u6807\u56fe\u5c42[%s]\u6210\u529f", realTargetTableName));
                }
            }
            long totalAllLyrCount = 0L;
            long errorAllLyrCount = 0L;
            long successAllLyrCount = 0L;
            if (srctableName2Fields != null && srctableName2Fields.keySet() != null && srctableName2Fields.keySet().size() > 0) {
                for (String srcTableName : srctableName2Fields.keySet()) {
                    List<AutoimportRel> srcFields = srctableName2Fields.get(srcTableName);
                    String targetTableName = srcFields.get(0).getTablename();
                    Date startTime2 = new Date();
                    IFeatureClass targetFeatureClass = (IFeatureClass)targetTablename2FeatuerCalss.get(targetTableName);
                    if (!BgdcDBImportPlugin.startEdit((IGeoDataset)targetFeatureClass)) {
                        this.onImportDataLog(String.format("\u76ee\u6807\u56fe\u5c42[%s]\u6253\u5f00\u7f16\u8f91\u5931\u8d25", targetTableName));
                        executeResult.setSuccess(Boolean.valueOf(false));
                        executeResult.setErrorMessage("\u76ee\u6807\u56fe\u5c42[" + targetTableName + "]\u6253\u5f00\u7f16\u8f91\u5931\u8d25");
                        ExecuteResultDetail executeResultDetail = executeResult;
                        return executeResultDetail;
                    }
                    if (this.settingParams.overwrite != null && this.settingParams.overwrite.booleanValue()) {
                        this.deleteRows((ITable)targetFeatureClass, null);
                    }
                    IEnvelope dataExtent = GeometryFunc.createEnvelope((double)Double.MAX_VALUE, (double)Double.MAX_VALUE, (double)Double.MIN_VALUE, (double)Double.MIN_VALUE);
                    IFeatureCursor trgInsertCursor = targetFeatureClass.batchInsertFeature();
                    int limit = 10000;
                    String countsql = "select count(1) as count from " + srcTableName;
                    ResultSet resultSet1 = statement.executeQuery(countsql);
                    long totalCount = resultSet1.getLong("count");
                    long errorCount = 0L;
                    long successCount = 0L;
                    System.out.println("countTotal-------------------------------" + countsql);
                    Long page = totalCount % (long)limit == 0L ? totalCount / (long)limit : totalCount / (long)limit + 1L;
                    int start = 1;
                    while ((long)start <= page) {
                        System.out.println("page-------------------------------" + page);
                        String sql = "select  * from " + srcTableName + " order by bsm limit " + limit + " offset " + (start - 1) * limit;
                        ResultSet resultSet = statement.executeQuery(sql);
                        int count = 0;
                        while (resultSet.next()) {
                            String bsm;
                            IFeature oldFeature;
                            System.out.println("count-------------------------------" + count);
                            if (!(this.settingParams.overwrite != null && this.settingParams.overwrite.booleanValue() || (oldFeature = this.getFeatureByBSM(targetFeatureClass, bsm = resultSet.getString("BSM"))) == null)) {
                                System.out.println("\u5b58\u5728\u91cd\u590d\u6570\u636e-------------------------------" + bsm);
                                if (duplicateStrategyEnum == DataDuplicateStrategyEnum.Skip) {
                                    System.out.println("\u8df3\u8fc7\u91cd\u590d\u6570\u636e\u5b58\u5728\u91cd\u590d\u6570\u636e-------------------------------" + bsm);
                                    executeResult.setSuccess(Boolean.valueOf(true));
                                    continue;
                                }
                                System.out.println("\u5220\u9664\u91cd\u590d\u6570\u636e\u5b58\u5728\u91cd\u590d\u6570\u636e-------------------------------" + bsm);
                                targetFeatureClass.deleteFeature(oldFeature.getObjectId());
                            }
                            IFeature targeFeature = targetFeatureClass.createFeature();
                            try {
                                Integer fieldIndex = 0;
                                while (fieldIndex < srcFields.size()) {
                                    AutoimportRel fieldInfo = srcFields.get(fieldIndex);
                                    String srcFielName = fieldInfo.getImFieldname();
                                    if (StringUtils.isNotEmpty((CharSequence)srcFielName) && srcFielName.equalsIgnoreCase("FJ") && BgdcDBImportPlugin.hasColumn(resultSet, srcFielName)) {
                                        String fileName = resultSet.getString("FJMC");
                                        try {
                                            InputStream inputStream = resultSet.getBinaryStream(srcFielName);
                                            DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(this.targetParams.getTargetFilestorageKey());
                                            IFileStorage fileStorage = FileStorageUtil.openFileStorage((DataSourceDTO)dataSourceDTO);
                                            String targetFile = StringUtil.trimEnd((String)dataSourceDTO.getUrl(), (String)"/") + "/" + importData.getName() + "/" + fileName;
                                            try {
                                                fileStorage.upload(inputStream, targetFile, this.sourceParams.getDataDuplicateStrategy() == 0);
                                            }
                                            catch (Exception var29) {
                                                throw new RuntimeException("\u6587\u4ef6: " + fileName + "\u4e0a\u4f20\u5931\u8d25", var29);
                                            }
                                            finally {
                                                if (inputStream != null) {
                                                    inputStream.close();
                                                    inputStream = null;
                                                }
                                            }
                                            targeFeature.setValue(fieldInfo.getFieldname(), (Object)targetFile);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    } else if (StringUtils.isNotEmpty((CharSequence)srcFielName)) {
                                        Object value;
                                        String wkt = "";
                                        Boolean isproject = false;
                                        if (fieldInfo.getFieldtype().intValue() == FieldType.Shape.getValue()) {
                                            if (BgdcDBImportPlugin.hasColumn(resultSet, srcFielName)) {
                                                value = resultSet.getObject(srcFielName);
                                                wkt = (String)value;
                                                isproject = true;
                                            } else if (srcFielName.indexOf("POINT(") > -1) {
                                                String clean = srcFielName.replace("POINT(", "").replace(")", "");
                                                String[] coordsFields = clean.trim().split(" ");
                                                if (coordsFields.length == 2) {
                                                    try {
                                                        wkt = "POINT(" + resultSet.getObject(coordsFields[0]) + " " + resultSet.getObject(coordsFields[1]) + ")";
                                                    }
                                                    catch (SQLException e) {
                                                        e.printStackTrace();
                                                    }
                                                }
                                                isproject = false;
                                            }
                                            IGeometry pNewShape = GeometryFunc.createGeometry((String)wkt);
                                            if (isproject.booleanValue()) {
                                                Geometry geom = GeometryUtils.wktToGeometry((String)wkt);
                                                double[] longlat = GaussXY2BL.GaussToBL((double)geom.getCentroid().getX(), (double)geom.getCentroid().getY(), (int)2, (int)3);
                                                CoordinateReferenceSystem sourceCRS = GeometryUtils.findTargetProjectiveCRS((Double)longlat[0]);
                                                ISpatialReferenceSystem srcRef = c.createSpatialReference((String)sourceCRS.toWKT());
                                                ISpatialReferenceSystem trgRef = c.createSpatialReference((int)4490);
                                                pNewShape.project(srcRef, trgRef);
                                            }
                                            if (pNewShape != null && pNewShape.getEnvelope() != null) {
                                                this.setEnvelop(dataExtent, pNewShape.getEnvelope());
                                            }
                                            targeFeature.setGeometry(pNewShape);
                                            System.out.print("wkt:");
                                            System.out.print(pNewShape.toWkt());
                                        } else {
                                            value = resultSet.getObject(fieldInfo.getImFieldname());
                                            targeFeature.setValue(fieldInfo.getFieldname(), value);
                                        }
                                    }
                                    Integer n = fieldIndex;
                                    Integer n2 = fieldIndex = Integer.valueOf(fieldIndex + 1);
                                }
                                boolean saveSuccess = trgInsertCursor.insertFeature(targeFeature);
                                if (saveSuccess) {
                                    ++successCount;
                                    continue;
                                }
                                ++errorCount;
                            }
                            catch (SQLException sqe) {
                                sqe.printStackTrace();
                            }
                        }
                        ++start;
                    }
                    Boolean isSuccess = true;
                    if (isSuccess.booleanValue() && dataExtent != null) {
                        ImportVector impDataVector = (ImportVector)this.currentImportData;
                        impDataVector.setXmin(Double.valueOf(dataExtent.getXMin()));
                        impDataVector.setXmax(Double.valueOf(dataExtent.getXMax()));
                        impDataVector.setYmin(Double.valueOf(dataExtent.getYMin()));
                        impDataVector.setYmax(Double.valueOf(dataExtent.getYMax()));
                        impDataVector.updateExtent();
                    }
                    String text = DateTimeUtil.getTimeIntervalStr((Date)startTime2, (Date)new Date());
                    String realTargetTableName = targetTableName.replace("{YEAR}", ((ImportVector)importData).getDatasetName());
                    this.onImportDataLog(String.format("%s\u5165\u5e93[%s]%s\uff1a\u5171%s\u4e2a\uff0c\u6210\u529f%s\u4e2a\uff0c\u5931\u8d25%s\u4e2a\u3002\u603b\u8017\u65f6:%s", srcTableName, realTargetTableName, isSuccess != false ? "\u6210\u529f" : "\u5931\u8d25", totalCount, successCount, errorCount, text));
                    totalAllLyrCount += totalCount;
                    errorAllLyrCount += errorCount;
                    successAllLyrCount += successCount;
                    trgInsertCursor.release();
                }
            }
            Date endTime = new Date();
            String text = DateTimeUtil.getTimeIntervalStr((Date)startTime, (Date)endTime);
            this.onImportDataLog(String.format("%s\u5165\u5e93\u4efb\u52a1\u5b8c\u6210\u3002\u603b\u8017\u65f6:%s", importData.getName(), text));
            executeResult.setTotalCount(totalAllLyrCount);
            executeResult.setSuccessCount(successAllLyrCount);
            executeResult.setFailCount(errorAllLyrCount);
            executeResult.setSuccess(Boolean.valueOf(true));
            executeResult.setErrorMessage("\u5165\u5e93\u6210\u529f");
            for (String targetTableName : targetTablename2FeatuerCalss.keySet()) {
                BgdcDBImportPlugin.stopEdit((IGeoDataset)targetTablename2FeatuerCalss.get(targetTableName), true);
            }
            ExecuteResultDetail executeResultDetail = executeResult;
            return executeResultDetail;
        }
    }

    private void setEnvelop(IEnvelope newExtent, IEnvelope oldExtent) {
        newExtent.setRange(Double.min(newExtent.getXMin(), oldExtent.getXMin()), Double.min(newExtent.getYMin(), oldExtent.getYMin()), Double.max(newExtent.getXMax(), oldExtent.getXMax()), Double.max(newExtent.getYMax(), oldExtent.getYMax()));
    }

    static boolean hasColumn(ResultSet rs, String columnName) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            if (!meta.getColumnLabel(i).equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    static boolean startEdit(IGeoDataset trgFC) {
        IFeatureWorkspace pWorkspace = trgFC.getWorkspace();
        if (pWorkspace == null) {
            return false;
        }
        if (!pWorkspace.getInTransaction()) {
            pWorkspace.beginTransaction();
        }
        return true;
    }

    static void stopEdit(IGeoDataset trgFC, boolean isSave) {
        IFeatureWorkspace pWorkspace = trgFC.getWorkspace();
        if (pWorkspace != null && pWorkspace.getInTransaction()) {
            if (isSave) {
                pWorkspace.commitTransaction();
            } else {
                pWorkspace.rollbackTransaction();
            }
        }
    }

    private void expandExtent(IEnvelope geo, ISpatialReferenceSystem spatialReference) {
        double dis = 0.0;
        dis = spatialReference == null ? (geo.getHeight() <= 180.0 && geo.getWidth() <= 360.0 ? 1.0E-7 : 0.1) : (spatialReference.getType() == SpatialReferenceSystemType.Geographic ? 1.0E-7 : 0.1);
        geo.expand(dis, dis, false);
    }

    protected void updateExtent(IFeatureClass targetFc, String targetDatasetName) {
        try {
            if (targetFc != null) {
                ExtentDTO extentDTO = ImportVector.getExtent((Long)this.sourceParams.getTaskId(), (String)targetDatasetName);
                if (extentDTO == null) {
                    return;
                }
                IEnvelope extent = GeometryFunc.createEnvelope((double)extentDTO.getXmin(), (double)extentDTO.getYmin(), (double)extentDTO.getXmax(), (double)extentDTO.getYmax());
                if (extent != null && !extent.isEmpty()) {
                    IEnvelope srcExtent = targetFc.getExtent();
                    if (srcExtent != null && !extent.isEmpty()) {
                        extent.setXMin(Math.min(extent.getXMin(), srcExtent.getXMin()));
                        extent.setYMin(Math.min(extent.getYMin(), srcExtent.getYMin()));
                        extent.setXMax(Math.max(extent.getXMax(), srcExtent.getXMax()));
                        extent.setYMax(Math.max(extent.getYMax(), srcExtent.getYMax()));
                    }
                    if (extent.getXMin() == extent.getXMax() || extent.getYMin() == extent.getYMax()) {
                        this.expandExtent(extent, targetFc.getSpatialReferenceSystem());
                    }
                    targetFc.changeExtent(extent);
                }
            }
        }
        catch (Exception var6) {
            this.log.error(targetFc.getName() + "\u66f4\u65b0\u8303\u56f4\u5931\u8d25", (Throwable)var6);
            this.onImportTaskLog(targetFc.getName() + "\u66f4\u65b0\u8303\u56f4\u5931\u8d25");
        }
    }

    protected DatasetRenderDTO publishVectorService(String dsKey, IFeatureClass targetFc) {
        try {
            String serviceName;
            String datasetId = GeoDatasetUtil.getGeoDatasetId((String)dsKey, (IGeoDataset)targetFc);
            DatasetRenderDTO render = this.dataSourceManager.getDatasetRender(datasetId);
            if (render != null && Boolean.TRUE.equals(render.getIsCreate())) {
                serviceName = render.getServiceName();
            } else {
                serviceName = PinyinUtil.convertToPinYin((String)targetFc.getName());
                if (serviceName.length() > 60) {
                    serviceName = serviceName.substring(0, 60);
                }
            }
            VTileServiceCreateDTO serviceCreateDTO = new VTileServiceCreateDTO();
            serviceCreateDTO.setServiceName(serviceName);
            serviceCreateDTO.setDatasetId(datasetId);
            DatasetRenderDTO renderDTO = this.renderIndexService.createVectorRenderIndex(serviceCreateDTO);
            this.onImportTaskLog(targetFc.getName() + "\u77e2\u91cf\u6e32\u67d3\u7d22\u5f15\u521b\u5efa\u6210\u529f");
            return renderDTO;
        }
        catch (Exception var8) {
            this.log.error(targetFc.getName() + "\u77e2\u91cf\u670d\u52a1\u53d1\u5e03\u5931\u8d25", (Throwable)var8);
            this.onImportTaskLog(targetFc.getName() + "\u77e2\u91cf\u6e32\u67d3\u7d22\u5f15\u521b\u5efa\u5931\u8d25\uff0c" + var8.getMessage());
            return null;
        }
    }

    public void importFinised() {
        try {
            if (null == this.targetWorkspace) {
                return;
            }
            List<VectorImportPluginInputDataParams> inputDatas = this.settingParams.getInputDatas();
            List<String> layerNames = inputDatas.stream().map(l -> l.getTargetLayerName()).distinct().collect(Collectors.toList());
            layerNames.forEach(datasetName -> {
                IGeoDataset targetDataset = this.targetWorkspace.openGeoDataset(datasetName);
                if (targetDataset instanceof IFeatureClass) {
                    IFeatureClass targetFc = (IFeatureClass)targetDataset;
                    this.updateExtent(targetFc, (String)datasetName);
                    if (Boolean.TRUE.equals(this.sourceParams.getAutoCreateIndex())) {
                        this.publishVectorService(this.targetParams.targetDatabaseKey, targetFc);
                    }
                }
            });
        }
        catch (Exception var3) {
            this.log.error("\u5165\u5e93\u540e\u64cd\u4f5c\u5f02\u5e38", (Throwable)var3);
            this.onImportTaskLog(var3.getMessage());
        }
    }

    public void dispose() {
        try {
            if (this.targetWorkspace != null) {
                this.targetWorkspace.close();
            }
        }
        catch (Exception e) {
            this.log.error("\u5165\u5e93\u540e\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
        }
    }

    protected long deleteRows(ITable table, String whereClause) {
        try {
            Date startTime = new Date();
            QueryFilter filter = new QueryFilter();
            filter.setWhereClause(whereClause);
            long deletecount = table.deleteRow((IQueryFilter)filter);
            this.onImportDataLog(String.format("[%s]\u5220\u9664\u6570\u636e%s\u4e2a\uff1a%s", table.getName(), deletecount, DateTimeUtil.getTimeIntervalStr((Date)startTime, (Date)new Date())));
            return deletecount;
        }
        catch (Exception var7) {
            this.log.error("\u5220\u9664\u6570\u636e\u5931\u8d25", (Throwable)var7);
            this.onImportDataLog("\u5220\u9664\u6570\u636e\u5931\u8d25\uff0c" + var7.getMessage());
            return -1L;
        }
    }

    public IFeature getFeatureByBSM(IFeatureClass targetFeatureClass, Object bsm) {
        QueryFilter queryFilter = new QueryFilter();
        queryFilter.setLimit(Integer.valueOf(1));
        queryFilter.setOffset(Integer.valueOf(0));
        Iterator fieldIterator = targetFeatureClass.getFields().iterator();
        ArrayList<String> subFields = new ArrayList<String>();
        while (fieldIterator.hasNext()) {
            IField var5 = (IField)fieldIterator.next();
            if (var5.getPhysicalName() != null && !var5.getPhysicalName().isEmpty()) {
                subFields.add("\"" + var5.getPhysicalName() + "\"");
                continue;
            }
            subFields.add(var5.getName());
        }
        queryFilter.setSubFields(String.join((CharSequence)",", subFields));
        String whereStr = " bsm ='" + bsm + "'";
        queryFilter.setWhereClause(whereStr);
        IFeatureCursor featureCursor = targetFeatureClass.searchFeature((IQueryFilter)queryFilter);
        return featureCursor.nextFeature();
    }

    private static /* synthetic */ void lambda$executeImport$0(String[] geomField, IFields targetFields, String[] oidField, AutoimportRel f) {
        if (f.getFieldtype() == 14) {
            geomField[0] = f.getFieldname();
            targetFields.addField((IField)new GeometryField(f.getFieldname(), f.getFieldalias(), GeometryType.MultiPolygon, c.createSpatialReference((int)4490), CoordinateType.XY));
        } else if (f.getFieldtype() == 4097) {
            oidField[0] = f.getFieldname();
            targetFields.addField((IField)new Field(f.getFieldname(), f.getFieldalias(), FieldType.getByValue((Integer)f.getFieldtype())));
        } else {
            targetFields.addField((IField)new Field(f.getFieldname(), f.getFieldalias(), FieldType.getByValue((Integer)f.getFieldtype())));
        }
    }

    public static class VectorImportPluginInputDataParams
    implements IImportParams {
        private String SourceLayerName;
        private String TargetLayerName;
        private String TimePhase;

        public String getSourceLayerName() {
            return this.SourceLayerName;
        }

        public String getTargetLayerName() {
            return this.TargetLayerName;
        }

        public String getTimePhase() {
            return this.TimePhase;
        }

        public void setSourceLayerName(String SourceLayerName) {
            this.SourceLayerName = SourceLayerName;
        }

        public void setTargetLayerName(String TargetLayerName) {
            this.TargetLayerName = TargetLayerName;
        }

        public void setTimePhase(String TimePhase) {
            this.TimePhase = TimePhase;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VectorImportPluginInputDataParams)) {
                return false;
            }
            VectorImportPluginInputDataParams other = (VectorImportPluginInputDataParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$SourceLayerName = this.getSourceLayerName();
            String other$SourceLayerName = other.getSourceLayerName();
            if (this$SourceLayerName == null ? other$SourceLayerName != null : !this$SourceLayerName.equals(other$SourceLayerName)) {
                return false;
            }
            String this$TargetLayerName = this.getTargetLayerName();
            String other$TargetLayerName = other.getTargetLayerName();
            if (this$TargetLayerName == null ? other$TargetLayerName != null : !this$TargetLayerName.equals(other$TargetLayerName)) {
                return false;
            }
            String this$TimePhase = this.getTimePhase();
            String other$TimePhase = other.getTimePhase();
            return !(this$TimePhase == null ? other$TimePhase != null : !this$TimePhase.equals(other$TimePhase));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VectorImportPluginInputDataParams;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $SourceLayerName = this.getSourceLayerName();
            result = result * 59 + ($SourceLayerName == null ? 43 : $SourceLayerName.hashCode());
            String $TargetLayerName = this.getTargetLayerName();
            result = result * 59 + ($TargetLayerName == null ? 43 : $TargetLayerName.hashCode());
            String $TimePhase = this.getTimePhase();
            result = result * 59 + ($TimePhase == null ? 43 : $TimePhase.hashCode());
            return result;
        }

        public String toString() {
            return "BgdcDBImportPlugin.VectorImportPluginInputDataParams(SourceLayerName=" + this.getSourceLayerName() + ", TargetLayerName=" + this.getTargetLayerName() + ", TimePhase=" + this.getTimePhase() + ")";
        }
    }

    public static class VectorImportPluginSettingParams
    implements IImportParams {
        private String sourceFilePath;
        private Boolean overwrite;
        private List<VectorImportPluginInputDataParams> inputDatas;

        public String getSourceFilePath() {
            return this.sourceFilePath;
        }

        public Boolean getOverwrite() {
            return this.overwrite;
        }

        public List<VectorImportPluginInputDataParams> getInputDatas() {
            return this.inputDatas;
        }

        public void setSourceFilePath(String sourceFilePath) {
            this.sourceFilePath = sourceFilePath;
        }

        public void setOverwrite(Boolean overwrite) {
            this.overwrite = overwrite;
        }

        public void setInputDatas(List<VectorImportPluginInputDataParams> inputDatas) {
            this.inputDatas = inputDatas;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VectorImportPluginSettingParams)) {
                return false;
            }
            VectorImportPluginSettingParams other = (VectorImportPluginSettingParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$overwrite = this.getOverwrite();
            Boolean other$overwrite = other.getOverwrite();
            if (this$overwrite == null ? other$overwrite != null : !((Object)this$overwrite).equals(other$overwrite)) {
                return false;
            }
            String this$sourceFilePath = this.getSourceFilePath();
            String other$sourceFilePath = other.getSourceFilePath();
            if (this$sourceFilePath == null ? other$sourceFilePath != null : !this$sourceFilePath.equals(other$sourceFilePath)) {
                return false;
            }
            List<VectorImportPluginInputDataParams> this$inputDatas = this.getInputDatas();
            List<VectorImportPluginInputDataParams> other$inputDatas = other.getInputDatas();
            return !(this$inputDatas == null ? other$inputDatas != null : !((Object)this$inputDatas).equals(other$inputDatas));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VectorImportPluginSettingParams;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $overwrite = this.getOverwrite();
            result = result * 59 + ($overwrite == null ? 43 : ((Object)$overwrite).hashCode());
            String $sourceFilePath = this.getSourceFilePath();
            result = result * 59 + ($sourceFilePath == null ? 43 : $sourceFilePath.hashCode());
            List<VectorImportPluginInputDataParams> $inputDatas = this.getInputDatas();
            result = result * 59 + ($inputDatas == null ? 43 : ((Object)$inputDatas).hashCode());
            return result;
        }

        public String toString() {
            return "BgdcDBImportPlugin.VectorImportPluginSettingParams(sourceFilePath=" + this.getSourceFilePath() + ", overwrite=" + this.getOverwrite() + ", inputDatas=" + this.getInputDatas() + ")";
        }
    }

    public static class VectorImportPluginTargetParams
    implements IImportParams {
        private String targetDatabaseKey;
        private String targetDatabaseName;
        private String targetDatasetId;
        private String targetFilestorageKey;
        private String targetFilestorageUrl;

        public String getTargetDatabaseKey() {
            return this.targetDatabaseKey;
        }

        public String getTargetDatabaseName() {
            return this.targetDatabaseName;
        }

        public String getTargetDatasetId() {
            return this.targetDatasetId;
        }

        public String getTargetFilestorageKey() {
            return this.targetFilestorageKey;
        }

        public String getTargetFilestorageUrl() {
            return this.targetFilestorageUrl;
        }

        public void setTargetDatabaseKey(String targetDatabaseKey) {
            this.targetDatabaseKey = targetDatabaseKey;
        }

        public void setTargetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
        }

        public void setTargetDatasetId(String targetDatasetId) {
            this.targetDatasetId = targetDatasetId;
        }

        public void setTargetFilestorageKey(String targetFilestorageKey) {
            this.targetFilestorageKey = targetFilestorageKey;
        }

        public void setTargetFilestorageUrl(String targetFilestorageUrl) {
            this.targetFilestorageUrl = targetFilestorageUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VectorImportPluginTargetParams)) {
                return false;
            }
            VectorImportPluginTargetParams other = (VectorImportPluginTargetParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$targetDatabaseKey = this.getTargetDatabaseKey();
            String other$targetDatabaseKey = other.getTargetDatabaseKey();
            if (this$targetDatabaseKey == null ? other$targetDatabaseKey != null : !this$targetDatabaseKey.equals(other$targetDatabaseKey)) {
                return false;
            }
            String this$targetDatabaseName = this.getTargetDatabaseName();
            String other$targetDatabaseName = other.getTargetDatabaseName();
            if (this$targetDatabaseName == null ? other$targetDatabaseName != null : !this$targetDatabaseName.equals(other$targetDatabaseName)) {
                return false;
            }
            String this$targetDatasetId = this.getTargetDatasetId();
            String other$targetDatasetId = other.getTargetDatasetId();
            if (this$targetDatasetId == null ? other$targetDatasetId != null : !this$targetDatasetId.equals(other$targetDatasetId)) {
                return false;
            }
            String this$targetFilestorageKey = this.getTargetFilestorageKey();
            String other$targetFilestorageKey = other.getTargetFilestorageKey();
            if (this$targetFilestorageKey == null ? other$targetFilestorageKey != null : !this$targetFilestorageKey.equals(other$targetFilestorageKey)) {
                return false;
            }
            String this$targetFilestorageUrl = this.getTargetFilestorageUrl();
            String other$targetFilestorageUrl = other.getTargetFilestorageUrl();
            return !(this$targetFilestorageUrl == null ? other$targetFilestorageUrl != null : !this$targetFilestorageUrl.equals(other$targetFilestorageUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VectorImportPluginTargetParams;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $targetDatabaseKey = this.getTargetDatabaseKey();
            result = result * 59 + ($targetDatabaseKey == null ? 43 : $targetDatabaseKey.hashCode());
            String $targetDatabaseName = this.getTargetDatabaseName();
            result = result * 59 + ($targetDatabaseName == null ? 43 : $targetDatabaseName.hashCode());
            String $targetDatasetId = this.getTargetDatasetId();
            result = result * 59 + ($targetDatasetId == null ? 43 : $targetDatasetId.hashCode());
            String $targetFilestorageKey = this.getTargetFilestorageKey();
            result = result * 59 + ($targetFilestorageKey == null ? 43 : $targetFilestorageKey.hashCode());
            String $targetFilestorageUrl = this.getTargetFilestorageUrl();
            result = result * 59 + ($targetFilestorageUrl == null ? 43 : $targetFilestorageUrl.hashCode());
            return result;
        }

        public String toString() {
            return "BgdcDBImportPlugin.VectorImportPluginTargetParams(targetDatabaseKey=" + this.getTargetDatabaseKey() + ", targetDatabaseName=" + this.getTargetDatabaseName() + ", targetDatasetId=" + this.getTargetDatasetId() + ", targetFilestorageKey=" + this.getTargetFilestorageKey() + ", targetFilestorageUrl=" + this.getTargetFilestorageUrl() + ")";
        }
    }
}

