-- tb_mdc_application definition

-- Drop table

-- DROP TABLE tb_mdc_application;

CREATE TABLE tb_mdc_application (
	f_id varchar(50) NOT NULL,
	f_name varchar(100) NULL,
	f_appid varchar(100) NULL,
	f_appsecret varchar(100) NULL,
	f_type varchar(20) NULL,
	f_state bool NULL,
	f_department varchar(100) NULL,
	f_phonenumber varchar(20) NULL,
	f_email varchar(50) NULL,
	f_registertime timestamp(6) NULL,
	f_description varchar(500) NULL,
	f_version varchar(20) NULL,
	CONSTRAINT tb_mdc_application_pkey PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_mdc_application IS '应用信息表';

-- Column comments

COMMENT ON COLUMN tb_mdc_application.f_name IS '名称';
COMMENT ON COLUMN tb_mdc_application.f_appid IS '应用id，应用唯一标识';
COMMENT ON COLUMN tb_mdc_application.f_appsecret IS '应用私钥';
COMMENT ON COLUMN tb_mdc_application.f_type IS '类型：Android应用、Iphone应用、客户端应用、web端应用、其他';
COMMENT ON COLUMN tb_mdc_application.f_state IS '应用状态：0-禁用；1-启用';
COMMENT ON COLUMN tb_mdc_application.f_department IS '注册单位';
COMMENT ON COLUMN tb_mdc_application.f_phonenumber IS '运维电话';
COMMENT ON COLUMN tb_mdc_application.f_email IS '运维邮箱';
COMMENT ON COLUMN tb_mdc_application.f_registertime IS '注册时间';
COMMENT ON COLUMN tb_mdc_application.f_description IS '应用简介';
COMMENT ON COLUMN tb_mdc_application.f_version IS '应用版本';
-- tb_mdc_application_api definition

-- Drop table

-- DROP TABLE tb_mdc_application_api;

CREATE TABLE tb_mdc_application_api (
	f_namespace varchar(255) NOT NULL,
	f_apiname varchar(255) NOT NULL,
	f_tableid varchar(50) NULL,
	f_sqlfilterstr varchar(500) NULL,
	f_desc varchar(255) NULL,
	f_status int4 DEFAULT 0 NULL,
	f_id varchar(50) NOT NULL,
	f_primary varchar(255) NULL,
	f_auto_create int2 NULL,
	f_admin int2 NULL,
	f_datasourcekey varchar NULL,
	f_filestoragekey varchar NULL,
	CONSTRAINT tb_mdc_application_api_pkey PRIMARY KEY (f_id)
);

-- Column comments

COMMENT ON COLUMN tb_mdc_application_api.f_namespace IS '命名空间';
COMMENT ON COLUMN tb_mdc_application_api.f_apiname IS '接口名称';
COMMENT ON COLUMN tb_mdc_application_api.f_sqlfilterstr IS '数据过滤条件';
COMMENT ON COLUMN tb_mdc_application_api.f_status IS '是否启用';
COMMENT ON COLUMN tb_mdc_application_api.f_primary IS '数据唯一值字段';
COMMENT ON COLUMN tb_mdc_application_api.f_datasourcekey IS '数据库key';
COMMENT ON COLUMN tb_mdc_application_api.f_filestoragekey IS '对象存储数据库key';
