/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.glfx.service.imp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.entity.ResCatalogNode;
import com.geoway.adf.dms.catalog.service.impl.ResCatalogNodeServiceImpl;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.ns.geoserver3.dto.ServiceMetadataDAO;
import com.geoway.ns.geoserver3.dto.TbAnalysisBaseInfo;
import com.geoway.ns.geoserver3.dto.TbAnalysisGLFXDetail;
import com.geoway.ns.geoserver3.dto.TbAnalysisGLFX_YZFX;
import com.geoway.ns.geoserver3.dto.TbAnalysisYZFXDetail;
import com.geoway.ns.geoserver3.dto.TbAnalysisYZFXField;
import com.geoway.ns.geoserver3.service.IGLFXService;
import com.geoway.ns.geoserver3.service.IYZFXService;
import com.geoway.ns.geoserver3.service.impl.DatabaseServiceImpl;
import com.geoway.ns.onemap.glfx.dto.GLFXGraphAndFields;
import com.geoway.ns.onemap.glfx.entity.TbGLFX;
import com.geoway.ns.onemap.glfx.entity.TbGLFXGraph;
import com.geoway.ns.onemap.glfx.entity.TbGLFXTable;
import com.geoway.ns.onemap.glfx.entity.TbGLFXTableField;
import com.geoway.ns.onemap.glfx.mapper.TbGLFXMapper;
import com.geoway.ns.onemap.glfx.mapper.TbGLFXTableMapper;
import com.geoway.ns.onemap.glfx.service.TbGLFXGraphService;
import com.geoway.ns.onemap.glfx.service.TbGLFXTableFieldService;
import com.geoway.ns.onemap.glfx.service.TbGLFXTableService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

@Service
public class TbGLFXTableServiceImpl
extends ServiceImpl<TbGLFXTableMapper, TbGLFXTable>
implements TbGLFXTableService {
    @Autowired
    private TbGLFXTableMapper tbGLFXTableMapper;
    @Autowired
    private TbGLFXMapper tbGLFXMapper;
    @Autowired
    private TbGLFXGraphService tbGLFXGraphService;
    @Autowired
    private TbGLFXTableFieldService tbGLFXTableFieldService;
    @Autowired
    private IGLFXService glfxService;
    @Autowired
    private IYZFXService yzfxService;
    @Autowired
    private DatabaseServiceImpl databaseService;
    @Autowired
    private ResCatalogNodeServiceImpl resCatalogService;

    @Override
    public List<TbGLFXTable> selectByGLFX(Long glfxId, boolean queryDisplayConfigStatus, boolean queryDataNode) {
        List lshsTables = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbGLFXTable.class).eq(TbGLFXTable::getGlfxId, (Object)glfxId)).orderByAsc(TbGLFXTable::getOrder));
        if (queryDisplayConfigStatus) {
            this.queryDisplayConfigStatus(lshsTables);
        }
        this.queryNodesDetail(lshsTables, queryDataNode);
        return lshsTables;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TbGLFXTable addOrUpdate(TbGLFXTable tbGLFXTable) {
        ArrayList<TbGLFXTable> list = new ArrayList<TbGLFXTable>();
        list.add(tbGLFXTable);
        this.addOrUpdateList(list);
        return tbGLFXTable;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean addOrUpdateList(Collection<TbGLFXTable> collection) {
        if (collection == null || collection.size() == 0) {
            return false;
        }
        List list = (List)collection;
        Long glfxId = ((TbGLFXTable)list.get(0)).getGlfxId();
        TbGLFX tbGLFX = (TbGLFX)this.tbGLFXMapper.selectById(glfxId);
        if ("geoserver".equalsIgnoreCase(tbGLFX.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbGLFX.getUrl())) {
            try {
                this.saveOrUpdateBatch(collection);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        TbAnalysisGLFXDetail glhsDetail = this.glfxService.findById(tbGLFX.getServiceId());
        Integer order = this.tbGLFXTableMapper.selectMaxOrder(glfxId);
        order = order == null ? 1 : order + 1;
        for (TbGLFXTable tbGLFXTable : collection) {
            if (tbGLFXTable.getGlfxId() == null || tbGLFXTable.getGlfxId().equals(-1)) {
                throw new RuntimeException("glfxId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (tbGLFXTable.getNodeId() == null || tbGLFXTable.getNodeId().equals("-1")) {
                throw new RuntimeException("nodeId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.queryNodeDetail(tbGLFXTable, true);
            if (tbGLFXTable.getResCatalogNodeDTO() == null) {
                throw new RuntimeException("\u67e5\u8be2\u76ee\u5f55\u8282\u70b9\u5931\u8d25");
            }
            ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)tbGLFXTable.getResCatalogNodeDTO();
            if (resCatalogDataNodeDTO == null || resCatalogDataNodeDTO.getDataset() == null || resCatalogDataNodeDTO.getDataset().getType().intValue() != DatasetTypeEnum.FeatureClass.getValue()) {
                throw new RuntimeException("\u6240\u9009\u6570\u636e\u96c6\u4e0d\u662f\u5408\u6cd5\u7684\u7a7a\u95f4\u56fe\u5c42");
            }
            this.addOrUpdateYzfxService(tbGLFX, tbGLFXTable);
            if (tbGLFXTable.getId() == null || tbGLFXTable.getId().equals(-1)) {
                Integer n = order;
                Integer n2 = order = Integer.valueOf(order + 1);
                tbGLFXTable.setOrder(n);
                try {
                    this.save(tbGLFXTable);
                }
                catch (Exception e) {
                    this.yzfxService.delete(tbGLFXTable.getServiceId());
                    throw e;
                }
                TbAnalysisGLFX_YZFX glhs_yzfx = new TbAnalysisGLFX_YZFX();
                glhs_yzfx.setGlfxId(glhsDetail.getId());
                glhs_yzfx.setYzfxId(tbGLFXTable.getServiceId());
                glhs_yzfx.setYear(StringUtils.isEmpty((CharSequence)tbGLFXTable.getNodePhase()) ? null : tbGLFXTable.getNodePhase());
                glhs_yzfx.setOrder(tbGLFXTable.getOrder());
                glhsDetail.getYzfxList().add(glhs_yzfx);
            }
            this.updateById(tbGLFXTable);
            Optional<TbAnalysisGLFX_YZFX> optional = glhsDetail.getYzfxList().stream().filter(p -> p.getYzfxId().equals(tbGLFXTable.getServiceId())).findFirst();
            if (optional == null || !optional.isPresent()) continue;
            optional.get().setYear(tbGLFXTable.getNodePhase());
            optional.get().setOrder(tbGLFXTable.getOrder());
        }
        this.glfxService.save(glhsDetail);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(Serializable id) {
        TbGLFXTable tbLSHSTable = (TbGLFXTable)this.tbGLFXTableMapper.selectById(id);
        boolean res = this.removeById(id);
        if (!res) {
            return false;
        }
        this.tbGLFXGraphService.deleteByTableId(tbLSHSTable.getId());
        this.tbGLFXTableFieldService.deleteByTableId(tbLSHSTable.getId());
        TbGLFX tbGLFX = (TbGLFX)this.tbGLFXMapper.selectById(tbLSHSTable.getGlfxId());
        if (!"geoserver".equalsIgnoreCase(tbGLFX.getServiceType()) || !StringUtils.isNotEmpty((CharSequence)tbGLFX.getUrl())) {
            this.deleteGLFXItem(tbLSHSTable, tbGLFX.getServiceId());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteMulti(String ids) {
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return false;
        }
        String[] idArr = ids.split(",");
        for (int i = 0; i < idArr.length; ++i) {
            Long id = Long.valueOf(idArr[i]);
            this.deleteById(id);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteByGLFX(TbGLFX tbGLFX) {
        List<TbGLFXTable> tbLSHSTables = this.selectByGLFX(tbGLFX.getId(), false, false);
        boolean res = this.remove((Wrapper)Wrappers.lambdaQuery(TbGLFXTable.class).eq(TbGLFXTable::getGlfxId, (Object)tbGLFX.getId()));
        if (!res) {
            return false;
        }
        for (TbGLFXTable item : tbLSHSTables) {
            this.tbGLFXGraphService.deleteByTableId(item.getId());
            this.tbGLFXTableFieldService.deleteByTableId(item.getId());
            if ("geoserver".equalsIgnoreCase(tbGLFX.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbGLFX.getUrl())) continue;
            this.deleteGLFXItem(item, tbGLFX.getServiceId());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<TbGLFXTable> syncTables(Long glfxId) {
        List<TbGLFXTable> glfxTables = this.selectByGLFX(glfxId, true, true);
        TbGLFX tbGLFX = (TbGLFX)this.tbGLFXMapper.selectById(glfxId);
        if ("geoserver".equalsIgnoreCase(tbGLFX.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbGLFX.getUrl())) {
            if (glfxTables == null || glfxTables.size() == 0) {
                String accessKey = null;
                if (StringUtils.isNotEmpty((CharSequence)tbGLFX.getOtherParams())) {
                    JSONObject otherParams = JSONObject.parseObject((String)tbGLFX.getOtherParams());
                    accessKey = otherParams.getString("accessKey");
                }
                TbAnalysisGLFXDetail tbAnalysisGLHSDetail = this.glfxService.findByServerUrl(tbGLFX.getUrl(), accessKey);
                String serverRootUrl = tbGLFX.getUrl().split("/rest/glfx/")[0];
                List yzfxLists = null;
                try {
                    yzfxLists = this.yzfxService.findAll(serverRootUrl, accessKey);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (tbAnalysisGLHSDetail != null && tbAnalysisGLHSDetail.getYzfxList() != null && tbAnalysisGLHSDetail.getYzfxList().size() > 0) {
                    for (TbAnalysisGLFX_YZFX yzfx : tbAnalysisGLHSDetail.getYzfxList()) {
                        TbAnalysisBaseInfo result;
                        TbGLFXTable tbLSHSTable = new TbGLFXTable();
                        tbLSHSTable.setGlfxId(glfxId);
                        tbLSHSTable.setServiceId(yzfx.getYzfxId());
                        tbLSHSTable.setOrder(yzfx.getOrder());
                        if (yzfxLists != null && yzfxLists.size() > 0 && (result = (TbAnalysisBaseInfo)yzfxLists.stream().filter(item -> yzfx.getYzfxId().equals(item.getId())).findFirst().orElse(null)) != null) {
                            tbLSHSTable.setServiceName(result.getAlias() + "(" + result.getName() + ")");
                        }
                        if (StringUtils.isEmpty((CharSequence)tbLSHSTable.getServiceName())) {
                            if (StringUtils.isNotEmpty((CharSequence)yzfx.getYear())) {
                                tbLSHSTable.setServiceName(tbAnalysisGLHSDetail.getAlias() + "-" + yzfx.getYear());
                            } else {
                                tbLSHSTable.setServiceName(tbAnalysisGLHSDetail.getAlias() + "-" + yzfx.getYzfxId());
                            }
                        }
                        tbLSHSTable.setServicePhase(yzfx.getYear());
                        if (glfxTables == null) {
                            glfxTables = new ArrayList<TbGLFXTable>();
                        }
                        glfxTables.add(tbLSHSTable);
                    }
                }
            }
        } else {
            List<TbGLFXTable> delTables = glfxTables.stream().filter(p -> p.getResCatalogNodeDTO() == null).collect(Collectors.toList());
            delTables.forEach(p -> this.deleteById(p.getId()));
            glfxTables.removeAll(delTables);
            this.addOrUpdateList(glfxTables);
        }
        return glfxTables;
    }

    @Override
    public boolean displayConfig(GLFXGraphAndFields graphAndFields) {
        if (graphAndFields == null) {
            return false;
        }
        Long tableId = graphAndFields.getTableId();
        if (tableId == null || tableId.equals(-1)) {
            throw new RuntimeException("\u5206\u6790\u9879ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (graphAndFields.getGraph() != null) {
            graphAndFields.getGraph().setTableId(tableId);
            this.tbGLFXGraphService.deleteByTableId(tableId);
            this.tbGLFXGraphService.saveOrUpdateInfo(graphAndFields.getGraph());
        }
        this.tbGLFXTableFieldService.deleteByTableId(tableId);
        this.tbGLFXTableFieldService.batchSaveOrUpdate(tableId, graphAndFields.getFields());
        return true;
    }

    @Override
    public GLFXGraphAndFields queryDisplayConfig(Long id) {
        TbGLFXTable glfxTable = (TbGLFXTable)this.getById(id);
        if (glfxTable == null) {
            throw new RuntimeException("\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        GLFXGraphAndFields graphAndFields = new GLFXGraphAndFields();
        graphAndFields.setTableId(id);
        TbGLFXGraph graph = this.tbGLFXGraphService.queryByTableId(id);
        graphAndFields.setGraph(graph);
        List<TbGLFXTableField> fields = this.tbGLFXTableFieldService.queryByTableId(id);
        Collections.sort(fields);
        graphAndFields.setFields(fields);
        return graphAndFields;
    }

    @Override
    public Map<Long, GLFXGraphAndFields> queryDisplayConfigs(List<Long> ids) {
        List<TbGLFXGraph> glfxGraphs = this.tbGLFXGraphService.queryByTableIds(ids);
        List<TbGLFXTableField> glfxTableFields = this.tbGLFXTableFieldService.queryByTableIds(ids);
        HashMap<Long, GLFXGraphAndFields> mapGLFXGraphAndFields = new HashMap<Long, GLFXGraphAndFields>();
        GLFXGraphAndFields graphAndFields = null;
        for (TbGLFXGraph glfxGraph : glfxGraphs) {
            graphAndFields = new GLFXGraphAndFields();
            graphAndFields.setTableId(glfxGraph.getTableId());
            graphAndFields.setGraph(glfxGraph);
            List<TbGLFXTableField> fields = glfxTableFields.stream().filter(p -> Objects.equals(p.getTableId(), glfxGraph.getTableId())).collect(Collectors.toList());
            Collections.sort(fields);
            graphAndFields.setFields(fields);
            mapGLFXGraphAndFields.put(glfxGraph.getTableId(), graphAndFields);
        }
        return mapGLFXGraphAndFields;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToFirst(Long id) {
        return this.sort(id, 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToLast(Long id) {
        TbGLFXTable curTable = (TbGLFXTable)this.getById(id);
        if (curTable == null) {
            return false;
        }
        TbGLFXTable maxTable = (TbGLFXTable)this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbGLFXTable.class).eq(TbGLFXTable::getGlfxId, (Object)curTable.getGlfxId())).orderByDesc(TbGLFXTable::getOrder)).get(0);
        return this.sort(id, maxTable.getOrder());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToPre(Long id) {
        TbGLFXTable cur = (TbGLFXTable)this.getById(id);
        if (cur == null) {
            return false;
        }
        if (cur.getOrder().equals(1)) {
            return true;
        }
        return this.sort(id, cur.getOrder() - 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToSuffix(Long id) {
        TbGLFXTable cur = (TbGLFXTable)this.getById(id);
        if (cur == null) {
            return false;
        }
        int maxOrder = this.tbGLFXTableMapper.selectMaxOrder(cur.getGlfxId());
        if (cur.getOrder().equals(maxOrder)) {
            return true;
        }
        return this.sort(id, cur.getOrder() + 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sort(Long id, int order) {
        int i;
        TbGLFXTable curTable = (TbGLFXTable)this.getById(id);
        if (curTable == null) {
            return true;
        }
        if (curTable.getOrder().equals(order)) {
            return true;
        }
        List needUpdateList = null;
        if (curTable.getOrder() > order) {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbGLFXTable.class).eq(TbGLFXTable::getGlfxId, (Object)curTable.getGlfxId())).ge(TbGLFXTable::getOrder, (Object)order)).lt(TbGLFXTable::getOrder, (Object)curTable.getOrder())).orderByAsc(TbGLFXTable::getOrder));
            for (i = 0; i < needUpdateList.size(); ++i) {
                ((TbGLFXTable)needUpdateList.get(i)).setOrder(order + i + 1);
            }
        } else {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbGLFXTable.class).eq(TbGLFXTable::getGlfxId, (Object)curTable.getGlfxId())).gt(TbGLFXTable::getOrder, (Object)curTable.getOrder())).le(TbGLFXTable::getOrder, (Object)order)).orderByAsc(TbGLFXTable::getOrder));
            for (i = 0; i < needUpdateList.size(); ++i) {
                ((TbGLFXTable)needUpdateList.get(i)).setOrder(curTable.getOrder() + i);
            }
        }
        curTable.setOrder(order);
        needUpdateList.add(curTable);
        TbGLFX tbGLFX = (TbGLFX)this.tbGLFXMapper.selectById(curTable.getGlfxId());
        if (!"geoserver".equalsIgnoreCase(tbGLFX.getServiceType()) || !StringUtils.isNotEmpty((CharSequence)tbGLFX.getUrl())) {
            TbAnalysisGLFXDetail glfxDetail = this.glfxService.findById(tbGLFX.getServiceId());
            for (TbGLFXTable tbLSHSTable : needUpdateList) {
                Optional<TbAnalysisGLFX_YZFX> optionalGLHS_YZFX = glfxDetail.getYzfxList().stream().filter(p -> p.getYzfxId().equals(tbLSHSTable.getServiceId())).findFirst();
                if (optionalGLHS_YZFX == null || !optionalGLHS_YZFX.isPresent()) continue;
                TbAnalysisGLFX_YZFX glhs_yzfx = optionalGLHS_YZFX.get();
                glhs_yzfx.setOrder(tbLSHSTable.getOrder());
            }
            this.glfxService.save(glfxDetail);
        }
        return this.updateBatchById(needUpdateList);
    }

    @Override
    public ServiceMetadataDAO metadata(Long id) {
        TbGLFXTable tbGLFXTable = (TbGLFXTable)this.tbGLFXTableMapper.selectById(id);
        TbGLFX tbLSHS = (TbGLFX)this.tbGLFXMapper.selectById(tbGLFXTable.getGlfxId());
        if ("geoserver".equalsIgnoreCase(tbLSHS.getServiceType()) && StringUtils.isNotEmpty((CharSequence)tbLSHS.getUrl())) {
            String applicationGuid = null;
            String accessKey = null;
            if (StringUtils.isNotEmpty((CharSequence)tbLSHS.getOtherParams())) {
                JSONObject otherParams = JSONObject.parseObject((String)tbLSHS.getOtherParams());
                applicationGuid = otherParams.getString("ApplicationGUID");
                accessKey = otherParams.getString("accessKey");
            }
            String serverRootUrl = tbLSHS.getUrl().split("/rest/glfx/")[0];
            TbAnalysisYZFXDetail yzfxDetail = this.yzfxService.findById(serverRootUrl, tbGLFXTable.getServiceId(), accessKey);
            String yzfxServiceUrl = serverRootUrl + "/rest/yzfx/" + yzfxDetail.getName();
            return this.yzfxService.metadata(yzfxServiceUrl, applicationGuid, accessKey);
        }
        TbAnalysisYZFXDetail yzfxDetail = this.yzfxService.findById(tbGLFXTable.getServiceId());
        return this.yzfxService.metadata(yzfxDetail.getName());
    }

    private void queryDisplayConfigStatus(List<TbGLFXTable> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        List<Long> tableIds = list.stream().map(p -> p.getId()).collect(Collectors.toList());
        List<TbGLFXGraph> lstGraphs = this.tbGLFXGraphService.queryByTableIds(tableIds);
        Map<Long, TbGLFXGraph> mapGraphs = lstGraphs.stream().collect(Collectors.toMap(TbGLFXGraph::getTableId, person -> person));
        for (TbGLFXTable glfxTable : list) {
            if (mapGraphs.containsKey(glfxTable.getId())) {
                glfxTable.setDisplayConfigStatus(1);
                continue;
            }
            glfxTable.setDisplayConfigStatus(0);
        }
    }

    private void queryNodesDetail(List<TbGLFXTable> glfxTables, boolean queryDataNode) {
        if (glfxTables == null) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        for (TbGLFXTable glfxTable : glfxTables) {
            this.queryNodeDetail(glfxTable, queryDataNode);
        }
        stopWatch.stop();
        System.out.println(String.format("\u67e5\u8be2\u8d44\u6e90\u76ee\u5f55%d\u4e2a\u8282\u70b9\u8be6\u60c5\u8017\u65f6\uff1a%f\u79d2", glfxTables.size(), stopWatch.getTotalTimeSeconds()));
    }

    private void queryNodeDetail(TbGLFXTable glfxTable, boolean queryDataNode) {
        if (queryDataNode) {
            ResCatalogNodeDTO resCatalogNodeDTO = null;
            if (glfxTable.getResCatalogNodeDTO() == null) {
                try {
                    resCatalogNodeDTO = this.resCatalogService.getNodeDetail(glfxTable.getNodeId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                resCatalogNodeDTO = glfxTable.getResCatalogNodeDTO();
            }
            if (resCatalogNodeDTO == null) {
                return;
            }
            ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
            if (resCatalogDataNodeDTO == null) {
                return;
            }
            glfxTable.setResCatalogNodeDTO(resCatalogNodeDTO);
            glfxTable.setNodeName(resCatalogDataNodeDTO.getNodeName());
            glfxTable.setNodePhase(((ResCatalogDataNodeDTO)resCatalogNodeDTO).getNodePhase());
            DatasetDTO dataset = resCatalogDataNodeDTO.getDataset();
            String datasourceStr = dataset.getDataSource().getName() + ">" + dataset.getName() + "\uff08" + dataset.getAliasName() + "\uff09";
            glfxTable.setDataSource(datasourceStr);
            glfxTable.setRender(resCatalogDataNodeDTO.getRender());
        } else {
            ResCatalogNode resCatalogNode = this.resCatalogService.selectByNodeId(glfxTable.getNodeId());
            glfxTable.setNodeName(resCatalogNode.getNodeName());
            glfxTable.setNodePhase(resCatalogNode.getDataPhase());
            glfxTable.setDataSource(resCatalogNode.getDatasetName());
            DatasetRenderDTO datasetRenderDTO = this.resCatalogService.getNodeRender(glfxTable.getNodeId());
            glfxTable.setRender(datasetRenderDTO);
        }
    }

    private void addOrUpdateYzfxService(TbGLFX tbGLFX, TbGLFXTable tbLSHSTable) {
        ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)tbLSHSTable.getResCatalogNodeDTO();
        if (!this.databaseService.addDatabase(resCatalogDataNodeDTO.getDataset().getDsKey())) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u65b0\u589e\u6570\u636e\u6e90\u5931\u8d25");
        }
        FeatureClassDTO featureDatasetDTO = (FeatureClassDTO)resCatalogDataNodeDTO.getDataset();
        String oidField = featureDatasetDTO.getOidField().toUpperCase();
        String shapeField = featureDatasetDTO.getShapeField().toUpperCase();
        List fields = featureDatasetDTO.getFields();
        TbAnalysisYZFXDetail yzfxDetail = null;
        if (!StringUtils.isEmpty((CharSequence)tbLSHSTable.getServiceId())) {
            yzfxDetail = this.yzfxService.findById(tbLSHSTable.getServiceId());
        }
        if (yzfxDetail == null) {
            yzfxDetail = new TbAnalysisYZFXDetail();
            String serviceName = "ONEMAP_glhs_" + tbGLFX.getId() + "_" + featureDatasetDTO.getName();
            String serviceAlias = "\u4e00\u5f20\u56fe_\u5173\u8054\u56de\u6eaf_" + tbGLFX.getAlias() + "_" + resCatalogDataNodeDTO.getNodeName();
            serviceName = this.realYZFXServiceName(serviceName);
            yzfxDetail.setName(serviceName);
            yzfxDetail.setAlias(serviceAlias);
        }
        yzfxDetail.setGroup("\u4e00\u5f20\u56fe4.0-\u5173\u8054\u56de\u6eaf");
        yzfxDetail.setStatus(Integer.valueOf(1));
        yzfxDetail.setLayer(featureDatasetDTO.getName());
        yzfxDetail.setLayerAlias(featureDatasetDTO.getAliasName());
        yzfxDetail.setDatasourceKey(featureDatasetDTO.getDsKey());
        yzfxDetail.setPrimaryField(oidField);
        yzfxDetail.setShapeField(shapeField);
        yzfxDetail.setFields(this.getYZFXField(fields));
        yzfxDetail.setInputParams(new ArrayList());
        if (!StringUtils.isEmpty((CharSequence)tbLSHSTable.getNodePhase())) {
            ArrayList<JSONObject> lstGeoserverMapping = new ArrayList<JSONObject>();
            JSONObject tempGeoserverMapping = new JSONObject();
            tempGeoserverMapping.put("datasourceKey", (Object)featureDatasetDTO.getDsKey());
            tempGeoserverMapping.put("version", (Object)tbLSHSTable.getNodePhase());
            tempGeoserverMapping.put("tableName", (Object)featureDatasetDTO.getName());
            lstGeoserverMapping.add(tempGeoserverMapping);
            yzfxDetail.setVersionTableMapping(JSON.toJSONString(lstGeoserverMapping));
        } else {
            yzfxDetail.setVersionTableMapping(null);
        }
        yzfxDetail = this.yzfxService.save(yzfxDetail);
        tbLSHSTable.setServiceId(yzfxDetail.getId());
    }

    private String realYZFXServiceName(String yzfxServiceName) {
        String realServiceName = yzfxServiceName;
        if (this.yzfxService.checkIsExist(yzfxServiceName)) {
            for (int i = 1; i < Integer.MAX_VALUE && this.yzfxService.checkIsExist(realServiceName = yzfxServiceName + "_" + i); ++i) {
            }
        }
        return realServiceName;
    }

    private List<TbAnalysisYZFXField> getYZFXField(List<FieldDTO> fields) {
        ArrayList<TbAnalysisYZFXField> fieldList = new ArrayList<TbAnalysisYZFXField>();
        TbAnalysisYZFXField tbAnalysisYZFXField = null;
        int order = 1;
        for (FieldDTO field : fields) {
            tbAnalysisYZFXField = new TbAnalysisYZFXField();
            tbAnalysisYZFXField.setName(field.getName());
            tbAnalysisYZFXField.setAlias(field.getAliasName());
            tbAnalysisYZFXField.setReturnName(field.getName().toUpperCase());
            tbAnalysisYZFXField.setType(this.covertType(field.getFieldType()));
            tbAnalysisYZFXField.setOrder(Integer.valueOf(order++));
            fieldList.add(tbAnalysisYZFXField);
        }
        return fieldList;
    }

    private String covertType(int value) {
        FieldType fieldType = FieldType.getByValue((Integer)value);
        switch (fieldType) {
            case Int: {
                return "int4";
            }
            case OID: {
                return "oid";
            }
            case Blob: {
                return "blob";
            }
            case Byte: {
                return "byte";
            }
            case Long: {
                return "long";
            }
            case Text: 
            case String: {
                return "string";
            }
            case Float: {
                return "float";
            }
            case Shape: {
                return "geometry";
            }
            case Short: {
                return "short";
            }
            case Double: {
                return "double";
            }
            case Boolean: {
                return "boolean";
            }
            case Decimal: {
                return "decimal";
            }
            default: {
                return "unknown";
            }
            case DateTime: 
        }
        return "datetime";
    }

    private void deleteGLFXItem(TbGLFXTable tbGLFXTable, String glfxServiceId) {
        try {
            this.yzfxService.delete(tbGLFXTable.getServiceId());
            TbAnalysisGLFXDetail glhsDetail = this.glfxService.findById(glfxServiceId);
            List glhsYzfxList = glhsDetail.getYzfxList();
            Optional<TbAnalysisGLFX_YZFX> optionalItem = glhsYzfxList.stream().filter(p -> p.getYzfxId().equals(tbGLFXTable.getServiceId())).findFirst();
            if (optionalItem != null && optionalItem.isPresent()) {
                glhsYzfxList.remove(optionalItem.get());
                this.glfxService.save(glhsDetail);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

