/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.controller.ztfx;

import com.geoway.ns.geoserver3.dto.ServiceMetadataDAO;
import com.geoway.ns.onemap.ztfx.dto.ZTFXGraphAndFields;
import com.geoway.ns.onemap.ztfx.entity.TbZTFXCatalog;
import com.geoway.ns.onemap.ztfx.service.TbZTFXCatalogService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e13\u9898\u5206\u6790\u76ee\u5f55\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/ztfx/catalog"})
public class TbZTFXCatalogController {
    private static final Logger log = LoggerFactory.getLogger(TbZTFXCatalogController.class);
    @Autowired
    private TbZTFXCatalogService tbZTFXCatalogService;

    @ApiOperation(value="0-\u67e5\u8be2\u8282\u70b9\u8be6\u60c5\uff08\u540c\u65f6\u540c\u6b65\u8d44\u6e90\u76ee\u5f55\u4e0a\u7684\u4fe1\u606f\u548c\u5bf9\u5e94\u7684\u5206\u6790\u670d\u52a1\uff09")
    @RequestMapping(value={"queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<TbZTFXCatalog> queryDetail(@RequestParam(value="id") String id) {
        TbZTFXCatalog ztfxCatalog = this.tbZTFXCatalogService.queryDetail(id, true);
        return DataResponse.success((Object)ztfxCatalog);
    }

    @ApiOperation(value="1-\u67e5\u8be2\u76ee\u5f55\u6811")
    @RequestMapping(value={"/tree"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<List<TbZTFXCatalog>> queryTree(String schemeId, String name) {
        List<TbZTFXCatalog> lshsList = this.tbZTFXCatalogService.queryTree(schemeId, name);
        return DataResponse.success(lshsList);
    }

    @ApiOperation(value="2-\u6dfb\u52a0\u6216\u66f4\u65b0\u8282\u70b9\uff08\u6216\u5206\u6790\u9879\uff09", notes="1.\u65b0\u589e\u76ee\u5f55\u6839\u8282\u70b9\u65f6\uff0c\u9700\u8bbe\u7f6eschemeId\u3001name\u3001type\u5c5e\u6027\uff1b2.\u65b0\u589e\u76ee\u5f55\u5b50\u8282\u70b9\u65f6\uff0c\u9700\u8bbe\u7f6eschemeId\u3001pId\u3001name\u3001type\u5c5e\u6027\uff1b3.\u4fee\u6539\u76ee\u5f55\u8282\u70b9\u65f6\uff0c\u9700\u8bbe\u7f6eid\u3001schemeId\u3001pId\u3001name\u3001type\u3001order\u5c5e\u6027\uff1b4.\u65b0\u589e\u5206\u6790\u9879\u65f6\uff0c\u9700\u8bbe\u7f6eschemeId\u3001pId\u3001name\u3001type\u3001customServiceClass\u3001versionTableMappings\u5c5e\u6027\uff1b5.\u7f16\u8f91\u5206\u6790\u9879\u65f6\uff0c\u9700\u8bbe\u7f6eid\u3001schemeId\u3001pId\u3001name\u3001type\u3001customServiceClass\u3001versionTableMappings\uff1b(versionTableMappings\u7ed3\u6784\uff1a[{\"datasourceKey\":\"\",\"year\":\"\"}])6.\u65b0\u589e\u7b2c\u4e09\u65b9\u5206\u6790\u670d\u52a1\u65f6\uff0c\u9700\u8bbe\u7f6eschemeId\u3001pId\u3001name\u3001type\u3001serviceName\u3001url\u3001serviceType\u3001otherParams\u3001versionTableMappings\u5c5e\u6027\uff1b7.\u7f16\u8f91\u7b2c\u4e09\u65b9\u5206\u6790\u670d\u52a1\u65f6\uff0c\u9700\u8bbe\u7f6eid\u3001schemeId\u3001pId\u3001name\u3001type\u3001serviceName\u3001url\u3001serviceType\u3001otherParams\u3001versionTableMappings\uff1b(versionTableMappings\u7ed3\u6784\uff1a[{\"datasourceKey\":\"\",\"year\":\"\"}])")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse saveOrUpdate(@RequestBody TbZTFXCatalog tbZTFXCatalog) {
        this.tbZTFXCatalogService.saveOrUpdateInfo(tbZTFXCatalog);
        return BaseResponse.success();
    }

    @ApiOperation(value="3-\u5220\u9664\u8282\u70b9\uff08\u6216\u5206\u6790\u9879\uff09")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse delete(@RequestParam(value="id") String id) {
        this.tbZTFXCatalogService.deleteById(id);
        return BaseResponse.success();
    }

    @ApiOperation(value="4-\u6279\u91cf\u5220\u9664\u8282\u70b9\uff08\u6216\u5206\u6790\u9879\uff09")
    @RequestMapping(value={"/deleteMulti"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse deleteMulti(@RequestParam(value="id") String ids) {
        this.tbZTFXCatalogService.deleteMulti(ids);
        return BaseResponse.success();
    }

    @ApiOperation(value="5-\u8282\u70b9\u7f6e\u9876")
    @RequestMapping(value={"/moveToFirst"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse moveToFirst(@RequestParam(value="id") String id) {
        this.tbZTFXCatalogService.moveToFirst(id);
        return BaseResponse.success();
    }

    @ApiOperation(value="6-\u8282\u70b9\u7f6e\u5e95")
    @RequestMapping(value={"/moveToLast"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse moveToLast(@RequestParam(value="id") String id) {
        this.tbZTFXCatalogService.moveToLast(id);
        return BaseResponse.success();
    }

    @ApiOperation(value="7-\u8282\u70b9\u4e0a\u79fb")
    @RequestMapping(value={"/moveToPre"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse moveToPre(@RequestParam(value="id") String id) {
        this.tbZTFXCatalogService.moveToPre(id);
        return BaseResponse.success();
    }

    @ApiOperation(value="8-\u8282\u70b9\u4e0b\u79fb")
    @RequestMapping(value={"/moveToNext"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse moveToNext(@RequestParam(value="id") String id) {
        this.tbZTFXCatalogService.moveToNext(id);
        return BaseResponse.success();
    }

    @ApiOperation(value="9-\u62d6\u62fd\u6392\u5e8f")
    @RequestMapping(value={"/sort"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse sort(@RequestParam(value="id") String id, @RequestParam(value="order") int order) {
        this.tbZTFXCatalogService.sort(id, order);
        return BaseResponse.success();
    }

    @ApiOperation(value="10-\u8bbe\u7f6e\u5206\u6790\u9879\u7684\u663e\u793a\u914d\u7f6e")
    @RequestMapping(value={"/displayConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse displayConfig(@RequestBody ZTFXGraphAndFields graphAndFields) {
        this.tbZTFXCatalogService.displayConfig(graphAndFields);
        return BaseResponse.success();
    }

    @ApiOperation(value="11-\u67e5\u8be2\u5206\u6790\u9879\u7684\u663e\u793a\u914d\u7f6e")
    @RequestMapping(value={"/queryDisplayConfig"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<ZTFXGraphAndFields> queryDisplayConfig(String id) {
        ZTFXGraphAndFields graphAndFields = this.tbZTFXCatalogService.queryDisplayConfig(id);
        return DataResponse.success((Object)graphAndFields);
    }

    @ApiOperation(value="12-\u67e5\u8be2\u5206\u6790\u9879\u5173\u8054\u7684\u538b\u5360\u5206\u6790\u670d\u52a1\u5143\u6570\u636e")
    @RequestMapping(value={"/metadata"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<ServiceMetadataDAO> metadata(String id) {
        ServiceMetadataDAO metadataDAO = this.tbZTFXCatalogService.metadata(id);
        return DataResponse.success((Object)metadataDAO);
    }

    @ApiOperation(value="13-\u67e5\u8be2\u5206\u6790\u9879\u5206\u6790\u7b97\u6cd5\u5217\u8868")
    @RequestMapping(value={"/listCustoms"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<Object> listCustoms() {
        return DataResponse.success((Object)this.tbZTFXCatalogService.findCustoms());
    }

    @ApiOperation(value="14-\u83b7\u53d6\u5206\u6790\u9879\u7684\u5e95\u56fe")
    @RequestMapping(value={"/queryRender"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<Object> queryRender(String id, String year) {
        return DataResponse.success((Object)this.tbZTFXCatalogService.queryRender(id, year));
    }
}

