/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.service;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.ns.base.util.GeometryUtils;
import com.geoway.ns.geoserver3.dto.ShapeExportDTO;
import com.geoway.ns.geoserver3.dto.WktExportDTO;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.onemap.common.constants.EnumOnlineStatisticsUrl;
import com.geoway.ns.onemap.encrypttool.entity.EncryptType;
import com.geoway.ns.onemap.encrypttool.service.BizEncryptRecordsService;
import com.geoway.ns.sys.utils.UpAndDownloadUtil;
import com.geoway.ns.sys.utils.WorkspaceUtilEx;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AnalysisService {
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;
    @Autowired
    private BizEncryptRecordsService bizEncryptRecordsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject upload(MultipartFile[] files, EncryptType encryptType) throws Exception {
        String curProjectPath = System.getProperty("user.dir");
        String tempDirPath = curProjectPath + File.separator + UUID.randomUUID().toString();
        File tempDirFile = new File(tempDirPath);
        tempDirFile.mkdir();
        try {
            File[] files1 = new File[files.length];
            for (int i = 0; i < files.length; ++i) {
                String tempFilePath = tempDirPath + File.separator + files[i].getOriginalFilename();
                File tempFile = new File(tempFilePath);
                files[i].transferTo(tempFile);
                files1[i] = tempFile;
            }
            JSONObject resultObj = new JSONObject();
            if (files1.length > 0 && files1[0].toString().toLowerCase(Locale.ROOT).endsWith(".shp")) {
                List geometrys = WorkspaceUtilEx.readLocalFileGeometrys((String)files1[0].toString());
                if (geometrys != null) {
                    JSONObject finalResultObj = resultObj;
                    JSONObject blocksObj = new JSONObject();
                    JSONArray jsonArray = new JSONArray();
                    geometrys.forEach(geometry -> {
                        IGeometry geometry1 = this.forceGeometry((IGeometry)geometry);
                        if (finalResultObj.getDouble("ymin") == null || finalResultObj.getDouble("ymin") > geometry1.getEnvelope().getYMin()) {
                            finalResultObj.put("ymin", (Object)geometry1.getEnvelope().getYMin());
                        }
                        if (finalResultObj.getDouble("xmin") == null || finalResultObj.getDouble("xmin") > geometry1.getEnvelope().getXMin()) {
                            finalResultObj.put("xmin", (Object)geometry1.getEnvelope().getXMin());
                        }
                        if (finalResultObj.getDouble("ymax") == null || finalResultObj.getDouble("ymax") < geometry1.getEnvelope().getYMax()) {
                            finalResultObj.put("ymax", (Object)geometry1.getEnvelope().getYMax());
                        }
                        if (finalResultObj.getDouble("xmax") == null || finalResultObj.getDouble("xmax") < geometry1.getEnvelope().getXMax()) {
                            finalResultObj.put("xmax", (Object)geometry1.getEnvelope().getXMax());
                        }
                        JSONObject blockObj = new JSONObject();
                        blockObj.put("wkt", (Object)geometry1.toWkt());
                        jsonArray.add((Object)blockObj);
                    });
                    blocksObj.put("blocks", (Object)jsonArray);
                    resultObj.put("xmxx", (Object)blocksObj);
                    resultObj.put("fileType", (Object)"shp");
                }
            } else {
                String url = this.geoserver3ConfigService.getUrl();
                String serverUrl = url + "/rest/analysis/upload";
                HashMap<String, File[]> paramMap = new HashMap<String, File[]>();
                paramMap.put("fileData", files1);
                String resultStr = HttpUtil.post((String)serverUrl, paramMap);
                resultObj = JSON.parseObject((String)resultStr);
            }
            if (encryptType != EncryptType.None) {
                JSONArray jsonArray = resultObj.getJSONObject("xmxx").getJSONArray("blocks");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    jsonArray.getJSONObject(i).put("wkt", (Object)this.bizEncryptRecordsService.wktEncrypt(jsonArray.getJSONObject(i).getString("wkt"), encryptType));
                }
                resultObj.getJSONObject("xmxx").put("blocks", (Object)jsonArray);
            }
            JSONObject jSONObject = resultObj;
            return jSONObject;
        }
        finally {
            FileUtils.deleteQuietly((File)tempDirFile);
        }
    }

    private IGeometry forceGeometry(IGeometry geometry) {
        GeometryType geometryType = geometry.getType();
        switch (geometryType) {
            case LinearRing: 
            case Curve: {
                return GeometryFunc.forceToLineString((IGeometry)geometry);
            }
            case MultiCurve: {
                return GeometryFunc.forceToMultiLineString((IGeometry)geometry);
            }
            case CurvePolygon: {
                return GeometryFunc.forceToPolygon((IGeometry)geometry);
            }
            case MultiCurvePolygon: 
            case GeometryCollection: {
                return GeometryFunc.forceToMultiPolygon((IGeometry)geometry);
            }
        }
        return geometry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excelExport(HttpServletResponse response, Map<String, Map> jsonParam) throws Exception {
        String curProjectPath = System.getProperty("user.dir");
        String tempDirPath = curProjectPath + File.separator + UUID.randomUUID().toString();
        File tempDirFile = new File(tempDirPath);
        tempDirFile.mkdir();
        try {
            String templateFilePath = tempDirPath + File.separator + "analys.xlsx";
            this.copyTemplateFile(templateFilePath);
            this.exportResult(jsonParam, templateFilePath);
            UpAndDownloadUtil.downloadFile((HttpServletResponse)response, (String)templateFilePath);
        }
        finally {
            FileUtils.deleteQuietly((File)tempDirFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wktExport(HttpServletResponse response, WktExportDTO wktExportDTO) throws Exception {
        String curProjectPath = System.getProperty("user.dir");
        String tempDirPath = curProjectPath + File.separator + UUID.randomUUID().toString();
        File tempDirFile = new File(tempDirPath);
        tempDirFile.mkdir();
        try {
            String destFilePath = null;
            String fileName = wktExportDTO.getFileName();
            if (StringUtils.isEmpty((Object)fileName)) {
                throw new RuntimeException("\u5bfc\u51fa\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (".txt".equals(wktExportDTO.getFileType())) {
                destFilePath = tempDirPath + File.separator + wktExportDTO.getFileName() + ".txt";
            } else if (".shp".equals(wktExportDTO.getFileType())) {
                destFilePath = tempDirPath + File.separator + wktExportDTO.getFileName() + ".zip";
            } else {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u5bfc\u51fa\u683c\u5f0f");
            }
            String url = this.geoserver3ConfigService.getUrl();
            String serverUrl = url + "/rest/analysis/wktExport";
            String paramMapStr = JSON.toJSONString((Object)wktExportDTO);
            HttpResponse httpResponse = HttpRequest.post((String)serverUrl).body(paramMapStr).execute();
            httpResponse.writeBody(destFilePath);
            UpAndDownloadUtil.downloadFile((HttpServletResponse)response, (String)destFilePath);
        }
        finally {
            FileUtils.deleteQuietly((File)tempDirFile);
        }
    }

    public void shapeExport(HttpServletResponse response, ShapeExportDTO dto) throws Exception {
        if (!dto.getInfos().isEmpty()) {
            String dirPath = System.getProperty("user.dir") + File.separator + UUID.randomUUID();
            String dir = dirPath + File.separator + "info";
            File dirFile = new File(dir);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            List infos = dto.getInfos();
            String shapePath = dir + File.separator + "info.shp";
            String encode = dto.getEncode();
            try {
                GeometryUtils.writeShape((String)shapePath, (String)encode, (String)dto.getGeoType(), (String)dto.getShapeKey(), new ArrayList(((Map)infos.get(0)).keySet()), (List)infos);
            }
            catch (Exception e) {
                UpAndDownloadUtil.deleteDirectory((File)dirFile);
                throw new RuntimeException(e);
            }
            File file = new File(dir + "/info.cpg");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(dir + "/info.cpg"));){
                writer.write(encode);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            File zip = ZipUtil.zip((String)dir);
            UpAndDownloadUtil.downloadFile((HttpServletResponse)response, (String)zip.getPath());
            UpAndDownloadUtil.deleteDirectory((File)dirFile);
            UpAndDownloadUtil.deleteDirectory((File)zip);
            FileUtil.del((String)dirPath);
        }
    }

    public JSONObject doCustomStatTask(JSONObject jsonObject) throws IllegalAccessException {
        JSONObject object = new JSONObject();
        if (!jsonObject.isEmpty() && StrUtil.isNotBlank((CharSequence)jsonObject.getString("djfxTaskId"))) {
            String result;
            try {
                String url = this.geoserver3ConfigService.getUrl();
                String serverUrl = url + EnumOnlineStatisticsUrl.GetTaskStat.url;
                result = ((HttpRequest)HttpRequest.post((String)serverUrl).body(jsonObject.toJSONString()).contentType("application/json").charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
                System.out.println("\u7edf\u8ba1\u8bf7\u6c42\u7ed3\u679c\uff1a" + result);
            }
            catch (Exception e) {
                throw new IllegalAccessException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
            }
            object = JSONObject.parseObject((String)result);
        }
        return object;
    }

    public JSONArray doCustomStat(JSONObject jsonObject) throws IllegalAccessException {
        JSONObject object = this.doCustomStatTask(jsonObject);
        String message = object.getString("Message");
        if (StrUtil.isNotBlank((CharSequence)message) && "success".equals(message)) {
            return object.getJSONArray("Results");
        }
        return new JSONArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTemplateFile(String templateFilePath) throws Exception {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            String curProjectPath = System.getProperty("user.dir");
            String templatePath = curProjectPath + File.separator + "data/analys.xlsx";
            File templateFile = new File(templatePath);
            inputStream = templateFile.exists() && templateFile.isFile() ? new FileInputStream(templateFile) : ResourceUtils.getURL((String)"classpath:data/analys.xlsx").openStream();
            File file = new File(templateFilePath);
            outputStream = new FileOutputStream(file);
            byte[] byteStr = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(byteStr)) > 0) {
                outputStream.write(byteStr, 0, len);
            }
            outputStream.flush();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportResult(Map<String, Map> jsonParam, String templateFile) throws Exception {
        XSSFWorkbook wb = null;
        FileOutputStream out = null;
        FileInputStream fileInputStream = null;
        try {
            JSONObject item;
            Map<String, Map> type1 = this.filterByValue(jsonParam, x -> "1".equals(x.get("type")));
            Map<String, Map> type2 = this.filterByValue(jsonParam, x -> "2".equals(x.get("type")));
            File destFile = new File(templateFile);
            fileInputStream = new FileInputStream(destFile);
            wb = new XSSFWorkbook((InputStream)fileInputStream);
            wb.removeSheetAt(0);
            if (type2 != null && type2.size() > 0) {
                JSONObject jsonObject2 = new JSONObject(type2);
                for (String key : jsonObject2.keySet()) {
                    item = jsonObject2.getJSONObject(key);
                    this.createSheetByYJL(wb, item);
                    this.createSheetBySDL(wb, item);
                }
            }
            if (type1 != null && type1.size() > 0) {
                JSONObject jsonObject = new JSONObject(type1);
                for (String key : jsonObject.keySet()) {
                    item = jsonObject.getJSONObject(key);
                    this.createSheet(wb, key, item);
                }
            }
            out = new FileOutputStream(destFile);
            wb.write((OutputStream)out);
            out.flush();
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private <K, V> Map<K, V> filterByValue(Map<K, V> map, Predicate<V> predicate) {
        return map.entrySet().stream().filter(x -> predicate.test(x.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void createSheetBySDL(XSSFWorkbook wb, JSONObject jsonObject) {
        String sheet = jsonObject.getString("sheet") + "_\u4e09\u5927\u7c7b";
        JSONObject colValue = jsonObject.getJSONObject("column");
        JSONArray colData = colValue.getJSONArray("data");
        XSSFSheet workSheet = wb.createSheet(sheet);
        workSheet.setColumnWidth(0, 5120);
        workSheet.setColumnWidth(1, 5120);
        workSheet.setColumnWidth(2, 5120);
        workSheet.setColumnWidth(3, 5120);
        XSSFRow row0 = workSheet.createRow(0);
        row0.setRowStyle((CellStyle)this.createTitleCellStyle(wb));
        row0.setHeightInPoints(60.0f);
        XSSFCell cell = row0.createCell(0);
        cell.setCellValue(colValue.getString("msg"));
        cell.setCellStyle((CellStyle)this.createTitleCellStyle(wb));
        workSheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 3));
        List<String> sdlList = this.getSdl(colData);
        int rowIndex = 1;
        for (String sdl : sdlList) {
            int sdlStartIndex = rowIndex;
            List<String> yjlLst = this.getYJL(sdl, colData);
            for (String yjl : yjlLst) {
                int yjlStartIndex = rowIndex;
                double yjlTotal = 0.0;
                Map<String, Double> ejlLst = this.getEJL(sdl, yjl, colData);
                for (Map.Entry<String, Double> kv : ejlLst.entrySet()) {
                    yjlTotal += kv.getValue().doubleValue();
                    this.createRow(wb, workSheet, rowIndex++, sdl, yjl, kv.getKey(), kv.getValue());
                }
                this.createRow(wb, workSheet, rowIndex++, sdl, yjl, "\u5408\u8ba1", yjlTotal);
                int yjlEndIndex = rowIndex - 1;
                workSheet.addMergedRegion(new CellRangeAddress(yjlStartIndex, yjlEndIndex, 1, 1));
            }
            int sdlEndIndex = rowIndex - 1;
            workSheet.addMergedRegion(new CellRangeAddress(sdlStartIndex, sdlEndIndex, 0, 0));
        }
    }

    private void createRow(XSSFWorkbook wb, XSSFSheet workSheet, int rowIndex, String sdl, String yjl, String ejl, Double value) {
        XSSFRow rowi = workSheet.createRow(rowIndex);
        XSSFCell cell0 = rowi.createCell(0);
        cell0.setCellValue(sdl);
        cell0.setCellStyle((CellStyle)this.createTitleCellStyle(wb));
        XSSFCell cell1 = rowi.createCell(1);
        cell1.setCellValue(yjl);
        cell1.setCellStyle((CellStyle)this.createTitleCellStyle(wb));
        XSSFCell cell2 = rowi.createCell(2);
        cell2.setCellValue(ejl);
        cell2.setCellStyle((CellStyle)this.createTitleCellStyle(wb));
        XSSFCell cell3 = rowi.createCell(3);
        cell3.setCellValue(value.doubleValue());
        cell3.setCellStyle((CellStyle)this.createTitleCellStyle(wb));
    }

    private List<String> getSdl(JSONArray colData) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < colData.size(); ++i) {
            JSONObject col = colData.getJSONObject(i);
            if (col.containsKey((Object)"sdl")) {
                result.add(col.getString("sdl"));
                continue;
            }
            JSONArray children = col.getJSONArray("children");
            if (children.size() <= 0) continue;
            for (int j = 0; j < children.size(); ++j) {
                JSONObject ejObj = children.getJSONObject(j);
                result.add(ejObj.getString("sdl"));
            }
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    private List<String> getYJL(String sdl, JSONArray colData) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < colData.size(); ++i) {
            JSONObject col = colData.getJSONObject(i);
            if (col.containsKey((Object)"sdl") && col.getString("sdl").equals(sdl)) {
                result.add(col.getString("name"));
                continue;
            }
            JSONArray children = col.getJSONArray("children");
            if (children.size() <= 0) continue;
            for (int j = 0; j < children.size(); ++j) {
                JSONObject ejObj = children.getJSONObject(j);
                if (!ejObj.getString("sdl").equals(sdl)) continue;
                result.add(col.getString("name"));
            }
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    private Map<String, Double> getEJL(String sdl, String yjl, JSONArray colData) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (int i = 0; i < colData.size(); ++i) {
            JSONObject col = colData.getJSONObject(i);
            if (!col.getString("name").equals(yjl)) continue;
            if (col.containsKey((Object)"sdl") && col.getString("sdl").equals(sdl)) {
                result.put(col.getString("name") + col.getString("code"), col.getDoubleValue("value"));
                continue;
            }
            JSONArray children = col.getJSONArray("children");
            if (children.size() <= 0) continue;
            for (int j = 0; j < children.size(); ++j) {
                JSONObject ejObj = children.getJSONObject(j);
                if (!ejObj.getString("sdl").equals(sdl)) continue;
                result.put(ejObj.getString("name") + ejObj.getString("code"), ejObj.getDoubleValue("value"));
            }
        }
        return result;
    }

    private void createSheetByYJL(XSSFWorkbook wb, JSONObject jsonObject) {
        String sheet = jsonObject.getString("sheet") + "_\u4e00\u7ea7\u7c7b";
        JSONObject colValue = jsonObject.getJSONObject("column");
        JSONArray colData = colValue.getJSONArray("data");
        XSSFSheet workSheet = wb.createSheet(sheet);
        workSheet.setColumnWidth(0, 5120);
        workSheet.setColumnWidth(1, 5120);
        workSheet.setColumnWidth(2, 5120);
        XSSFRow row0 = workSheet.createRow(0);
        row0.setRowStyle((CellStyle)this.createTitleCellStyle(wb));
        row0.setHeightInPoints(60.0f);
        XSSFCell cell = row0.createCell(0);
        cell.setCellValue(colValue.getString("msg"));
        cell.setCellStyle((CellStyle)this.createTitleCellStyle(wb));
        workSheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 2));
        int rowIndex = 1;
        for (int i = 0; i < colData.size(); ++i) {
            XSSFRow rowi = workSheet.createRow(rowIndex++);
            JSONObject col = colData.getJSONObject(i);
            JSONArray children = col.getJSONArray("children");
            XSSFCell cell0 = rowi.createCell(0);
            cell0.setCellValue(col.getString("name") + col.getString("code"));
            cell0.setCellStyle((CellStyle)this.createTitleCellStyle(wb));
            rowi.createCell(1).setCellValue("\u5408\u8ba1");
            rowi.createCell(2).setCellValue(col.getString("value"));
            if (children.size() <= 0) continue;
            for (int j = 0; j < children.size(); ++j) {
                JSONObject ejObj = children.getJSONObject(j);
                XSSFRow rowj = workSheet.createRow(rowIndex++);
                rowj.createCell(1).setCellValue(ejObj.getString("name") + ejObj.getString("code"));
                rowj.createCell(2).setCellValue(ejObj.getString("value"));
            }
            workSheet.addMergedRegion(new CellRangeAddress(rowIndex - children.size() - 1, rowIndex - 1, 0, 0));
        }
    }

    private void createSheet(XSSFWorkbook wb, String type, JSONObject item) {
        XSSFSheet workSheet = wb.createSheet(item.getString("sheet"));
        XSSFRow row = null;
        ArrayList analItems = new ArrayList();
        HashMap<String, Integer> mapFieldColumnIndex = new HashMap<String, Integer>();
        JSONArray header = item.getJSONArray("header");
        row = workSheet.createRow(0);
        for (int i = 0; i < header.size(); ++i) {
            JSONObject headerObject = header.getJSONObject(i);
            String field = headerObject.getString("field");
            String title = headerObject.getString("title");
            row.createCell(i).setCellValue(title);
            mapFieldColumnIndex.put(field, i);
        }
        int workIndex = 1;
        JSONArray jsonArray = item.getJSONArray("column");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject resultObject = jsonArray.getJSONObject(i);
            row = workSheet.createRow(workIndex);
            for (Map.Entry entry : mapFieldColumnIndex.entrySet()) {
                row.createCell(((Integer)entry.getValue()).intValue()).setCellValue(resultObject.getString((String)entry.getKey()));
            }
            ++workIndex;
        }
    }

    private void createSheet2(XSSFWorkbook wb, JSONObject jsonObject) {
        int i;
        String sheet = jsonObject.get((Object)"sheet").toString();
        JSONArray header = jsonObject.getJSONArray("header");
        String column2 = jsonObject.get((Object)"column").toString();
        JSONArray jsonArray = JSONArray.parseArray((String)column2);
        XSSFSheet workSheet = wb.createSheet(sheet);
        workSheet.setColumnWidth(0, 5120);
        int rowNum = 0;
        XSSFRow row0 = workSheet.createRow(rowNum++);
        row0.setRowStyle((CellStyle)this.createTitleCellStyle(wb));
        for (i = 0; i < header.size(); ++i) {
            JSONObject headerObject = header.getJSONObject(i);
            row0.createCell(i).setCellValue(headerObject.getString("title"));
        }
        for (i = 0; i < jsonArray.size(); ++i) {
            JSONObject yjObject = jsonArray.getJSONObject(i);
            XSSFRow rowi = workSheet.createRow(rowNum++);
            XSSFCell yjCell = rowi.createCell(0);
            yjCell.setCellStyle((CellStyle)this.createYjCellStyle(wb));
            yjCell.setCellValue(yjObject.getString("SDLMC"));
            rowi.createCell(1).setCellValue(yjObject.getString("YZMJ"));
            rowi.createCell(2).setCellValue(yjObject.getString("QZGYMJ"));
            rowi.createCell(3).setCellValue(yjObject.getString("QZJTMJ"));
            JSONArray ejArrary = yjObject.getJSONArray("children");
            if (ejArrary.size() <= 0) continue;
            for (int j = 0; j < ejArrary.size(); ++j) {
                JSONObject ejObj = ejArrary.getJSONObject(j);
                XSSFRow rowj = workSheet.createRow(rowNum++);
                XSSFCell ejCell = rowj.createCell(0);
                ejCell.setCellStyle((CellStyle)this.createEjCellStyle(wb));
                ejCell.setCellValue(ejObj.getString("YJLMC"));
                rowj.createCell(1).setCellValue(ejObj.getString("YZMJ"));
                rowj.createCell(2).setCellValue(ejObj.getString("QZGYMJ"));
                rowj.createCell(3).setCellValue(ejObj.getString("QZJTMJ"));
                JSONArray sjArrary = ejObj.getJSONArray("children");
                if (sjArrary.size() <= 0) continue;
                for (int k = 0; k < sjArrary.size(); ++k) {
                    JSONObject sjObj = sjArrary.getJSONObject(k);
                    XSSFRow rowk = workSheet.createRow(rowNum++);
                    XSSFCell sjCell = rowk.createCell(0);
                    sjCell.setCellStyle((CellStyle)this.createSjCellStyle(wb));
                    sjCell.setCellValue(sjObj.getString("DLMC"));
                    rowk.createCell(1).setCellValue(sjObj.getString("YZMJ"));
                    rowk.createCell(2).setCellValue(sjObj.getString("QZGYMJ"));
                    rowk.createCell(3).setCellValue(sjObj.getString("QZJTMJ"));
                }
            }
        }
    }

    private void createSheet3(XSSFWorkbook wb, JSONObject jsonObject) {
        String sheet = jsonObject.getString("sheet");
        JSONObject colValue = jsonObject.getJSONObject("column");
        JSONArray colData = colValue.getJSONArray("data");
        XSSFSheet workSheet = wb.createSheet(sheet);
        XSSFRow row0 = workSheet.createRow(0);
        row0.setRowStyle((CellStyle)this.createTitleCellStyle(wb));
        row0.createCell(0).setCellValue(colValue.getString("msg"));
        XSSFRow row1 = workSheet.createRow(1);
        XSSFRow row2 = workSheet.createRow(2);
        XSSFRow row3 = workSheet.createRow(3);
        int colIndex = 0;
        for (int i = 0; i < colData.size(); ++i) {
            JSONObject col = colData.getJSONObject(i);
            JSONArray children = col.getJSONArray("children");
            row1.createCell(colIndex).setCellValue(col.getString("name") + col.getString("code"));
            row3.createCell(colIndex).setCellValue(col.getString("value"));
            workSheet.addMergedRegion(new CellRangeAddress(1, 2, colIndex, colIndex));
            ++colIndex;
            if (children.size() <= 0) continue;
            for (int j = 0; j < children.size(); ++j) {
                JSONObject ejObj = children.getJSONObject(j);
                row1.createCell(colIndex).setCellValue("\u5176\u4e2d");
                row2.createCell(colIndex).setCellValue(ejObj.getString("name") + ejObj.getString("code"));
                row3.createCell(colIndex).setCellValue(col.getString("value"));
                workSheet.addMergedRegion(new CellRangeAddress(1, 1, colIndex, colIndex + children.size() - 1));
                ++colIndex;
            }
        }
        workSheet.addMergedRegion(new CellRangeAddress(0, 0, 0, colIndex - 1));
    }

    private XSSFCellStyle createTitleCellStyle(XSSFWorkbook wb) {
        XSSFCellStyle titleStyle = wb.createCellStyle();
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleStyle.setWrapText(true);
        XSSFFont titleFont = wb.createFont();
        titleFont.setBold(true);
        titleFont.setFontName("\u5b8b\u4f53");
        titleFont.setFontHeightInPoints((short)12);
        titleStyle.setFont((Font)titleFont);
        return titleStyle;
    }

    private XSSFCellStyle createYjCellStyle(XSSFWorkbook wb) {
        XSSFCellStyle titleStyle = wb.createCellStyle();
        titleStyle.setAlignment(HorizontalAlignment.LEFT);
        return titleStyle;
    }

    private XSSFCellStyle createEjCellStyle(XSSFWorkbook wb) {
        XSSFCellStyle titleStyle = wb.createCellStyle();
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        return titleStyle;
    }

    private XSSFCellStyle createSjCellStyle(XSSFWorkbook wb) {
        XSSFCellStyle titleStyle = wb.createCellStyle();
        titleStyle.setAlignment(HorizontalAlignment.RIGHT);
        return titleStyle;
    }

    private AnalItem queryItemsByType(String type, JSONObject resultObject) {
        String itemName = "";
        float itemValue = 0.0f;
        itemName = resultObject.getString("name");
        itemValue = resultObject.getFloatValue("value");
        AnalItem item = new AnalItem(itemName, itemValue);
        return item;
    }

    class AnalItem {
        String itemName;
        float itemValue;

        public AnalItem(String itemName, float itemValue) {
            this.itemName = itemName;
            this.itemValue = itemValue;
        }

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public float getItemValue() {
            return this.itemValue;
        }

        public void setItemValue(float itemValue) {
            this.itemValue = itemValue;
        }
    }
}

