/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.controller.encrypttool;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.ns.onemap.encrypttool.entity.BizEncryptRecords;
import com.geoway.ns.onemap.encrypttool.service.BizEncryptRecordsService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.RowsResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u504f\u79fb\u8f6c\u6362\u52a0\u5bc6\u5177"})
@RestController
@RequestMapping(value={"/encryptTool"})
public class EncryptToolController {
    @Autowired
    BizEncryptRecordsService bizEncryptRecordsService;

    @ApiOperation(value="\u67e5\u8be2\u52a0\u5bc6\u8bb0\u5f55\u96c6\u5217\u8868")
    @RequestMapping(value={"/list"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RowsResponse queryeEncryptRecordsList(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size) {
        RowsResponse response = new RowsResponse();
        try {
            if (StrUtil.isEmpty((CharSequence)sortParam)) {
                sortParam = "SORT_uploadtime_ASC";
            }
            IPage<BizEncryptRecords> objectList = this.bizEncryptRecordsService.queryPageByFilter(filterParam, sortParam, page, size);
            response.setRows(objectList.getRecords());
            response.setTotal(Long.valueOf(objectList.getTotal()));
        }
        catch (Exception e) {
            response.setMessage(e.getMessage());
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4fdd\u5b58\u4e0a\u4f20\u52a0\u5bc6\u8bb0\u5f55")
    @PostMapping(value={"save"}, consumes={"multipart/form-data"}, produces={"application/json;charset=UTF-8"})
    public Response<String> saveEncryptRecords(HttpServletRequest request, @RequestPart(value="file", required=false) MultipartFile file) {
        Response response = new Response();
        try {
            response.setData((Object)this.bizEncryptRecordsService.saveEncryptRecords(file));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4fdd\u5b58\u4e0a\u4f20\u52a0\u5bc6\u8bb0\u5f55")
    @PostMapping(value={"saveAsync"}, consumes={"multipart/form-data"}, produces={"application/json;charset=UTF-8"})
    public Response<String> saveEncryptRecordsAsync(HttpServletRequest request, @RequestPart(value="file", required=false) MultipartFile file) {
        Response response = new Response();
        try {
            response.setData((Object)this.bizEncryptRecordsService.saveEncryptRecordsAsync(file));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5220\u9664\u8bb0\u5f55")
    @PostMapping(value={"delete"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse deleteById(HttpServletRequest request, @RequestParam(value="ids", required=true) String ids) {
        BaseResponse response = new BaseResponse();
        try {
            if (StrUtil.isNotBlank((CharSequence)ids)) {
                List<String> idlist = Arrays.asList(ids.split(","));
                this.bizEncryptRecordsService.removeBatchByIds(idlist);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6682\u505c")
    @PostMapping(value={"pause"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse pauseById(HttpServletRequest request, @RequestParam(value="id", required=true) String id) {
        BaseResponse response = new BaseResponse();
        try {
            if (StrUtil.isNotBlank((CharSequence)id)) {
                this.bizEncryptRecordsService.pauseById(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u91cd\u542f")
    @PostMapping(value={"continue"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse continueById(HttpServletRequest request, @RequestParam(value="id", required=true) String id) {
        BaseResponse response = new BaseResponse();
        try {
            if (StrUtil.isNotBlank((CharSequence)id)) {
                this.bizEncryptRecordsService.continueById(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
            response.markFailure(e.getMessage());
        }
        return response;
    }
}

