/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.multidata.support;

import com.geoway.ns.onemap.multidata.enums.ImageLocationEnum;
import com.geoway.ns.onemap.multidata.support.ImgUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;

public class WatermarkUtil {
    public static BufferedImage addWatermark(Image image, Integer type, String watermark, ImageLocationEnum locationEnum, Integer fontSize, String watermarkColor, String bgColor, Integer padding) {
        int imgWidth = image.getWidth(null);
        int imgHeight = image.getHeight(null);
        BufferedImage bufImg = new BufferedImage(imgWidth, imgHeight, 1);
        Graphics2D graphics = bufImg.createGraphics();
        graphics.drawImage(image, 0, 0, imgWidth, imgHeight, null);
        if (padding == null) {
            padding = 10;
        }
        if (type == 1) {
            Color color;
            if (StringUtils.isEmpty((CharSequence)watermark)) {
                throw new RuntimeException("\u6587\u5b57\u6c34\u5370\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (fontSize == null) {
                fontSize = 45;
            }
            graphics.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, fontSize));
            Integer[] xy = WatermarkUtil.getXY(imgWidth, imgHeight, WatermarkUtil.getWatermarkLength(watermark, graphics), fontSize, padding, locationEnum);
            if (StringUtils.isNotEmpty((CharSequence)bgColor)) {
                color = WatermarkUtil.decodeColor(bgColor);
                int bgWidth = WatermarkUtil.getWatermarkLength(watermark, graphics) + 4;
                int bgHeight = fontSize + 4;
                graphics.setColor(color);
                graphics.fillRect(xy[0], xy[1], bgWidth, bgHeight);
            }
            if (StringUtils.isNotEmpty((CharSequence)watermarkColor)) {
                color = Color.decode(watermarkColor);
                graphics.setColor(color);
            } else {
                graphics.setColor(new Color(255, 255, 255, 128));
            }
            graphics.drawString(watermark, xy[0] + 2, xy[1] + fontSize);
            graphics.dispose();
        } else {
            if (StringUtils.isEmpty((CharSequence)watermark)) {
                throw new RuntimeException("\u56fe\u7247\u6c34\u5370\u5b58\u653e\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Image srcWatermark = null;
            srcWatermark = ImgUtils.isBase64Encode(watermark) ? ImgUtils.base64ToImage(watermark) : WatermarkUtil.readLocalPicture(watermark);
            int watermarkWidth = srcWatermark.getWidth(null);
            int watermarkHeight = srcWatermark.getHeight(null);
            graphics.setComposite(AlphaComposite.getInstance(10, 0.9f));
            Integer[] xy = WatermarkUtil.getXY(imgWidth, imgHeight, watermarkWidth, watermarkHeight, padding, locationEnum);
            graphics.drawImage(srcWatermark, xy[0], xy[1], watermarkWidth, watermarkHeight, null);
            graphics.dispose();
        }
        return bufImg;
    }

    private static Integer[] getXY(int imgWidth, int imgHeight, int wmWidth, int wmHeight, int padding, ImageLocationEnum locationEnum) {
        if (locationEnum == ImageLocationEnum.center) {
            int x = (imgWidth - wmWidth) / 2;
            int y = imgHeight / 2;
            return new Integer[]{x, y};
        }
        if (locationEnum == ImageLocationEnum.topLeft) {
            int x = padding;
            int y = padding;
            return new Integer[]{x, y};
        }
        if (locationEnum == ImageLocationEnum.topReight) {
            int x = imgWidth - wmWidth - padding;
            int y = padding;
            return new Integer[]{x, y};
        }
        if (locationEnum == ImageLocationEnum.bottomLeft) {
            int x = padding;
            int y = imgHeight - wmHeight - padding;
            return new Integer[]{x, y};
        }
        if (locationEnum == ImageLocationEnum.bottomRight) {
            int x = imgWidth - wmWidth - padding;
            int y = imgHeight - wmHeight - padding;
            return new Integer[]{x, y};
        }
        return new Integer[]{0, 0};
    }

    public static BufferedImage addWatermark(Integer pictureType, Integer watermarkType, String path, String watermark) {
        if (null == pictureType) {
            throw new RuntimeException("\u56fe\u7247\u6765\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == watermarkType) {
            throw new RuntimeException("\u6c34\u5370\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Image image = pictureType == 1 ? WatermarkUtil.readLocalPicture(path) : WatermarkUtil.readNetworkPicture(path);
        if (watermarkType == 1) {
            return WatermarkUtil.addWatermark(image, 1, watermark, ImageLocationEnum.center, 45, null, null, null);
        }
        return WatermarkUtil.addWatermark(image, 2, watermark, ImageLocationEnum.center, 45, null, null, null);
    }

    private static int getWatermarkLength(String watermarkContent, Graphics2D graphics) {
        return graphics.getFontMetrics(graphics.getFont()).charsWidth(watermarkContent.toCharArray(), 0, watermarkContent.length());
    }

    private static Image readLocalPicture(String path) {
        if (null == path) {
            throw new RuntimeException("\u672c\u5730\u56fe\u7247\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        File srcImgFile = new File(path);
        try {
            return ImageIO.read(srcImgFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Image readNetworkPicture(String path) {
        if (null == path) {
            throw new RuntimeException("\u7f51\u7edc\u56fe\u7247\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            URL url = new URL(path);
            BufferedImage bugImg = ImageIO.read(url.openStream());
            if (null == bugImg) {
                throw new RuntimeException("\u7f51\u7edc\u56fe\u7247\u5730\u5740\u4e0d\u6b63\u786e");
            }
            return bugImg;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Color decodeColor(String nm) throws NumberFormatException {
        Integer intval = Integer.decode(nm);
        int i = intval;
        if (nm.length() <= 7) {
            return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
        }
        return new Color(i >> 24 & 0xFF, i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
    }
}

