/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.controller.outside;

import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.onemap.outside.dto.TDTPOIQueryParam;
import com.geoway.ns.onemap.outside.service.TDTPoiService;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u5929\u5730\u56fePOI\u670d\u52a1"})
@Controller
@RequestMapping(value={"/tdt"})
public class TDTQueryController {
    @Autowired
    TDTPoiService poiService;

    @ApiOperation(value="POI\u67e5\u8be2")
    @RequestMapping(value={"/poi.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseObjectResponse queryPoi(HttpServletRequest request, @RequestParam(value="url") String url, @RequestParam(value="xzqdm", required=false, defaultValue="") String xzqdm, @RequestParam(value="keyword") String keyword, @RequestParam(value="page") Integer page, @RequestParam(value="rows") Integer rows, @RequestParam(value="bounds") String bounds, @RequestParam(value="level", required=false) Integer level, @RequestParam(value="querytype", required=false, defaultValue="1") String querytype) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            TDTPOIQueryParam queryParam = new TDTPOIQueryParam();
            queryParam.setCount(rows.toString());
            queryParam.setStart(page * rows + "");
            queryParam.setKeyWord(keyword);
            queryParam.setQueryType(querytype);
            if (level == null) {
                queryParam.setLevel("10");
            } else {
                queryParam.setLevel(level + "");
            }
            if (StringUtils.isNotEmpty((CharSequence)xzqdm)) {
                queryParam.setSpecifyAdminCode(156 + xzqdm);
            }
            queryParam.setMapBound(bounds);
            String userAgent = request.getHeader("user-agent");
            String result = this.poiService.queryPoiResult(queryParam, url, userAgent);
            JSONObject jsonObj = JSONObject.parseObject((String)result);
            response.setData((Object)jsonObj);
        }
        catch (Exception ex) {
            response.setMessage(ex.getMessage());
            response.setStatus("FAILURE");
        }
        return response;
    }

    @ApiOperation(value="POI\u67e5\u8be2")
    @RequestMapping(value={"/suggest.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseObjectResponse querySuggest(HttpServletRequest request, @RequestParam(value="url") String url, @RequestParam(value="xzqdm", required=false) String xzqdm, @RequestParam(value="keyword") String keyword, @RequestParam(value="page") Integer page, @RequestParam(value="rows") Integer rows, @RequestParam(value="bounds") String bounds, @RequestParam(value="level", required=false) Integer level) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            TDTPOIQueryParam queryParam = new TDTPOIQueryParam();
            queryParam.setCount(rows.toString());
            queryParam.setStart(page.toString());
            queryParam.setKeyWord(keyword);
            queryParam.setQueryType("4");
            queryParam.setLevel(level != null ? level + "" : "10");
            if (StringUtils.isNotEmpty((CharSequence)xzqdm)) {
                queryParam.setSpecifyAdminCode(156 + xzqdm);
            }
            queryParam.setMapBound(bounds);
            String userAgent = request.getHeader("user-agent");
            String result = this.poiService.queryPoiResult(queryParam, url, userAgent);
            JSONObject jsonObj = JSONObject.parseObject((String)result);
            response.setData((Object)jsonObj);
        }
        catch (Exception ex) {
            response.setMessage(ex.getMessage());
            response.setStatus("FAILURE");
        }
        return response;
    }
}

