/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.controller.theme;

import com.geoway.ns.onemap.theme.entity.TbTheme;
import com.geoway.ns.onemap.theme.service.TbThemeService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u4e3b\u9898"})
@RestController
@RequestMapping(value={"/theme/theme"})
public class TbThemeController {
    @Autowired
    private TbThemeService tbThemeService;

    @ApiOperation(value="1-\u6839\u636e\u5206\u7ec4\u83b7\u53d6\u4e3b\u9898\u5217\u8868")
    @GetMapping(value={"/listByGroup/{groupId}"})
    public BaseResponse listByGroup(@PathVariable Long groupId, @RequestParam(value="key", required=false) String key) {
        return DataResponse.success(this.tbThemeService.listByGroup(groupId, key));
    }

    @ApiOperation(value="2-\u4e3b\u9898\u8be6\u60c5")
    @GetMapping(value={"/info/{id}"})
    public BaseResponse info(@PathVariable Long id) {
        return DataResponse.success((Object)this.tbThemeService.info(id));
    }

    @ApiOperation(value="3-\u4e3b\u9898\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    public BaseResponse save(@Valid @RequestBody TbTheme param) {
        return DataResponse.success((Object)this.tbThemeService.addOrUpdate(param));
    }

    @ApiOperation(value="4-\u4e3b\u9898\u5220\u9664(\u5355\u4e2a\u6761\u76ee)")
    @GetMapping(value={"/remove/{id}"})
    public BaseResponse remove(@PathVariable Long id) {
        boolean res = this.tbThemeService.remove(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @ApiOperation(value="5-\u4e3b\u9898\u5220\u9664(\u591a\u4e2a\u6761\u76ee)")
    @PostMapping(value={"/removes"})
    public BaseResponse removes(@Valid @RequestBody List<Long> ids) {
        this.tbThemeService.removes(ids);
        return BaseResponse.success();
    }

    @ApiOperation(value="6-\u4e0a\u4f20\u56fe\u7247", notes="\u5c06\u56fe\u7247\u89e3\u6790\u4e3abase64")
    @PostMapping(value={"/uploadPic"})
    public BaseResponse uploadPic(@RequestPart(value="file") MultipartFile file) {
        return DataResponse.success((String)this.tbThemeService.uploadPic(file));
    }

    @RequestMapping(value={"/updateToFirst"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="7-\u7f6e\u9876")
    public BaseResponse updateToFirst(@RequestParam(value="id") Long id) {
        boolean res = this.tbThemeService.updateToFirst(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToLast"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="8-\u7f6e\u5e95")
    public BaseResponse updateToLast(@RequestParam(value="id") Long id) {
        boolean res = this.tbThemeService.updateToLast(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToPre"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="9-\u4e0a\u79fb")
    public BaseResponse updateToPre(@RequestParam(value="id") Long id) {
        boolean res = this.tbThemeService.updateToPre(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToSuffix"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="10-\u4e0b\u79fb")
    public BaseResponse updateToSuffix(@RequestParam(value="id") Long id) {
        boolean res = this.tbThemeService.updateToSuffix(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/moveSort"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="10-\u62d6\u62fd\u6392\u5e8f")
    public BaseResponse moveSort(@RequestParam(value="id") Long id, @RequestParam(value="targetOrder") Long targetOrder) {
        boolean res = this.tbThemeService.sort(id, targetOrder);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }
}

