CREATE SEQUENCE tb_onemap4_scene_center_f_id_seq
    START WITH 1 INCREMENT BY 1
    CACHE 1;

CREATE TABLE "tb_onemap4_scene_center" (
 "f_id" int8 NOT NULL DEFAULT nextval('tb_onemap4_scene_center_f_id_seq'::regclass),
 "f_name" varchar(100) NOT NULL,
 "f_address" varchar(200) ,
 "f_systemaddress" varchar(200) ,
 "f_unifiedbanner" bool NOT NULL DEFAULT false,
 "f_accesstips" bool NOT NULL DEFAULT false,
 "f_singlelogin" bool NOT NULL DEFAULT false,
 "f_fmurls" varchar(500) ,
 "f_order" int8 NOT NULL,
 CONSTRAINT "tb_onemap4_scene_center_pkey" PRIMARY KEY ("f_id")
);
COMMENT ON COLUMN "tb_onemap4_scene_center"."f_name" IS '场景名称';
COMMENT ON COLUMN "tb_onemap4_scene_center"."f_address" IS '场景地址';
COMMENT ON COLUMN "tb_onemap4_scene_center"."f_systemaddress" IS '系统地址';
COMMENT ON COLUMN "tb_onemap4_scene_center"."f_unifiedbanner" IS '使用统一banner';
COMMENT ON COLUMN "tb_onemap4_scene_center"."f_accesstips" IS '无法访问提示';
COMMENT ON COLUMN "tb_onemap4_scene_center"."f_singlelogin" IS '单点登录';
COMMENT ON COLUMN "tb_onemap4_scene_center"."f_fmurls" IS '场景卡片背景';
COMMENT ON COLUMN "tb_onemap4_scene_center"."f_order" IS '排序';

CREATE TABLE "tb_sys_power" (
 "f_id" varchar(64) NOT NULL,
 "f_power_type" varchar(50) ,
 "f_mandate_id" varchar(255) ,
 "f_mandate_name" varchar(255) ,
 "f_mandate_time" timestamp(6),
 "f_mandate_type" int2 DEFAULT 1,
 "f_mandate_limit_start" timestamp(6),
 "f_mandate_limit_end" timestamp(6),
 "f_relation_id" varchar ,
 "f_relation_type" varchar ,
 "f_param" text,
 CONSTRAINT "tb_sys_power_pkey" PRIMARY KEY ("f_id")
);
COMMENT ON COLUMN "tb_sys_power"."f_power_type" IS '授权类型（gzt/工作台、cjzx/场景中心）';
COMMENT ON COLUMN "tb_sys_power"."f_mandate_id" IS '授权主体id';
COMMENT ON COLUMN "tb_sys_power"."f_mandate_name" IS '授权主体名称';
COMMENT ON COLUMN "tb_sys_power"."f_mandate_time" IS '授权时间（操作时间）';
COMMENT ON COLUMN "tb_sys_power"."f_mandate_type" IS '1.永久有效  2.阶段有效';
COMMENT ON COLUMN "tb_sys_power"."f_mandate_limit_start" IS '授权开始时间';
COMMENT ON COLUMN "tb_sys_power"."f_mandate_limit_end" IS '授权结束时间';
COMMENT ON COLUMN "tb_sys_power"."f_relation_id" IS '关联id';
COMMENT ON COLUMN "tb_sys_power"."f_relation_type" IS '关联类型（user、role）';
COMMENT ON COLUMN "tb_sys_power"."f_param" IS '扩展参数';