/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.bdc.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.service.ResCatalogNodeService;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.ns.onemap.bdc.dto.BdcQueryDTO;
import com.geoway.ns.onemap.bdc.entity.TbBdcConfig;
import com.geoway.ns.onemap.bdc.mapper.TbBdcConfigMapper;
import com.geoway.ns.onemap.bdc.service.TbBdcConfigService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TbBdcConfigServiceImpl
extends ServiceImpl<TbBdcConfigMapper, TbBdcConfig>
implements TbBdcConfigService {
    private final String children = "children";
    @Autowired
    private ResCatalogNodeService resCatalogNodeService;
    @Autowired
    private GeoDatabaseService geoDatabaseService;

    @Override
    public List<Map<String, Object>> queryZD(BdcQueryDTO dto) {
        TbBdcConfig bdcConfig = this.getByCid(dto.getCid());
        String zdjbxx = bdcConfig.getZdjbxx();
        String fdcq1 = bdcConfig.getFdcq1();
        ArrayList<String> wheres = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)dto.getZdzl())) {
            wheres.add(" \"ZL\" like '%" + dto.getZdzl() + "%' ");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getDjh())) {
            wheres.add(" \"DJH\" like '%" + dto.getDjh() + "%' ");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getZddm())) {
            wheres.add(" \"ZDDM\" = '" + dto.getZddm() + "' ");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getBdcdyh())) {
            wheres.add(" \"BDCDYH\" = '" + dto.getBdcdyh() + "' ");
        }
        if (wheres.size() == 0) {
            throw new RuntimeException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String where = String.join((CharSequence)" and ", wheres);
        List<Map<String, Object>> zdResult = this.queryResult(zdjbxx, where);
        if (!zdResult.isEmpty()) {
            List bdcdyh = zdResult.stream().map(m -> m.get("BDCDYH").toString()).collect(Collectors.toList());
            where = " \"BDCDYH\" in ('" + String.join((CharSequence)"','", bdcdyh) + "') and \"QSZT\"='1' ";
            List<Map<String, Object>> fdcqResult = this.queryResult(fdcq1, where);
            if (!fdcqResult.isEmpty()) {
                Map<Object, List<Map>> group = fdcqResult.stream().collect(Collectors.groupingBy(m -> m.get("BDCDYH")));
                for (Map<String, Object> map : zdResult) {
                    map.put("children", group.get(map.get("BDCDYH").toString()));
                }
            }
        }
        return zdResult;
    }

    @Override
    public List<Map<String, Object>> queryZ(BdcQueryDTO dto) {
        String where;
        TbBdcConfig bdcConfig = this.getByCid(dto.getCid());
        String zrz = bdcConfig.getZrz();
        String ljz = bdcConfig.getLjz();
        ArrayList<String> wheres = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)dto.getXmmc())) {
            wheres.add(" \"XMMC\" like '%" + dto.getXmmc() + "%' ");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getBdcdyh())) {
            wheres.add(" \"BDCDYH\" like '%" + dto.getBdcdyh() + "%' ");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getZddm())) {
            wheres.add(" \"ZDDM\" = '" + dto.getZddm() + "' ");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getLjzh())) {
            where = " \"LJZH\" = '" + dto.getLjzh() + "' ";
            Map<String, Object> ljzRes = this.queryResultMap(ljz, where);
            wheres.add(" \"ZRZH\" = '" + ljzRes.get("ZRZH") + "' ");
        }
        if (wheres.size() == 0) {
            throw new RuntimeException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        where = String.join((CharSequence)" and ", wheres);
        List<Map<String, Object>> zrzResult = this.queryResult(zrz, where);
        if (!zrzResult.isEmpty()) {
            List zrzh = zrzResult.stream().map(m -> m.get("ZRZH").toString()).collect(Collectors.toList());
            where = " \"ZRZH\" in ('" + String.join((CharSequence)"','", zrzh) + "') ";
            List<Map<String, Object>> ljzResult = this.queryResult(ljz, where);
            if (!ljzResult.isEmpty()) {
                Map<Object, List<Map>> group = ljzResult.stream().collect(Collectors.groupingBy(m -> m.get("ZRZH")));
                for (Map<String, Object> map : zrzResult) {
                    map.put("children", group.get(map.get("ZRZH")));
                }
            }
        }
        return zrzResult;
    }

    @Override
    public Map<String, Map<String, List<Map<String, Object>>>> queryBdcdy(BdcQueryDTO dto) {
        String where;
        List<Map<String, Object>> hResult;
        TbBdcConfig bdcConfig = this.getByCid(dto.getCid());
        String hsx = bdcConfig.getHsx();
        ArrayList<String> wheres = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)dto.getBdcdyh())) {
            wheres.add(" \"BDCDYH\" like '%" + dto.getBdcdyh() + "%' ");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getLjzh())) {
            CharSequence[] split = dto.getLjzh().split(",");
            wheres.add(" \"LJZH\" in ('" + String.join((CharSequence)"','", split) + "') ");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getHzl())) {
            wheres.add(" \"ZL\" like '%" + dto.getHzl() + "%' ");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getQlrxm())) {
            String qlr = bdcConfig.getQlr();
            List<Map<String, Object>> qlrRes = this.queryResult(qlr, " \"QLRMC\" like '%" + dto.getQlrxm() + "%'");
            if (!qlrRes.isEmpty()) {
                List bdcdyh = qlrRes.stream().map(m -> m.get("BDCDYH").toString()).collect(Collectors.toList());
                if (!bdcdyh.isEmpty()) {
                    wheres.add(" \"BDCDYH\" in ('" + String.join((CharSequence)"','", bdcdyh) + "') ");
                }
            } else {
                return null;
            }
        }
        if ((hResult = this.queryResult(hsx, where = String.join((CharSequence)" and ", wheres))).isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, List<Map<String, Object>>>> result = new HashMap<String, Map<String, List<Map<String, Object>>>>();
        Map<String, List<Map>> map = hResult.stream().collect(Collectors.groupingBy(g -> g.get("LJZH").toString()));
        for (Map.Entry<String, List<Map>> entry : map.entrySet()) {
            List<Map> value = entry.getValue();
            Map<String, List<Map>> ch = value.stream().collect(Collectors.groupingBy(g -> g.get("CH").toString()));
            result.put(entry.getKey(), ch);
        }
        return result;
    }

    @Override
    public Map<String, Object> queryH(BdcQueryDTO dto) {
        String fdcq2;
        List<Map<String, Object>> fdRes;
        TbBdcConfig bdcConfig = this.getByCid(dto.getCid());
        String hsx = bdcConfig.getHsx();
        ArrayList<String> wheres = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)dto.getBdcdyh())) {
            wheres.add(" \"BDCDYH\" = '" + dto.getBdcdyh() + "' ");
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getHh())) {
            wheres.add(" \"HH\" = '" + dto.getHh() + "' ");
        }
        if (wheres.size() == 0) {
            throw new RuntimeException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String where = String.join((CharSequence)" and ", wheres);
        Map<String, Object> map = this.queryResultMap(hsx, where);
        if (map == null) {
            return null;
        }
        String csx = bdcConfig.getCsx();
        Map<String, Object> cMap = this.queryResultMap(csx, where = " \"LJZH\" = '" + map.get("LJZH") + "' and \"CH\" = '" + map.get("CH") + "' ");
        if (cMap != null) {
            map.putAll(cMap);
        }
        if (CollectionUtil.isNotEmpty(fdRes = this.queryResult(fdcq2 = bdcConfig.getFdcq2(), where = " \"BDCDYH\" = '" + dto.getBdcdyh() + "' and \"QSZT\"='1' "))) {
            Map fdMap = fdRes.get(0);
            if (fdRes.size() > 1) {
                Map flag = fdRes.stream().filter(f -> f.get("FLAG") == null).findFirst().orElse(null);
                fdMap = flag == null ? (Map)fdRes.stream().max(Comparator.comparing(c -> ((Date)c.get("DJSJ")).getTime())).orElse(null) : fdMap;
            }
            String qlr = bdcConfig.getQlr();
            where = " \"BDCDYH\"  = '" + fdMap.get("BDCDYH") + "' and \"YWH\" = '" + fdMap.get("YWH") + "' ";
            List<Map<String, Object>> maps = this.queryResult(qlr, where);
            map.put("children", maps);
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> queryDj(BdcQueryDTO dto) {
        TbBdcConfig bdcConfig = this.getByCid(dto.getCid());
        String dj = this.getDjType(bdcConfig, dto.getDjType());
        String where = " \"BDCDYH\" = '" + dto.getBdcdyh() + "' and \"QSZT\"='1' ";
        List<Map<String, Object>> maps = this.queryResult(dj, where);
        return maps;
    }

    @Override
    public List<Map<String, Object>> queryZddj(BdcQueryDTO dto) {
        String where;
        TbBdcConfig bdcConfig = this.getByCid(dto.getCid());
        String jsyd = bdcConfig.getJsyd();
        List<Map<String, Object>> maps = this.queryResult(jsyd, where = "  \"BDCDYH\" =  '" + dto.getBdcdyh() + "' ");
        if (maps.isEmpty()) {
            return null;
        }
        List ywh = maps.stream().map(m -> m.get("YWH").toString()).collect(Collectors.toList());
        String dj = this.getDjType(bdcConfig, dto.getDjType());
        where = where + " and \"YWH\" in ('" + String.join((CharSequence)"','", ywh) + "') and \"QSZT\"='1' ";
        return this.queryResult(dj, where);
    }

    @Override
    public List<Map<String, Object>> queryCenterPoint(BdcQueryDTO dto) {
        String pointType;
        TbBdcConfig bdcConfig = this.getByCid(dto.getCid());
        Object point = null;
        String queryDb = null;
        ArrayList<String> wheres = new ArrayList<String>();
        switch (pointType = dto.getPointType()) {
            case "zd": {
                queryDb = bdcConfig.getZdjbxxKj();
                if (StringUtils.isNotEmpty((CharSequence)dto.getZddm())) {
                    wheres.add(" \"ZDDM\" = '" + dto.getZddm() + "' ");
                }
                if (!StringUtils.isNotEmpty((CharSequence)dto.getBdcdyh())) break;
                wheres.add(" \"BDCDYH\" = '" + dto.getBdcdyh() + "' ");
                break;
            }
            case "zrz": {
                queryDb = bdcConfig.getZrzkj();
                if (StringUtils.isNotEmpty((CharSequence)dto.getBdcdyh())) {
                    wheres.add(" \"BDCDYH\" = '" + dto.getBdcdyh() + "' ");
                }
                wheres.add(" \"ZRZH\" = '" + dto.getZrzh() + "' ");
                break;
            }
            default: {
                throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u7c7b\u578b\u3010" + pointType + "\u3011");
            }
        }
        String where = String.join((CharSequence)" and ", wheres);
        List<Map<String, Object>> maps = this.queryResults(queryDb, where);
        for (Map<String, Object> map : maps) {
            Object o = map.get("shape");
            if (o != null) {
                IGeometry geometry = (IGeometry)o;
                double x = geometry.getEnvelope().getCenter().getX();
                double y = geometry.getEnvelope().getCenter().getY();
                map.put("shape", String.format("Point(%s %s)", x, y));
            }
            map.remove("SHAPE");
        }
        return maps;
    }

    private String getDjType(TbBdcConfig bdcConfig, String djType) {
        String dj = bdcConfig.getGzdj();
        if ("yg".equals(djType)) {
            dj = bdcConfig.getYgdj();
        } else if ("yy".equals(djType)) {
            dj = bdcConfig.getYydj();
        } else if ("cf".equals(djType)) {
            dj = bdcConfig.getCfdj();
        } else if ("dy".equals(djType)) {
            dj = bdcConfig.getDyqs();
        }
        return dj;
    }

    private TbBdcConfig getByCid(String catalogId) {
        return (TbBdcConfig)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbBdcConfig.class).eq(TbBdcConfig::getCatalogId, (Object)catalogId)).last("limit 1"));
    }

    private List<Map<String, Object>> queryResult(String nodeId, String where) {
        QueryFilter queryFilter = new QueryFilter();
        queryFilter.setWhereClause(where);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        ResCatalogDataNodeDTO nodeDetail = (ResCatalogDataNodeDTO)this.resCatalogNodeService.getNodeDetail(nodeId);
        DatasetDTO dataset = nodeDetail.getDataset();
        List fields = nodeDetail.getFields();
        List queryFields = fields.stream().filter(f -> f.getDisplay()).map(m -> m.getName()).collect(Collectors.toList());
        try (IFeatureWorkspace featureWorkspace = this.geoDatabaseService.openGeoWorkspace(dataset.getDsKey());){
            ITable openTable = featureWorkspace.openTable(dataset.getName());
            ICursor iCursor = openTable.searchRow((IQueryFilter)queryFilter);
            IRow row = iCursor.nextRow();
            while (row != null) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                if (CollectionUtil.isEmpty(queryFields)) {
                    for (String field : iCursor.getFields()) {
                        result.put(field.getName(), row.getValue(field.getName()));
                    }
                } else {
                    for (String field : queryFields) {
                        result.put(field, row.getValue(field));
                    }
                }
                results.add(result);
                row = iCursor.nextRow();
            }
        }
        return results;
    }

    private List<Map<String, Object>> queryResults(String nodeId, String where) {
        QueryFilter queryFilter = new QueryFilter();
        queryFilter.setWhereClause(where);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        ResCatalogDataNodeDTO nodeDetail = (ResCatalogDataNodeDTO)this.resCatalogNodeService.getNodeDetail(nodeId);
        DatasetDTO dataset = nodeDetail.getDataset();
        IFeatureWorkspace featureWorkspace = this.geoDatabaseService.openGeoWorkspace(dataset.getDsKey());
        List fields = nodeDetail.getFields();
        List queryFields = fields.stream().filter(f -> f.getDisplay() != false && !f.getName().equals("shape")).map(m -> m.getName()).collect(Collectors.toList());
        try {
            IFeatureClass featureClass = featureWorkspace.openFeatureClass(dataset.getName());
            IFeatureCursor iFeatureCursor = featureClass.searchFeature((IQueryFilter)queryFilter);
            IFeature iFeature = iFeatureCursor.nextFeature();
            while (iFeature != null) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                IGeometry geometry = iFeature.getGeometry();
                if (CollectionUtil.isEmpty(queryFields)) {
                    for (String field : iFeature.getFields()) {
                        result.put(field.getName(), iFeature.getValue(field.getName()));
                    }
                } else {
                    for (String field : queryFields) {
                        result.put(field, iFeature.getValue(field));
                    }
                }
                result.put("shape", geometry);
                results.add(result);
                iFeature = iFeatureCursor.nextFeature();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(nodeDetail.getNodeName() + " \u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            featureWorkspace.close();
        }
        return results;
    }

    private Map<String, Object> queryResultMap(String nodeId, String where) {
        List<Map<String, Object>> maps = this.queryResult(nodeId, where);
        if (maps.isEmpty()) {
            return null;
        }
        return maps.get(0);
    }
}

