/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.controller.ztfx;

import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.onemap.ztfx.dto.SingleZTFXRequestData;
import com.geoway.ns.onemap.ztfx.dto.SingleZTFXResult;
import com.geoway.ns.onemap.ztfx.entity.TbZTFXScheme;
import com.geoway.ns.onemap.ztfx.service.TbZTFXSchemeService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.RestResult;
import com.geoway.ns.sys.dto.ResultResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e13\u9898\u5206\u6790\u65b9\u6848\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/ztfx/scheme"})
public class TbZTFXSchemeController {
    private static final Logger log = LoggerFactory.getLogger(TbZTFXSchemeController.class);
    @Autowired
    private TbZTFXSchemeService tbZTFXSchemeService;

    @ApiOperation(value="1-\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<List<TbZTFXScheme>> selectAll(String group) throws Exception {
        List<TbZTFXScheme> lshsList = this.tbZTFXSchemeService.queryList(group);
        return DataResponse.success(lshsList);
    }

    @ApiOperation(value="1-\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/listByUser"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<List<TbZTFXScheme>> listByUser() throws Exception {
        List<TbZTFXScheme> lshsList = this.tbZTFXSchemeService.listByUser();
        return DataResponse.success(lshsList);
    }

    @ApiOperation(value="2-\u67e5\u8be2\u9ed8\u8ba4\u65b9\u6848")
    @RequestMapping(value={"/queryDefault"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<TbZTFXScheme> queryDefault() {
        return DataResponse.success((Object)this.tbZTFXSchemeService.queryDefault());
    }

    @ApiOperation(value="3-\u4fdd\u5b58\u6216\u66f4\u65b0")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse saveOrUpdate(TbZTFXScheme tbZTFXScheme) {
        this.tbZTFXSchemeService.saveOrUpdateInfo(tbZTFXScheme);
        return BaseResponse.success();
    }

    @ApiOperation(value="4-\u5220\u9664")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse schemeDelete(@RequestParam(value="id") String id) {
        this.tbZTFXSchemeService.deleteById(id);
        return BaseResponse.success();
    }

    @ApiOperation(value="5-\u8bbe\u7f6e\u9ed8\u8ba4\u65b9\u6848")
    @RequestMapping(value={"/setDefault"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse setDefault(@RequestParam(value="id") String id) {
        this.tbZTFXSchemeService.setDefault(id);
        return BaseResponse.success();
    }

    @ApiOperation(value="7-\u5355\u4e2a\u5206\u6790\u9879\u8fdb\u884c\u5206\u6790")
    @RequestMapping(value={"/singleAnalysis"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse singleAnalysis(@RequestBody SingleZTFXRequestData requestData) {
        SingleZTFXResult result = this.tbZTFXSchemeService.singleAnalysis(requestData);
        return ResultResponse.success((Object)result);
    }

    @ApiOperation(value="4-\u83b7\u53d6\u538b\u8986\u4fe1\u606f\uff08\u901a\u8fc7\u4efb\u52a1id\u7edf\u8ba1\uff09")
    @RequestMapping(value={"/getCoverInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public BaseResponse getCoverInfo(@RequestParam String uniqueTaskId, @RequestParam(required=false) String catalogId) {
        JSONObject result = null;
        JSONObject responseObj = this.tbZTFXSchemeService.getCoverInfo(uniqueTaskId, catalogId);
        if (!responseObj.getInteger("StatusCode").equals(200)) {
            log.error(responseObj.getString("Message"));
            throw new RuntimeException(responseObj.getString("Message"));
        }
        result = responseObj.getJSONObject("Results");
        return DataResponse.success((Object)result);
    }

    @ApiOperation(value="\u65b9\u6848\u6dfb\u52a0\u7528\u6237")
    @RequestMapping(value={"/addPlanUser"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<String> addPlanUser(String planId, String ids, @RequestHeader(value="Access_token") String token) {
        try {
            String msg = this.tbZTFXSchemeService.addPlanUser(token, planId, ids);
            return RestResult.success((Object)msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)("\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u65b9\u6848\u5220\u9664\u7528\u6237")
    @RequestMapping(value={"/deletePlanUser"}, method={RequestMethod.DELETE}, produces={"application/json;charset=UTF-8"})
    public RestResult<String> deletePlanUser(@RequestParam String ids) {
        try {
            this.tbZTFXSchemeService.deletePlanUser(ids);
            return RestResult.success((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)("\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u65b9\u6848\u83b7\u53d6\u7528\u6237\u5217\u8868")
    @RequestMapping(value={"/queryPlanUserList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public RestResult<Object> queryPlanUserList(String planId, String key, int page, int size) {
        try {
            return RestResult.success(this.tbZTFXSchemeService.queryPlanUserList(planId, key, page, size));
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)("\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }
}

