drop table if exists tb_bdc_config;
CREATE TABLE tb_bdc_config (
	f_id varchar(64) NOT NULL,
	f_catalog_id varchar(64) NULL,
	f_zdjbxx_kj varchar(128) NULL,
	f_zdjbxx varchar(128) NULL,
	f_zrz varchar(128) NULL,
	f_ljz varchar(128) NULL,
	f_csx varchar(128) NULL,
	f_hsx varchar(128) NULL,
	f_qlr varchar(128) NULL,
	f_gzdj varchar(128) NULL,
	f_ygdj varchar(128) NULL,
	f_yydj varchar(128) NULL,
	f_cfdj varchar(128) NULL,
	f_fdcq1 varchar(128) NULL,
	f_fdcq2 varchar(128) NULL,
	f_update_time timestamp NULL,
	CONSTRAINT tb_bdc_config_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_bdc_config IS '不动产数据配置表';

-- Column comments

COMMENT ON COLUMN tb_bdc_config.f_catalog_id IS '目录id';
COMMENT ON COLUMN tb_bdc_config.f_zdjbxx_kj IS '宗地基本信息（空间表）';
COMMENT ON COLUMN tb_bdc_config.f_zdjbxx IS '宗地基本信息（属性表）';
COMMENT ON COLUMN tb_bdc_config.f_zrz IS '自然幢';
COMMENT ON COLUMN tb_bdc_config.f_ljz IS '逻辑幢';
COMMENT ON COLUMN tb_bdc_config.f_csx IS '层属性结构';
COMMENT ON COLUMN tb_bdc_config.f_hsx IS '户属性结构';
COMMENT ON COLUMN tb_bdc_config.f_qlr IS '权利人';
COMMENT ON COLUMN tb_bdc_config.f_gzdj IS '更正登记';
COMMENT ON COLUMN tb_bdc_config.f_ygdj IS '预告登记';
COMMENT ON COLUMN tb_bdc_config.f_yydj IS '异议登记';
COMMENT ON COLUMN tb_bdc_config.f_cfdj IS '查封登记';
COMMENT ON COLUMN tb_bdc_config.f_fdcq1 IS '房地产权（项目内多幢房屋）';
COMMENT ON COLUMN tb_bdc_config.f_fdcq2 IS '房地产权（独幢、层、套、间房屋）';
COMMENT ON COLUMN tb_bdc_config.f_update_time IS '更新时间';