/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.analysis.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.ns.onemap.analysis.entity.TbBizDataAnalysis;
import com.geoway.ns.onemap.analysis.entity.TbBizDataAnalysisChart;
import com.geoway.ns.onemap.analysis.mapper.TbBizDataAnalysisMapper;
import com.geoway.ns.onemap.analysis.service.DataAnalysisChartService;
import com.geoway.ns.onemap.analysis.service.DataAnalysisService;
import com.geoway.ns.onemap.analysis.utile.HttpUtile;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DataAnalysisServiceImpl
extends ServiceImpl<TbBizDataAnalysisMapper, TbBizDataAnalysis>
implements DataAnalysisService {
    @Resource
    private SysParamsService sysParamsService;
    @Resource
    private DataAnalysisChartService dataAnalysisChartService;
    @Autowired
    JdbcTemplate jdbcTemplate;

    @Override
    public Boolean saveAll(TbBizDataAnalysis dataAnalysis, List<TbBizDataAnalysisChart> dataAnalysisCharts) {
        if (this.customSave(dataAnalysis)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"f_data_analysis_id", (Object)dataAnalysis.getFid());
            this.dataAnalysisChartService.remove((Wrapper)queryWrapper);
            boolean flag = true;
            for (TbBizDataAnalysisChart dataAnalysisChat : dataAnalysisCharts) {
                dataAnalysisChat.setFdataAnalysisId(dataAnalysis.getFid());
                if (this.dataAnalysisChartService.customSave(dataAnalysisChat)) continue;
                flag = false;
            }
            return flag;
        }
        return false;
    }

    @Override
    public boolean customSave(TbBizDataAnalysis entity) {
        LocalDateTime now;
        if (this.checksServerName(entity.getFserverName())) {
            entity = this.searchServerByName(entity, 0);
            entity = this.searchDiagramjson(entity);
            entity = this.getOpenparammetas(entity);
            now = LocalDateTime.now();
            if (entity.getFcreateTime() == null) {
                entity.setFcreateTime(now);
            }
            if (entity.getFstore() == null) {
                Integer count = Math.toIntExact(this.count() + 1L);
                entity.setFstore(count);
            }
        } else {
            throw new RuntimeException("\u670d\u52a1\u540d\u79f0\u4e0d\u5b58\u5728");
        }
        entity = this.runServer(entity);
        entity.setFupdateTime(now);
        return this.saveOrUpdate(entity);
    }

    @Override
    public boolean customDelete(TbBizDataAnalysis entity) {
        QueryWrapper queryWrapperChart = new QueryWrapper();
        queryWrapperChart.eq((Object)"f_data_analysis_id", (Object)entity.getFid());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.ge((Object)"f_store", (Object)entity.getFstore())).setSql("f_store = f_store -1");
        if (this.dataAnalysisChartService.remove((Wrapper)queryWrapperChart) && this.update((Wrapper)updateWrapper)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"f_id", (Object)entity.getFid());
            return this.remove((Wrapper)queryWrapper);
        }
        return false;
    }

    @Override
    public boolean checksServerName(String name) {
        try {
            String ginsightUrl = this.getGinsightUrl();
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            formparams.add(new BasicNameValuePair("name", "SRV_" + name));
            String param = URLEncodedUtils.format(formparams, (String)"UTF-8");
            String result = HttpUtile.httpGet(ginsightUrl + "/service/exists?" + param);
            JSONObject parse = JSONObject.parseObject((String)result);
            return "true".equals(parse.getString("data"));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public TbBizDataAnalysis searchServerByName(TbBizDataAnalysis dataAnalysis, Integer index) {
        try {
            String ginsightUrl = this.getGinsightUrl();
            String name = dataAnalysis.getFserverName();
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            formparams.add(new BasicNameValuePair("name", "SRV_" + name));
            String param = URLEncodedUtils.format(formparams, (String)"UTF-8");
            String result = HttpUtile.httpGet(ginsightUrl + "/service/search?" + param);
            JSONObject resultJson = JSONObject.parseObject((String)result.toString());
            if (resultJson.getInteger("code") == 200) {
                JSONArray array = resultJson.getJSONObject("data").getJSONArray("items");
                if (array.size() > index) {
                    JSONObject item = array.getJSONObject(index.intValue());
                    dataAnalysis.setFserverId(item.getString("id"));
                    dataAnalysis.setFserverModelId(item.getString("modelId"));
                }
                throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94[" + name + "]\u540d\u79f0\u7684\u7b2c[" + index + "]\u9879\u670d\u52a1");
            }
            throw new RuntimeException(resultJson.getString("msg"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            return dataAnalysis;
        }
    }

    @Override
    public TbBizDataAnalysis searchDiagramjson(TbBizDataAnalysis dataAnalysis) {
        try {
            String ginsightUrl = this.getGinsightUrl();
            String id = dataAnalysis.getFserverModelId();
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            formparams.add(new BasicNameValuePair("id", id));
            String param = URLEncodedUtils.format(formparams, (String)"UTF-8");
            String result = HttpUtile.httpGet(ginsightUrl + "/workflow/get?" + param);
            JSONObject resultJson = JSONObject.parseObject((String)result.toString());
            if (resultJson.getInteger("code") == 200) {
                dataAnalysis.setFdiagramjson(resultJson.getJSONObject("data").getString("diagramJson"));
            }
            throw new RuntimeException(resultJson.getString("msg"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            return dataAnalysis;
        }
    }

    @Override
    public TbBizDataAnalysis searchTaskById(TbBizDataAnalysis dataAnalysis) {
        try {
            String ginsightUrl = this.getGinsightUrl();
            String id = dataAnalysis.getFserverTaskId();
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            formparams.add(new BasicNameValuePair("id", id));
            String param = URLEncodedUtils.format(formparams, (String)"UTF-8");
            String result = HttpUtile.httpGet(ginsightUrl + "/task/get?" + param);
            JSONObject resultJson = JSONObject.parseObject((String)result.toString());
            if (resultJson.getInteger("code") == 200) {
                dataAnalysis.setFserverTaskState(resultJson.getJSONObject("data").getString("state"));
                this.saveOrUpdate(dataAnalysis);
            }
            throw new RuntimeException(resultJson.getString("msg"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            return dataAnalysis;
        }
    }

    public TbBizDataAnalysis getOpenparammetas(TbBizDataAnalysis dataAnalysis) {
        try {
            String ginsightUrl = this.getGinsightUrl();
            String id = dataAnalysis.getFserverId();
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            formparams.add(new BasicNameValuePair("id", id));
            String param = URLEncodedUtils.format(formparams, (String)"UTF-8");
            String result = HttpUtile.httpGet(ginsightUrl + "/service/openparammetas?" + param);
            JSONObject resultJson = JSONObject.parseObject((String)result.toString());
            if (resultJson.getInteger("code") == 200) {
                dataAnalysis.setFopenparammetas(resultJson.getJSONObject("data").getString("items"));
            }
            throw new RuntimeException(resultJson.getString("msg"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            return dataAnalysis;
        }
    }

    @Override
    public TbBizDataAnalysis runServer(TbBizDataAnalysis dataAnalysis) {
        try {
            String ginsightUrl = this.getGinsightUrl();
            String name = dataAnalysis.getFserverName();
            String result = HttpUtile.httppost(ginsightUrl + "/analysis/SRV_" + name, "{}");
            JSONObject resultJson = JSONObject.parseObject((String)result.toString());
            if (resultJson.getInteger("code") == 200) {
                dataAnalysis.setFserverTaskId(resultJson.getJSONObject("data").getString("taskId"));
            }
            throw new RuntimeException(resultJson.getString("msg"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            return dataAnalysis;
        }
    }

    @Override
    public Boolean setStroe(TbBizDataAnalysis dataAnalysis, String type) {
        if (type.equals("top")) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.lt((Object)"f_store", (Object)dataAnalysis.getFstore())).setSql("f_store = f_store +1");
            this.update((Wrapper)updateWrapper);
            dataAnalysis.setFstore(0);
            return this.saveOrUpdate(dataAnalysis);
        }
        if (type.equals("bottom")) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.ge((Object)"f_store", (Object)dataAnalysis.getFstore())).setSql("f_store = f_store -1");
            this.update((Wrapper)updateWrapper);
            Integer count = Math.toIntExact(this.count());
            dataAnalysis.setFstore(count - 1);
            return this.saveOrUpdate(dataAnalysis);
        }
        if (type.equals("up")) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"f_store", (Object)(dataAnalysis.getFstore() - 1));
            TbBizDataAnalysis lastDataAnalysis = (TbBizDataAnalysis)this.getOne((Wrapper)queryWrapper);
            lastDataAnalysis.setFstore(lastDataAnalysis.getFstore() + 1);
            this.saveOrUpdate(lastDataAnalysis);
            dataAnalysis.setFstore(dataAnalysis.getFstore() - 1);
            return this.saveOrUpdate(dataAnalysis);
        }
        if (type.equals("down")) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"f_store", (Object)(dataAnalysis.getFstore() + 1));
            TbBizDataAnalysis nextDataAnalysis = (TbBizDataAnalysis)this.getOne((Wrapper)queryWrapper);
            nextDataAnalysis.setFstore(nextDataAnalysis.getFstore() - 1);
            this.saveOrUpdate(nextDataAnalysis);
            dataAnalysis.setFstore(dataAnalysis.getFstore() + 1);
            return this.saveOrUpdate(dataAnalysis);
        }
        return false;
    }

    public String getGinsightUrl() {
        SysParamDTO sysParamDTO = this.sysParamsService.getDetail("api", "ginsight-url");
        return sysParamDTO.getValue();
    }
}

