/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.controller.scenecenter;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.onemap.scenecenter.entity.TbSceneCenter;
import com.geoway.ns.onemap.scenecenter.service.TbSceneCenterService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.FileUploadResponse;
import com.geoway.ns.sys.dto.RowsResponse;
import com.geoway.ns.sys.service.FileServerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u573a\u666f\u4e2d\u5fc3\u914d\u7f6e"})
@Controller
@RequestMapping(value={"/sceneCenter"})
public class SceneCenterController {
    private static final Logger log = LoggerFactory.getLogger(SceneCenterController.class);
    @Autowired
    private TbSceneCenterService tbSceneCenterService;
    @Autowired
    FileServerService fileServerService;

    @RequestMapping(value={"/selectAll"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="1-\u67e5\u8be2\u6240\u6709")
    public DataResponse<List<TbSceneCenter>> selectAll(@RequestParam(value="name", required=false) @Nullable String name) {
        return DataResponse.success(this.tbSceneCenterService.search(name));
    }

    @RequestMapping(value={"/listPage"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="2-\u5206\u9875\u67e5\u8be2")
    public BaseResponse listPage(@RequestParam(value="pageIndex", defaultValue="1", required=false) Integer pageIndex, @RequestParam(value="size", defaultValue="10", required=false) Integer size, @RequestParam(value="name", required=false) @Nullable String name) {
        RowsResponse response = new RowsResponse();
        try {
            IPage<TbSceneCenter> resultPage = this.tbSceneCenterService.queryPageByFilter(pageIndex, size, name);
            response.setRows(resultPage.getRecords());
            response.setTotal(Long.valueOf(resultPage.getTotal()));
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="3-\u4fdd\u5b58\uff08\u65b0\u589e\u548c\u4fee\u6539\u90fd\u7528\u8be5\u63a5\u53e3\uff09")
    public BaseResponse add(TbSceneCenter TbSceneCenter2) {
        return DataResponse.success((Object)this.tbSceneCenterService.addOrUpdate(TbSceneCenter2));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="4-\u901a\u8fc7ID\u5220\u9664")
    public BaseResponse delete(@RequestParam(value="id") Long id) {
        boolean res = this.tbSceneCenterService.deleteById(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"/deleteMulti"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="5-\u6279\u91cf\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u5217\u8868\uff0c\u591a\u4e2aid\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00", required=true, dataTypeClass=String.class)})
    public BaseResponse deleteMulti(@RequestParam(value="ids") String ids) {
        boolean res = this.tbSceneCenterService.deleteMulti(ids);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToFirst"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="6-\u7f6e\u9876")
    public BaseResponse updateToFirst(@RequestParam(value="id") Long id) {
        boolean res = this.tbSceneCenterService.updateToFirst(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToLast"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="7-\u7f6e\u5e95")
    public BaseResponse updateToLast(@RequestParam(value="id") Long id) {
        boolean res = this.tbSceneCenterService.updateToLast(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToPre"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="8-\u4e0a\u79fb")
    public BaseResponse updateToPre(@RequestParam(value="id") Long id) {
        boolean res = this.tbSceneCenterService.updateToPre(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToSuffix"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="9-\u4e0b\u79fb")
    public BaseResponse updateToSuffix(@RequestParam(value="id") Long id) {
        boolean res = this.tbSceneCenterService.updateToSuffix(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/moveSort"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="10-\u62d6\u62fd\u6392\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u66f4\u65b0\u5143\u7d20\u7684id", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="targetOrder", value="\u76ee\u6807\u4f4d\u7f6e\u5143\u7d20\u7684\u5e8f\u53f7", required=true, dataTypeClass=Integer.class)})
    public BaseResponse moveSort(@RequestParam(value="id") Long id, @RequestParam(value="targetOrder") Integer targetOrder) {
        boolean res = this.tbSceneCenterService.sort(id, targetOrder);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/uploadFile"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="11-\u4e0a\u4f20\u9644\u4ef6")
    public BaseResponse uploadSysNewsFile(@RequestParam(value="file") MultipartFile file) {
        try {
            FileServerResponse fileServerResponse = this.fileServerService.sendFileToServerOnSpeFolder(file, "scene");
            FileUploadResponse fileUploadResponse = fileServerResponse.convertToFileUploadResponse();
            return DataResponse.success((Object)fileUploadResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)e.getMessage());
        }
    }
}

