/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.djtj.util;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.ns.geoserver3.dto.TbAnalysisTask;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.geoserver3.service.IGeoserver3TaskService;
import com.geoway.ns.onemap.common.constants.EnumTaskStatus;
import com.geoway.ns.onemap.djtj.entity.SuperimposedStatisticalRecord;
import com.geoway.ns.onemap.djtj.entity.Task;
import com.geoway.ns.onemap.djtj.service.SuperimposedStatisticalRecordService;
import com.geoway.ns.onemap.djtj.service.TaskService;
import com.geoway.ns.onemap.service.AnalysisService;
import com.geoway.ns.sys.utils.Md5Utils;
import com.geoway.ns.sys.utils.RedisUtil;
import com.geoway.ns.sys.utils.TenantUserUtil;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DjtjTaskScheduler {
    @Value(value="${djtj.query.enable:false}")
    private Boolean enable;
    @Value(value="${djtj.query.timeout:30}")
    private int timeout;
    @Autowired
    private SuperimposedStatisticalRecordService superimposedStatisticalRecordService;
    @Resource
    private RedisUtil redisUtil;
    private static final String DjfxStatResultRedisKey = "DjfxStatResult:";
    @Autowired
    private TaskService taskService;
    @Autowired
    private IGeoserver3TaskService geoserver3TaskService;
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;
    @Resource
    private AnalysisService iAnalysisEngineService;
    @Autowired
    private TenantUserUtil tenantUserUtil;

    @Scheduled(cron="${cloud.query.cron:0/3 * * * * ?}")
    public void pollingTask() {
        if (this.enable.booleanValue()) {
            this.tenantUserUtil.userManage();
            List tasks = this.taskService.list((Wrapper)Wrappers.lambdaQuery(Task.class).eq(Task::getStatus, (Object)1));
            if (!tasks.isEmpty()) {
                for (Task task : tasks) {
                    try {
                        TbAnalysisTask taskInfo = this.geoserver3TaskService.findTaskById(task.getJobId());
                        if (taskInfo == null || taskInfo.getStatus() == 0) continue;
                        if (taskInfo.getStatus() == 500) {
                            task.setStatus(EnumTaskStatus.Failed.value);
                            task.setProgress((int)taskInfo.getProgress());
                        } else if (taskInfo.getStatus() == 200) {
                            SuperimposedStatisticalRecord record;
                            String defaultStattaskId;
                            task.setStatus(EnumTaskStatus.Succeed.value);
                            task.setProgress((int)taskInfo.getProgress());
                            QueryWrapper superimposedStatisticalRecordQueryWrapper = new QueryWrapper();
                            ((LambdaQueryWrapper)superimposedStatisticalRecordQueryWrapper.lambda().eq(SuperimposedStatisticalRecord::getTaskId, (Object)task.getId())).isNull(SuperimposedStatisticalRecord::getDefaultStattaskId);
                            List list = this.superimposedStatisticalRecordService.list((Wrapper)superimposedStatisticalRecordQueryWrapper);
                            if (list != null && list.size() > 0 && StringUtils.isNotEmpty((CharSequence)(defaultStattaskId = this.startCustomStatTask(record = (SuperimposedStatisticalRecord)list.get(0))))) {
                                record.setDefaultStattaskId(defaultStattaskId);
                                this.superimposedStatisticalRecordService.saveOrUpdate(record);
                            }
                        } else if (taskInfo.getStatus() == -1) {
                            task.setStatus(EnumTaskStatus.Running.value);
                            task.setProgress((int)taskInfo.getProgress());
                        }
                        this.taskService.saveOrUpdate(task);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private String startCustomStatTask(SuperimposedStatisticalRecord superimposedStatisticalRecord) throws IllegalAccessException {
        if (ObjectUtil.isNotNull((Object)superimposedStatisticalRecord)) {
            JSONObject param = new JSONObject();
            Task task = (Task)this.taskService.getById((Serializable)((Object)superimposedStatisticalRecord.getTaskId()));
            param.put("ApplicationGUID", (Object)this.geoserver3ConfigService.getApplicationGuid());
            param.put("AnalysisID", (Object)UUID.randomUUID().toString());
            param.put("djfxTaskId", (Object)task.getJobId());
            String tjParam = superimposedStatisticalRecord.getTjParam();
            JSONObject tjParamOJsonObject = JSONObject.parseObject((String)tjParam);
            param.put("groupFields", (Object)tjParamOJsonObject.getString("fzzd"));
            param.put("statFields", (Object)tjParamOJsonObject.getJSONArray("tjzb"));
            param.put("filter", (Object)MapUtil.of((Object)"whereclause", (Object)tjParamOJsonObject.getString("filter")));
            JSONObject tjfwJsonObject = tjParamOJsonObject.getJSONObject("tjfw");
            JSONArray blocks = tjfwJsonObject.getJSONArray("geometryData");
            if (blocks != null && blocks.size() == 0) {
                blocks = null;
            }
            param.put("Blocks", (Object)blocks);
            param.put("SpatialRel", (Object)tjfwJsonObject.getString("relationship"));
            JSONObject jsonObject = this.iAnalysisEngineService.doCustomStatTask(param);
            String message = jsonObject.getString("Message");
            if (StrUtil.isNotBlank((CharSequence)message) && "success".equals(message)) {
                JSONArray jsonArray = jsonObject.getJSONArray("Results");
                if (jsonArray != null && jsonArray.size() > 0) {
                    String paramMd5 = Md5Utils.getMD5Str((String)param.toJSONString(), (String)"UTF-8");
                    this.redisUtil.set(DjfxStatResultRedisKey + paramMd5, (Object)jsonArray.toJSONString());
                }
                return jsonObject.getString("UniqueTaskID");
            }
        }
        return null;
    }
}

