/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.externaldata.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.ns.onemap.externaldata.service.IUserService;
import com.geoway.ns.sys.service.IUISConfigService;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.Oauth2Utils;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements IUserService {
    @Resource
    private SysParamsService sysParamsService;
    @Resource
    IUISConfigService uisConfigService;
    JSONObject jckjToken = null;
    Date jckjTime = null;

    public String getJCKJUser() {
        SysParamDTO sysParamDTO = this.sysParamsService.getDetail("jckj", "user");
        return sysParamDTO.getValue();
    }

    public String getJCKJPassword() {
        SysParamDTO sysParamDTO = this.sysParamsService.getDetail("jckj", "password");
        return sysParamDTO.getValue();
    }

    public String getJCKJToken() {
        if (this.jckjToken == null || this.jckjTime == null || new Date().getTime() - this.jckjTime.getTime() > (long)this.jckjToken.getInteger("expiresIn").intValue()) {
            try {
                this.postJCKJToken();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.jckjToken.getString("accessToken");
    }

    @Override
    public SsoUser getUserInfo(String token) {
        if (this.uisConfigService.getUISURL() == null) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6euisurl\u7cfb\u7edf\u53c2\u6570");
        }
        String serverUrl = this.uisConfigService.getUISURL();
        if (StrUtil.isBlank((CharSequence)token)) {
            throw new RuntimeException("\u6ca1\u6709\u83b7\u53d6\u5230token");
        }
        Result result = Oauth2Utils.queryAccessToken((String)serverUrl, (String)token);
        return ((RpcAccessToken)result.getData()).getUser();
    }

    @Override
    public JSONObject getUserInfoById(String userId) {
        String api = "/user/findOne";
        String resultStr = ((HttpRequest)HttpRequest.get((String)(this.uisConfigService.getUISURL() + api)).form("id", (Object)userId).contentType("application/x-www-form-urlencoded").header("access_token", this.getJCKJToken())).execute().body();
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        if (resultJson.getInteger("code") != 200 || !"OK".equals(resultJson.getString("status"))) {
            throw new RuntimeException("\u83b7\u53d6\u7528\u6237\u5931\u8d25");
        }
        return resultJson.getJSONObject("data");
    }

    @Override
    public JSONArray queryUser(String filterParam) {
        String api = "/user/queryList";
        String resultStr = ((HttpRequest)HttpRequest.get((String)(this.uisConfigService.getUISURL() + api)).form("filterParam", (Object)filterParam).contentType("application/x-www-form-urlencoded").header("access_token", this.getJCKJToken())).execute().body();
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        if (resultJson.getInteger("code") != 200 || !"OK".equals(resultJson.getString("status"))) {
            throw new RuntimeException("\u83b7\u53d6\u7528\u6237\u5931\u8d25");
        }
        return resultJson.getJSONArray("data");
    }

    @Override
    public Boolean savaUser(String id, String name, String accout, String tel, String params, String otherParams) {
        String api = "/user/save";
        String resultStr = ((HttpRequest)HttpRequest.post((String)(this.uisConfigService.getUISURL() + api)).form("name", (Object)name).form("id", (Object)id).form("accout", (Object)accout).form("tel", (Object)tel).form("params", (Object)params).form("otherParams", (Object)otherParams).form("deletePhoto", (Object)0).contentType("application/x-www-form-urlencoded").header("access_token", this.getJCKJToken())).execute().body();
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        if (resultJson.getInteger("code") != 200 || !"OK".equals(resultJson.getString("status"))) {
            throw new RuntimeException("\u4fdd\u5b58\u7528\u6237\u5931\u8d25\uff0c" + resultJson.getString("message"));
        }
        return true;
    }

    @Override
    public JSONArray queryTreeById(String id) {
        String api = "/organization/queryTreeById";
        String resultStr = ((HttpRequest)HttpRequest.get((String)(this.uisConfigService.getUISURL() + api)).form("id", (Object)id).contentType("application/x-www-form-urlencoded").header("access_token", this.getJCKJToken())).execute().body();
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        if (resultJson.getInteger("code") != 200 || !"OK".equals(resultJson.getString("status"))) {
            throw new RuntimeException("\u6309\u673a\u6784ID\u67e5\u8be2\u5176\u4e0b\u7ea7\u673a\u6784\u6811\u5931\u8d25\uff0c" + resultJson.getString("message"));
        }
        return resultJson.getJSONArray("data");
    }

    @Override
    public JSONArray queryRoleList(String filterParam) {
        String api = "/role/queryList";
        String resultStr = ((HttpRequest)HttpRequest.get((String)(this.uisConfigService.getUISURL() + api)).form("filterParam", (Object)filterParam).contentType("application/x-www-form-urlencoded").header("access_token", this.getJCKJToken())).execute().body();
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        if (resultJson.getInteger("code") != 200 || !"OK".equals(resultJson.getString("status"))) {
            throw new RuntimeException("\u67e5\u8be2\u89d2\u8272\u5217\u8868\u5931\u8d25\uff0c" + resultJson.getString("message"));
        }
        return resultJson.getJSONArray("data");
    }

    @Override
    public JSONArray queryOrganization(String filterParam) {
        String api = "/organization/queryList";
        String resultStr = ((HttpRequest)HttpRequest.get((String)(this.uisConfigService.getUISURL() + api)).form("filterParam", (Object)filterParam).contentType("application/x-www-form-urlencoded").header("access_token", this.getJCKJToken())).execute().body();
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        if (resultJson.getInteger("code") != 200 || !"OK".equals(resultJson.getString("status"))) {
            throw new RuntimeException("\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7ec4\u7ec7\u5217\u8868\u5931\u8d25\uff0c" + resultJson.getString("message"));
        }
        return resultJson.getJSONArray("data");
    }

    @Override
    public Boolean saveOrganization(String id, String name, String aname, String code, String desc, String pid, String level) {
        String api = "/organization/save";
        String resultStr = ((HttpRequest)HttpRequest.post((String)(this.uisConfigService.getUISURL() + api)).form("id", (Object)id).form("name", (Object)name).form("aname", (Object)aname).form("code", (Object)code).form("desc", (Object)desc).form("pid", (Object)pid).form("level", (Object)level).contentType("application/x-www-form-urlencoded").header("access_token", this.getJCKJToken())).execute().body();
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        if (resultJson.getInteger("code") != 200 || !"OK".equals(resultJson.getString("status"))) {
            throw new RuntimeException("\u65b0\u589e\u6216\u4fee\u6539\u673a\u6784\u5931\u8d25\uff0c" + resultJson.getString("message"));
        }
        return true;
    }

    @Override
    public Boolean addUserToOrganization(String orgId, String userId) {
        String api = "/organization/addUser";
        String resultStr = ((HttpRequest)HttpRequest.post((String)(this.uisConfigService.getUISURL() + api)).form("orgId", (Object)orgId).form("userId", (Object)userId).contentType("application/x-www-form-urlencoded").header("access_token", this.getJCKJToken())).execute().body();
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        if (resultJson.getInteger("code") != 200 || !"OK".equals(resultJson.getString("status"))) {
            throw new RuntimeException("\u65b0\u589e\u90e8\u95e8\u5173\u8054\u7684\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c" + resultJson.getString("message"));
        }
        return true;
    }

    public void postJCKJToken() {
        String api = "/oauth2/access_token";
        String resultStr = HttpRequest.post((String)(this.uisConfigService.getUISURL() + api)).form("grantType", (Object)"password").form("appId", (Object)this.uisConfigService.getAppkey()).form("appSecret", (Object)this.uisConfigService.getAppsecret()).form("username", (Object)this.getJCKJUser()).form("password", (Object)this.getJCKJPassword()).contentType("application/x-www-form-urlencoded").execute().body();
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        if (resultJson.getInteger("code") == 0 || !"OK".equals(resultJson.getString("status"))) {
            this.jckjToken = null;
            this.jckjTime = null;
            throw new RuntimeException("\u83b7\u53d6\u96c6\u6210\u6846\u67b6token\u5931\u8d25");
        }
        this.jckjToken = resultJson.getJSONObject("data");
        this.jckjTime = new Date();
    }
}

