/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.multidata.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.onemap.multidata.dto.DKInfoDTO;
import com.geoway.ns.onemap.multidata.dto.YearLayerInfoDTO;
import com.geoway.ns.onemap.multidata.service.BaseTaskService;
import com.geoway.ns.onemap.multidata.support.AsyncHttpClientPoolUtil;
import com.geoway.ns.onemap.multidata.support.CountDownLatchUtils;
import com.geoway.ns.onemap.multidata.support.HttpClientPoolUtil;
import com.geoway.ns.onemap.multidata.support.ImgUtils;
import com.geoway.ns.onemap.multidata.support.WKTUtil;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClipImgAsyncHttpTaskService
implements BaseTaskService {
    private long timeout = 5L;
    private TimeUnit unit = TimeUnit.MINUTES;
    private static final long serialVersionUID = -2888128865370482082L;
    private final Logger logger = LoggerFactory.getLogger(ClipImgAsyncHttpTaskService.class);
    DKInfoDTO xmdk;
    private String[] yzfxScreenshotUrls;
    Double bufferDistince = 0.0;
    Boolean isCompute = false;

    public ClipImgAsyncHttpTaskService(DKInfoDTO xmdk, String[] yzfxScreenshotUrls) {
        this.xmdk = xmdk;
        this.yzfxScreenshotUrls = yzfxScreenshotUrls;
    }

    private String geYzfxScreenshotUrl(String noThisUrl) {
        if (this.yzfxScreenshotUrls != null && this.yzfxScreenshotUrls.length == 1) {
            return this.yzfxScreenshotUrls[0];
        }
        if (this.yzfxScreenshotUrls != null && this.yzfxScreenshotUrls.length > 1) {
            int index = (int)(Math.random() * (double)this.yzfxScreenshotUrls.length);
            if (!StringUtils.isBlank((CharSequence)noThisUrl) && noThisUrl.equalsIgnoreCase(this.yzfxScreenshotUrls[index])) {
                return this.geYzfxScreenshotUrl(noThisUrl);
            }
            return this.yzfxScreenshotUrls[index];
        }
        this.logger.error("yzfxScreenshotUrls\u53c2\u6570\u4e3a\u7a7a");
        return null;
    }

    @Override
    public void compute() {
        this.isCompute = true;
        if (this.xmdk == null || this.xmdk.getYears() == null || this.xmdk.getYears().size() == 0) {
            System.out.println("\u5e76\u884c\u8ba1\u7b97\u65b9\u6cd5\u672a\u6267\u884c");
            return;
        }
        String yzfxwkt = null;
        CountDownLatch latch = new CountDownLatch(this.xmdk.getYears().size());
        CountDownLatchUtils.addCountDownLatch(latch);
        String yzfxZYXJwkt = null;
        for (YearLayerInfoDTO imageParam : this.xmdk.getYears()) {
            try {
                Map<String, Object> params = this.getRequestParam(imageParam, this.xmdk.getBoxx(), this.xmdk.getWkt(), yzfxwkt, yzfxZYXJwkt, this.xmdk.getWidth(), this.xmdk.getHeight());
                this.queryImage(latch, params, imageParam, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            latch.await(this.timeout, this.unit);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            ex.printStackTrace();
        }
        this.logger.error("\u5b50\u7ebf\u7a0b\u5b8c\u6210\u622a\u56fe\u4efb\u52a1\uff01");
    }

    @Override
    public boolean isCompute() {
        return this.isCompute;
    }

    private void queryImage(final CountDownLatch latch, final Map<String, Object> params, final YearLayerInfoDTO imageParam, final String noThisUrl) {
        final String screenshotUrl = this.geYzfxScreenshotUrl(noThisUrl);
        final long startTime = System.currentTimeMillis();
        AsyncHttpClientPoolUtil.execute(screenshotUrl, HttpClientPoolUtil.getPostListNameValuePair(params), new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse httpResponse) {
                ClipImgAsyncHttpTaskService.this.logger.info("execute post request completed, url:" + screenshotUrl + ", cost time(ms):" + (System.currentTimeMillis() - startTime));
                HttpEntity httpEntity = httpResponse.getEntity();
                if (httpEntity != null) {
                    ClipImgAsyncHttpTaskService.this.logger.info("image response ok, url:" + screenshotUrl + ", cost time(ms):" + (System.currentTimeMillis() - startTime));
                    ContentType contentType = null;
                    try {
                        contentType = ContentType.get((HttpEntity)httpEntity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ClipImgAsyncHttpTaskService.this.logger.error(e.getMessage());
                    }
                    if (contentType == null || contentType != null && (contentType.toString().toLowerCase().contains("image/png") || contentType.toString().toLowerCase().contains("image/jpg") || contentType.toString().toLowerCase().contains("image/jpeg"))) {
                        InputStream inputStream = null;
                        try {
                            inputStream = httpEntity.getContent();
                            String responseImgBody = ImgUtils.inputStream2ImgStr(inputStream);
                            imageParam.setBase64Result(responseImgBody);
                        }
                        catch (Exception e) {
                            ClipImgAsyncHttpTaskService.this.logger.error("YZDK_SPSJ_YEAR\u8bfb\u53d6\u56fe\u7247\u6d41\u9519\u8bef\uff1a", (Throwable)e);
                            e.printStackTrace();
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        CountDownLatchUtils.countDown(latch, ClipImgAsyncHttpTaskService.this.logger);
                    } else {
                        try {
                            String responsBody = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                            ClipImgAsyncHttpTaskService.this.logger.error("YZDK_SPSJ_YEAR\u8bf7\u6c42\u56fe\u7247\u9519\u8bef\uff1a" + responsBody);
                            if (StringUtils.isBlank((CharSequence)noThisUrl)) {
                                ClipImgAsyncHttpTaskService.this.queryImage(latch, params, imageParam, screenshotUrl);
                                return;
                            }
                            CountDownLatchUtils.countDown(latch, ClipImgAsyncHttpTaskService.this.logger);
                            ClipImgAsyncHttpTaskService.this.logger.error("request:" + JSON.toJSONString((Object)params));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ClipImgAsyncHttpTaskService.this.logger.error(e.getMessage());
                            CountDownLatchUtils.countDown(latch, ClipImgAsyncHttpTaskService.this.logger);
                            ClipImgAsyncHttpTaskService.this.logger.error("request:" + JSON.toJSONString((Object)params));
                        }
                    }
                } else {
                    ClipImgAsyncHttpTaskService.this.logger.error("\u8bf7\u6c42\u56fe\u7247\u9519\u8bef\uff1ahttpEntity\u4e3a\u7a7a");
                    ClipImgAsyncHttpTaskService.this.logger.error("request:" + JSON.toJSONString((Object)params));
                    if (StringUtils.isBlank((CharSequence)noThisUrl)) {
                        ClipImgAsyncHttpTaskService.this.queryImage(latch, params, imageParam, screenshotUrl);
                        return;
                    }
                    CountDownLatchUtils.countDown(latch, ClipImgAsyncHttpTaskService.this.logger);
                }
            }

            public void failed(Exception e) {
                ClipImgAsyncHttpTaskService.this.logger.error("execute post image request failed, url:" + screenshotUrl + ", exception:" + e.toString() + ", cost time(ms):" + (System.currentTimeMillis() - startTime));
                ClipImgAsyncHttpTaskService.this.logger.error("request:" + JSON.toJSONString((Object)params));
                if (StringUtils.isBlank((CharSequence)noThisUrl)) {
                    ClipImgAsyncHttpTaskService.this.queryImage(latch, params, imageParam, screenshotUrl);
                    return;
                }
                CountDownLatchUtils.countDown(latch, ClipImgAsyncHttpTaskService.this.logger);
            }

            public void cancelled() {
                ClipImgAsyncHttpTaskService.this.logger.error("execute post image request cancelled, url:" + screenshotUrl + ", cancelled, cost time(ms):" + (System.currentTimeMillis() - startTime));
                ClipImgAsyncHttpTaskService.this.logger.error("request:" + JSON.toJSONString((Object)params));
                if (StringUtils.isBlank((CharSequence)noThisUrl)) {
                    ClipImgAsyncHttpTaskService.this.queryImage(latch, params, imageParam, screenshotUrl);
                    return;
                }
                CountDownLatchUtils.countDown(latch, ClipImgAsyncHttpTaskService.this.logger);
            }
        });
    }

    protected Map<String, Object> getRequestParam(YearLayerInfoDTO imageParam, String boxxwkt, String xmWkt, String yzfxwkt, String yzfxZYXJwkt, Integer width, Integer height) {
        JSONObject drawJson;
        Geometry boxGeometry = null;
        if (width == null) {
            width = 500;
        }
        if (height == null) {
            height = 500;
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)boxxwkt)) {
                boxGeometry = WKTUtil.wktToGeom(boxxwkt);
                boxGeometry = boxGeometry.getEnvelope();
            } else if (StringUtils.isNotEmpty((CharSequence)xmWkt)) {
                Geometry xmGeometry = WKTUtil.wktToGeom(xmWkt);
                boxGeometry = xmGeometry.getEnvelope();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
        JSONArray drawJsonArr = new JSONArray();
        if (StringUtils.isNotEmpty((CharSequence)yzfxwkt) && StringUtils.isNotEmpty((CharSequence)yzfxZYXJwkt) && yzfxwkt.equalsIgnoreCase(yzfxZYXJwkt)) {
            drawJson = new JSONObject();
            drawJson.put("wkt", (Object)yzfxwkt);
            drawJson.put("color", (Object)"#00FFFF");
            drawJson.put("transparency", (Object)1);
            drawJson.put("filled", (Object)true);
            drawJson.put("width", (Object)3);
            drawJson.put("dotted", (Object)false);
            drawJson.put("fillColor", (Object)"#00FFFF");
            drawJson.put("fillTransparency", (Object)0.6);
            drawJsonArr.add((Object)drawJson);
            if (StringUtils.isEmpty((CharSequence)boxxwkt)) {
                try {
                    Geometry xmGeometry = WKTUtil.wktToGeom(xmWkt);
                    Geometry yzfxGeometry = WKTUtil.wktToGeom(yzfxwkt);
                    boxGeometry = xmGeometry.union(yzfxGeometry);
                    boxGeometry = boxGeometry.getEnvelope();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        } else {
            if (StringUtils.isNotEmpty((CharSequence)yzfxwkt)) {
                drawJson = new JSONObject();
                drawJson.put("wkt", (Object)yzfxwkt);
                drawJson.put("fillColor", (Object)"#00FFFF");
                drawJson.put("fillTransparency", (Object)0.6);
                drawJson.put("color", (Object)"#00FFFF");
                drawJson.put("transparency", (Object)1);
                drawJson.put("filled", (Object)true);
                drawJson.put("width", (Object)2);
                drawJson.put("dotted", (Object)false);
                drawJsonArr.add((Object)drawJson);
                if (StringUtils.isEmpty((CharSequence)boxxwkt)) {
                    try {
                        Geometry xmGeometry = WKTUtil.wktToGeom(xmWkt);
                        Geometry yzfxGeometry = WKTUtil.wktToGeom(yzfxwkt);
                        boxGeometry = xmGeometry.union(yzfxGeometry);
                        boxGeometry = boxGeometry.getEnvelope();
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)yzfxZYXJwkt)) {
                JSONObject drawJsonZY = new JSONObject();
                drawJsonZY.put("wkt", (Object)yzfxZYXJwkt);
                drawJsonZY.put("color", (Object)"#0FFFFF");
                drawJsonZY.put("transparency", (Object)1);
                drawJsonZY.put("filled", (Object)false);
                drawJsonZY.put("width", (Object)3);
                drawJsonZY.put("dotted", (Object)false);
                drawJsonArr.add((Object)drawJsonZY);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)xmWkt)) {
            JSONObject drawJsonXM = new JSONObject();
            drawJsonXM.put("wkt", (Object)xmWkt);
            drawJsonXM.put("color", (Object)"#FF0000");
            drawJsonXM.put("transparency", (Object)1);
            drawJsonXM.put("filled", (Object)false);
            drawJsonXM.put("width", (Object)3);
            drawJsonXM.put("dotted", (Object)true);
            drawJsonArr.add((Object)drawJsonXM);
        }
        if (boxGeometry != null && this.bufferDistince > 0.0) {
            boxGeometry = boxGeometry.buffer(this.bufferDistince.doubleValue()).getEnvelope();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("serviceJson", imageParam.getServicejson());
        params.put("boxWkt", WKTUtil.geomToWkt(boxGeometry));
        params.put("color", "#FF0000");
        params.put("drawWidth", 3);
        params.put("width", width);
        params.put("height", height);
        params.put("drawJson", drawJsonArr);
        return params;
    }
}

