/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.multidata.support;

import com.geoway.ns.onemap.multidata.support.AsyncHttpClientPoolUtil;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountDownLatchUtils {
    private static final Logger logger = LoggerFactory.getLogger(CountDownLatchUtils.class);
    private static List<CountDownLatch> _countDouwnLatchs = new CopyOnWriteArrayList<CountDownLatch>();
    private static ForkJoinPool _forkJoinPool = null;

    public static void setForkJoinPool(ForkJoinPool forkJoinPool) {
        _forkJoinPool = forkJoinPool;
    }

    public static ForkJoinPool getForkJoinPool() {
        return _forkJoinPool;
    }

    public static void addCountDownLatch(CountDownLatch latch) {
        _countDouwnLatchs.add(latch);
    }

    public static void countDown(CountDownLatch latch, Logger logger2) {
        Logger _logger = logger2 != null ? logger2 : logger;
        _logger.error("\u8bf7\u6c42\u7ed3\u675f\uff1a" + AsyncHttpClientPoolUtil.getHttpConnectionManager().getTotalStats().toString());
        _logger.error("----------\uff1a" + AsyncHttpClientPoolUtil.getHttpConnectionManager().getRoutes().toString());
        latch.countDown();
        if (latch.getCount() == 0L && _countDouwnLatchs.contains(latch)) {
            _countDouwnLatchs.remove(latch);
        }
        _logger.error("\u8fd8\u6709\u8ba1\u6570\u5668\uff1a" + CountDownLatchUtils.ToString() + "-----------\uff1a" + latch.toString());
    }

    public static int getCount() {
        return _countDouwnLatchs.size();
    }

    public static String ToString() {
        StringBuffer cab = new StringBuffer();
        cab.append("[Total CountDownLatch Count = ");
        cab.append(_countDouwnLatchs.size());
        cab.append("]");
        if (_countDouwnLatchs.size() > 0) {
            for (int i = 0; i < _countDouwnLatchs.size(); ++i) {
                if (i == 0) {
                    cab.append('{');
                } else {
                    cab.append(",{");
                }
                cab.append(_countDouwnLatchs.get(i).toString());
                cab.append('}');
            }
        }
        if (_forkJoinPool != null) {
            cab.append("[forkJoinPool ");
            cab.append(_forkJoinPool.toString());
            cab.append("]");
        }
        return cab.toString();
    }
}

