/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.onlineQuery.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.catalog.dto.CatalogDataNodeFieldsDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.query.FeatureQueryFilterDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeService;
import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.ns.geoserver3.constant.Adf4GeoserverSpatialRelEnum;
import com.geoway.ns.geoserver3.service.IQueryService;
import com.geoway.ns.onemap.multidata.support.WKTUtil;
import com.geoway.ns.onemap.onlineQuery.entity.OnlineQueryFields;
import com.geoway.ns.onemap.onlineQuery.mapper.OnlineQueryFieldsMapper;
import com.geoway.ns.onemap.onlineQuery.service.OnlineQueryFieldsService;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OnlineQueryFieldsServiceImpl
extends ServiceImpl<OnlineQueryFieldsMapper, OnlineQueryFields>
implements OnlineQueryFieldsService {
    @Resource
    private AppCatalogNodeService appCatalogNodeService;
    @Resource
    private DictionaryService dictionaryService;
    @Autowired
    private IQueryService queryService;

    @Override
    public List<OnlineQueryFields> listByNodeId(String nodeId) {
        return this.list((Wrapper)Wrappers.lambdaQuery(OnlineQueryFields.class).eq(OnlineQueryFields::getNodeId, (Object)nodeId));
    }

    @Override
    public boolean deleteByNodeId(String nodeId) {
        return this.remove((Wrapper)Wrappers.lambdaQuery(OnlineQueryFields.class).eq(OnlineQueryFields::getNodeId, (Object)nodeId));
    }

    @Override
    public DataQueryResult queryData(FeatureQueryFilterDTO featureQueryFilterDTO) {
        AppCatalogDataNodeDTO appCatalogDataNodeDTO = (AppCatalogDataNodeDTO)this.appCatalogNodeService.getNodeDetail(featureQueryFilterDTO.getNodeId());
        if (appCatalogDataNodeDTO == null || appCatalogDataNodeDTO.getDataset() == null || StrUtil.isBlank((CharSequence)appCatalogDataNodeDTO.getDataset().getDsKey())) {
            throw new RuntimeException("\u6570\u636e\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        Map param = this.buildQueryParams(featureQueryFilterDTO, appCatalogDataNodeDTO);
        JSONObject responseObj = this.queryService.analysisCustomDatasource(param);
        String resultStr = responseObj.getString("Results");
        DataQueryResult dataQueryResult = new DataQueryResult();
        if (StringUtils.isEmpty((CharSequence)resultStr)) {
            dataQueryResult.setErrorMessage(responseObj.getString("massage"));
            return dataQueryResult;
        }
        List results = JSONArray.parseArray((String)resultStr, Map.class);
        List nodeFields = appCatalogDataNodeDTO.getFields();
        CatalogDataNodeFieldsDTO OID = this.findObjectFieldId(nodeFields);
        ArrayList data = new ArrayList();
        results.forEach(item -> {
            String wkt = (String)item.get("SHAPE_WKT");
            FeatureResult featureResult = new FeatureResult();
            if (StringUtils.isNotEmpty((CharSequence)wkt)) {
                try {
                    Geometry geometry = WKTUtil.wktToGeom(wkt);
                    featureResult.setGeometry(wkt);
                    ExtentDTO extentDTO = new ExtentDTO();
                    extentDTO.setXmin(Double.valueOf(geometry.getEnvelopeInternal().getMinX()));
                    extentDTO.setXmax(Double.valueOf(geometry.getEnvelopeInternal().getMaxX()));
                    extentDTO.setYmin(Double.valueOf(geometry.getEnvelopeInternal().getMinY()));
                    extentDTO.setYmax(Double.valueOf(geometry.getEnvelopeInternal().getMaxY()));
                    featureResult.setExtent(extentDTO);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            item.remove("SHAPE_WKT");
            featureResult.setAttributes(item);
            if (OID != null) {
                featureResult.setObjectId(item.get(OID.getName()));
                featureResult.setName(item.get(OID.getName()));
            }
            data.add(featureResult);
        });
        dataQueryResult.setAliasName(appCatalogDataNodeDTO.getDisplayName());
        dataQueryResult.setData(data);
        dataQueryResult.setId(featureQueryFilterDTO.getNodeId());
        dataQueryResult.setName(appCatalogDataNodeDTO.getNodeName());
        dataQueryResult.setAliasName(appCatalogDataNodeDTO.getDisplayName());
        dataQueryResult.setTotal(responseObj.getLong("total"));
        this.queryResultFieldConvert(dataQueryResult, nodeFields);
        return dataQueryResult;
    }

    public CatalogDataNodeFieldsDTO findObjectFieldId(List<CatalogDataNodeFieldsDTO> nodeFields) {
        for (CatalogDataNodeFieldsDTO fld : nodeFields) {
            if (fld.getFieldType().intValue() != FieldType.OID.getValue()) continue;
            return fld;
        }
        return null;
    }

    private void queryResultFieldConvert(DataQueryResult result, List<CatalogDataNodeFieldsDTO> nodeFields) {
        if (nodeFields != null && nodeFields.size() > 0) {
            HashMap<String, Map<String, String>> fieldValueMap = new HashMap<String, Map<String, String>>(0);
            ArrayList<ReturnField> returnFields = new ArrayList<ReturnField>();
            Iterator<CatalogDataNodeFieldsDTO> nodeFieldIterator = nodeFields.iterator();
            FeatureResult featureData = null;
            if (result.getData() != null && result.getData().size() > 0) {
                featureData = (FeatureResult)result.getData().get(0);
            }
            while (nodeFieldIterator.hasNext()) {
                CatalogDataNodeFieldsDTO field = nodeFieldIterator.next();
                fieldValueMap.put(field.getName(), this.getFieldValueMap(field));
                if (!field.getDisplay().booleanValue()) continue;
                ReturnField returnField = new ReturnField();
                returnField.setAlias(field.getAliasName());
                if (featureData != null && featureData.getAttributes() != null) {
                    Set fieldKeys = featureData.getAttributes().keySet();
                    String findeField = fieldKeys.stream().filter(f -> f.equalsIgnoreCase(field.getName())).findFirst().orElse(null);
                    if (StringUtils.isNotEmpty((CharSequence)findeField)) {
                        returnField.setName(findeField);
                        field.setName(findeField);
                    } else {
                        returnField.setName(field.getName().toUpperCase());
                    }
                } else {
                    returnField.setName(field.getName().toUpperCase());
                }
                returnFields.add(returnField);
            }
            result.setFields(returnFields);
            for (FeatureResult featureResult : result.getData()) {
                for (CatalogDataNodeFieldsDTO field : nodeFields) {
                    if (StringUtil.isNotEmpty((String)field.getDictionaryKey()) && featureResult.getAttributes().containsKey(field.getName())) {
                        Object fieldValue = featureResult.getAttributes().get(field.getName());
                        String fieldValueString = ObjectUtils.isEmpty(fieldValue) ? "NULL" : fieldValue.toString();
                        Map valueMap = (Map)fieldValueMap.get(field.getName());
                        if (valueMap.containsKey(fieldValueString)) {
                            featureResult.getAttributes().put(field.getName(), valueMap.get(fieldValueString));
                        }
                    }
                    if (Boolean.TRUE.equals(field.getDataName())) {
                        featureResult.setName(featureResult.getAttributes().get(field.getName()));
                    }
                    if (!field.getDisplay().booleanValue()) {
                        featureResult.getAttributes().remove(field.getName());
                    }
                    if (field.getFieldType() != 4097) continue;
                    featureResult.setObjectId(featureResult.getAttributes().get(field.getName()));
                }
            }
        }
    }

    private Map<String, String> getFieldValueMap(CatalogDataNodeFieldsDTO field) {
        Map<String, String> keyValue = new HashMap<String, String>(0);
        if (field != null && StringUtil.isNotEmpty((String)field.getDictionaryKey())) {
            try {
                DmDictValueDTO dictValueTree = this.dictionaryService.getDictionaryTree(field.getDictionaryKey());
                if (dictValueTree != null) {
                    keyValue = this.getFieldValueMap(dictValueTree);
                }
            }
            catch (Exception var4) {
                this.log.error(field.getDictionaryKey(), (Throwable)var4);
            }
        }
        return keyValue;
    }

    private Map<String, String> getFieldValueMap(DmDictValueDTO dictValueTree) {
        HashMap<String, String> keyValue = new HashMap<String, String>(0);
        List dicValues = dictValueTree.getChildren();
        for (DmDictValueDTO dictValue : dicValues) {
            keyValue.put(dictValue.getCode(), dictValue.getName());
            if (dictValue.getChildren() == null || dictValue.getChildren().size() <= 0) continue;
            keyValue.putAll(this.getFieldValueMap(dictValue));
        }
        return keyValue;
    }

    @Override
    public Boolean add(List<OnlineQueryFields> list) {
        return this.saveBatch(list);
    }

    @Override
    public Boolean updateList(List<OnlineQueryFields> list) {
        if (list.size() > 0) {
            return this.saveOrUpdateBatch(list);
        }
        return false;
    }

    private Map buildQueryParams(FeatureQueryFilterDTO featureQueryFilterDTO, AppCatalogDataNodeDTO appCatalogDataNodeDTO) {
        HashMap<String, Object> geoserverRequestParams = new HashMap<String, Object>();
        if (featureQueryFilterDTO.getGeometryList() != null && featureQueryFilterDTO.getGeometryList().size() > 0) {
            JSONArray blocks = new JSONArray();
            featureQueryFilterDTO.getGeometryList().forEach(wkt -> blocks.add((Object)new JSONObject().fluentPut("DK_ID", (Object)blocks.size()).fluentPut("WKT", wkt).fluentPut("WKID", (Object)"4490")));
            geoserverRequestParams.put("Blocks", blocks);
        } else {
            geoserverRequestParams.put("Blocks", null);
        }
        geoserverRequestParams.put("SpatialRel", Adf4GeoserverSpatialRelEnum.getGeoserverSpatialRelEnum((String)featureQueryFilterDTO.getRelation().name()));
        geoserverRequestParams.put("saverecord", true);
        geoserverRequestParams.put("SFFHTX", true);
        geoserverRequestParams.put("translate", false);
        JSONObject customAnalysisItem = new JSONObject();
        JSONArray analysisDatas = new JSONArray();
        analysisDatas.add((Object)this.getAnalysisDataParm(featureQueryFilterDTO, appCatalogDataNodeDTO));
        customAnalysisItem.put("analysisDatas", (Object)analysisDatas);
        customAnalysisItem.put("analysisAlgorithm", (Object)"sjcx-common");
        customAnalysisItem.put("analysisItemName", null);
        geoserverRequestParams.put("customAnalysisItem", customAnalysisItem);
        JSONObject filter = new JSONObject();
        if (featureQueryFilterDTO.getPageIndex() == null) {
            featureQueryFilterDTO.setPageIndex(Integer.valueOf(0));
        }
        if (featureQueryFilterDTO.getRows() == null) {
            featureQueryFilterDTO.setRows(Integer.valueOf(10));
        }
        filter.put("page", (Object)(featureQueryFilterDTO.getPageIndex() + 1));
        filter.put("rows", (Object)featureQueryFilterDTO.getRows());
        geoserverRequestParams.put("filter", filter);
        return geoserverRequestParams;
    }

    private JSONObject getAnalysisDataParm(FeatureQueryFilterDTO featureQueryFilterDTO, AppCatalogDataNodeDTO appCatalogDataNodeDTO) {
        if (appCatalogDataNodeDTO == null || appCatalogDataNodeDTO.getDataset() == null || StrUtil.isBlank((CharSequence)appCatalogDataNodeDTO.getDataset().getDsKey())) {
            throw new RuntimeException("\u6570\u636e\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        String dataUrl = "geoserver:" + appCatalogDataNodeDTO.getDataset().getDsKey() + "/" + appCatalogDataNodeDTO.getDataset().getFullName().replace(".", "/");
        JSONObject analysisData = new JSONObject();
        analysisData.put("dataType", (Object)"default");
        analysisData.put("fields", null);
        analysisData.put("whereClause", (Object)featureQueryFilterDTO.getCondition());
        analysisData.put("dataUrl", (Object)dataUrl);
        return analysisData;
    }
}

