/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.service;

import cn.hutool.core.net.URLDecoder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogNodeDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeWrapper;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.ns.sys.utils.ProxyUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppCatalogNodeURLEncodeWrapper
implements AppCatalogNodeWrapper {
    @Value(value="${proxy.onemap.enable:false}")
    public Boolean proxyEnable;
    @Value(value="${proxy.onemap.default-proxy:false}")
    public Boolean defaultProxy;
    @Value(value="${proxy.onemap.default-rectifyOffset:false}")
    public Boolean defaultRectifyOffset;
    @Autowired
    private SysParamsService sysParamsService;

    public AppCatalogNodeDTO wrapCatalogNode(AppCatalogNodeDTO appCatalogNode) {
        return appCatalogNode;
    }

    public AppCatalogNodeDTO wrapCatalogNodeDetail(AppCatalogNodeDTO appCatalogNode) {
        AppCatalogDataNodeDTO appCatalogDataNodeDTO;
        if (!this.proxyEnable.booleanValue()) {
            return appCatalogNode;
        }
        if (appCatalogNode instanceof AppCatalogDataNodeDTO && (appCatalogDataNodeDTO = (AppCatalogDataNodeDTO)appCatalogNode).getHasRender().booleanValue() && appCatalogDataNodeDTO.getRender() != null) {
            this.urlManage(appCatalogDataNodeDTO.getRender());
        }
        return appCatalogNode;
    }

    public void urlManage(DatasetRenderDTO datasetRenderDTO) {
        Map serviceCapabilities;
        String tempURL;
        block12: {
            tempURL = "";
            if (datasetRenderDTO.getUrl().startsWith(ProxyUtil.getProxyURL())) {
                return;
            }
            try {
                String subdomain = null;
                Boolean offset = this.defaultRectifyOffset;
                String extension = datasetRenderDTO.getExtension();
                if (StringUtils.isNotBlank((CharSequence)extension)) {
                    JSONObject jSONObject = JSON.parseObject((String)extension);
                    Boolean activeToken = jSONObject.getBoolean("allowProxy");
                    if (activeToken == null || !activeToken.booleanValue()) {
                        return;
                    }
                    subdomain = jSONObject.getString("subdomain");
                    offset = jSONObject.getBoolean("rectifyOffset");
                    tempURL = ProxyUtil.queryTempProxyURL((String)datasetRenderDTO.getUrl(), (String)subdomain, (Boolean)offset);
                    break block12;
                }
                if (this.defaultProxy.booleanValue()) {
                    tempURL = ProxyUtil.queryTempProxyURL((String)datasetRenderDTO.getUrl(), subdomain, (Boolean)offset);
                    break block12;
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        datasetRenderDTO.setUrl(tempURL);
        String gkValStri = "";
        if (StringUtils.isNotEmpty((CharSequence)tempURL)) {
            try {
                Map<String, String> queryParams = this.parseQueryParams(tempURL);
                gkValStri = queryParams.get("gk");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            if (StringUtils.isNotEmpty((CharSequence)datasetRenderDTO.getMapServer())) {
                datasetRenderDTO.setMapServer(this.replaceIPorPort(datasetRenderDTO.getMapServer(), tempURL));
            }
        }
        if ((serviceCapabilities = datasetRenderDTO.getServiceCapabilities()) != null && !serviceCapabilities.isEmpty() && StringUtils.isNotEmpty((CharSequence)gkValStri) && StringUtils.isNotEmpty((CharSequence)tempURL)) {
            for (Map.Entry entry : serviceCapabilities.entrySet()) {
                String url = (String)entry.getValue();
                if (StringUtils.isEmpty((CharSequence)url)) continue;
                url = (url = this.replaceIPorPort(url, tempURL)).contains("?") ? url + "&gk=" + gkValStri : url + "?gk=" + gkValStri;
                entry.setValue(url);
            }
            datasetRenderDTO.setServiceCapabilities(serviceCapabilities);
        }
    }

    private Map<String, String> parseQueryParams(String uriString) throws URISyntaxException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        URI uri = new URI(uriString);
        String queryString = uri.getQuery();
        if (queryString != null) {
            Stream.of(queryString.split("&")).map(kv -> kv.split("=", 2)).forEach(parts -> {
                String key = URLDecoder.decode((String)parts[0], (Charset)StandardCharsets.UTF_8);
                String value = ((String[])parts).length > 1 ? URLDecoder.decode((String)parts[1], (Charset)StandardCharsets.UTF_8) : null;
                queryParams.put(key, value);
            });
        }
        return queryParams;
    }

    private String replaceIPorPort(String originUrlStr, String repalceFromUrlStr) {
        String _originUrlStr = originUrlStr.replace("https://", "").replace("http://", "");
        String _originIPorPort = _originUrlStr.split("/")[0];
        String _repalceFromUrlStr = repalceFromUrlStr.replace("https://", "").replace("http://", "");
        String _repalceFromUIPorPort = _repalceFromUrlStr.split("/")[0];
        return originUrlStr.replace(_originIPorPort, _repalceFromUIPorPort);
    }
}

