/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.config.dto.basemap.BaseMapDTO;
import com.geoway.adf.dms.config.dto.basemap.BaseMapGroupDTO;
import com.geoway.adf.dms.config.dto.basemap.BaseMapServiceDTO;
import com.geoway.ns.sys.utils.ProxyUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ProxyURLEncodeWrapper {
    @Value(value="${proxy.onemap.enable:false}")
    public Boolean proxyEnable;

    @Pointcut(value="execution(* com.geoway.adf.dms.config.service.impl.CmBaseMapServiceImpl.list(..))")
    private void pointCut() {
    }

    @Around(value="pointCut()")
    private Object BaseMapmanage(ProceedingJoinPoint joinPoint) throws Throwable {
        Object proceed = joinPoint.proceed(joinPoint.getArgs());
        if (this.proxyEnable.booleanValue()) {
            List list = (List)proceed;
            for (BaseMapGroupDTO dto : list) {
                List services = dto.getServices();
                for (BaseMapDTO service : services) {
                    try {
                        JSONObject object;
                        Boolean activeToken;
                        BaseMapServiceDTO serviceDTO = (BaseMapServiceDTO)service;
                        String subdomain = null;
                        Boolean offset = null;
                        String extension = serviceDTO.getExtension();
                        if (!StringUtils.isNotBlank((CharSequence)extension) || (activeToken = (object = JSON.parseObject((String)extension)).getBoolean("allowProxy")) == null || !activeToken.booleanValue()) continue;
                        subdomain = object.getString("subdomain");
                        offset = object.getBoolean("rectifyOffset");
                        String tempURL = ProxyUtil.queryTempProxyURL((String)serviceDTO.getServiceUrl(), (String)subdomain, (Boolean)offset);
                        serviceDTO.setServiceUrl(tempURL);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return list;
        }
        return proceed;
    }
}

