/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.tscx.service.impl;

import com.geoway.adf.dms.catalog.dto.CatalogDataNodeFieldsDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogNodeDTO;
import com.geoway.adf.dms.catalog.dto.query.FeatureQueryFilterDTO;
import com.geoway.adf.dms.catalog.dto.query.QueryByObjectIdDTO;
import com.geoway.adf.dms.catalog.dto.query.StatQueryNodeFilterDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeService;
import com.geoway.adf.dms.catalog.service.impl.AppCatalogLayerQueryServiceImpl;
import com.geoway.adf.dms.datasource.constant.ServiceFormatEnum;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.StatQueryResultDTO;
import com.geoway.ns.onemap.tscx.service.MapServerDatabaseService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Primary
@Service
@Transactional(rollbackFor={Exception.class})
public class TscxServiceImpl
extends AppCatalogLayerQueryServiceImpl {
    @Resource
    private AppCatalogNodeService appCatalogNodeService;
    @Resource
    private MapServerDatabaseService mapServerDatabaseService;

    public DataQueryResult queryData(FeatureQueryFilterDTO queryFilterDTO, AppCatalogNodeDTO appCatalogNode) {
        if (appCatalogNode == null) {
            appCatalogNode = this.appCatalogNodeService.getNodeDetail(queryFilterDTO.getNodeId());
        }
        Assert.notNull((Object)appCatalogNode, (String)"\u76ee\u5f55\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        if (appCatalogNode instanceof AppCatalogDataNodeDTO && Boolean.FALSE.equals(((AppCatalogDataNodeDTO)appCatalogNode).getDatasetValid())) {
            throw new RuntimeException(((AppCatalogDataNodeDTO)appCatalogNode).getDatasetInvalidMessage());
        }
        if (appCatalogNode instanceof AppCatalogDataNodeDTO) {
            AppCatalogDataNodeDTO appCatalogDataNode = (AppCatalogDataNodeDTO)appCatalogNode;
            ServiceFormatEnum serviceFormatEnum = ServiceFormatEnum.getByValue((Integer)appCatalogDataNode.getServiceFormat());
            if (serviceFormatEnum == ServiceFormatEnum.MapServer) {
                return this.mapServerDatabaseService.queryGeoDataset(appCatalogDataNode.getDatasetId(), (QueryFilterDTO)queryFilterDTO);
            }
            return super.queryData(queryFilterDTO, appCatalogNode);
        }
        throw new RuntimeException("\u8be5\u8282\u70b9\u4e0d\u652f\u6301\u67e5\u8be2\uff01");
    }

    public List<CatalogDataNodeFieldsDTO> queryDataNodeFields(String nodeId, Boolean onlyNumber) {
        AppCatalogNodeDTO appCatalogNode = this.appCatalogNodeService.getNodeDetail(nodeId);
        if (appCatalogNode instanceof AppCatalogDataNodeDTO) {
            AppCatalogDataNodeDTO appCatalogDataNode = (AppCatalogDataNodeDTO)appCatalogNode;
            ServiceFormatEnum serviceFormatEnum = ServiceFormatEnum.getByValue((Integer)appCatalogDataNode.getServiceFormat());
            if (serviceFormatEnum == ServiceFormatEnum.MapServer) {
                return this.mapServerDatabaseService.queryDataNodeFields(appCatalogDataNode.getDatasetId(), onlyNumber);
            }
            return super.queryDataNodeFields(nodeId, onlyNumber);
        }
        return new ArrayList<CatalogDataNodeFieldsDTO>();
    }

    public Long queryDataCount(FeatureQueryFilterDTO queryFilterDTO) {
        AppCatalogNodeDTO appCatalogNode = this.appCatalogNodeService.getNodeDetail(queryFilterDTO.getNodeId());
        Assert.notNull((Object)appCatalogNode, (String)"\u76ee\u5f55\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        if (appCatalogNode instanceof AppCatalogDataNodeDTO) {
            AppCatalogDataNodeDTO appCatalogDataNode = (AppCatalogDataNodeDTO)appCatalogNode;
            ServiceFormatEnum serviceFormatEnum = ServiceFormatEnum.getByValue((Integer)appCatalogDataNode.getServiceFormat());
            if (serviceFormatEnum == ServiceFormatEnum.MapServer) {
                return this.mapServerDatabaseService.queryDataCount(appCatalogDataNode.getDatasetId(), (QueryFilterDTO)queryFilterDTO);
            }
            return super.queryDataCount(queryFilterDTO);
        }
        throw new RuntimeException("\u8be5\u8282\u70b9\u4e0d\u652f\u6301\u67e5\u8be2\uff01");
    }

    public List<Object> queryDataFieldUniqValues(String nodeId, String fieldName, Integer limit) {
        AppCatalogNodeDTO appCatalogNode = this.appCatalogNodeService.getNodeDetail(nodeId);
        Assert.notNull((Object)appCatalogNode, (String)"\u6570\u636e\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        if (!(appCatalogNode instanceof AppCatalogDataNodeDTO)) {
            throw new RuntimeException("\u8282\u70b9\u4e0d\u652f\u6301\u67e5\u8be2");
        }
        AppCatalogDataNodeDTO appCatalogDataNode = (AppCatalogDataNodeDTO)appCatalogNode;
        ServiceFormatEnum serviceFormatEnum = ServiceFormatEnum.getByValue((Integer)appCatalogDataNode.getServiceFormat());
        if (serviceFormatEnum == ServiceFormatEnum.MapServer) {
            QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
            queryFilterDTO.setFields(fieldName);
            return this.mapServerDatabaseService.queryDataFieldUniqValues(appCatalogDataNode.getDatasetId(), queryFilterDTO, limit);
        }
        return super.queryDataFieldUniqValues(nodeId, fieldName, limit);
    }

    public DataQueryResult queryByObjectId(QueryByObjectIdDTO queryByObjectIdDTO) {
        AppCatalogNodeDTO appCatalogNode = this.appCatalogNodeService.getNodeDetail(queryByObjectIdDTO.getNodeId());
        Assert.notNull((Object)appCatalogNode, (String)"\u6570\u636e\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        if (!(appCatalogNode instanceof AppCatalogDataNodeDTO)) {
            throw new RuntimeException("\u8282\u70b9\u4e0d\u652f\u6301\u67e5\u8be2");
        }
        AppCatalogDataNodeDTO appCatalogDataNode = (AppCatalogDataNodeDTO)appCatalogNode;
        ServiceFormatEnum serviceFormatEnum = ServiceFormatEnum.getByValue((Integer)appCatalogDataNode.getServiceFormat());
        if (serviceFormatEnum == ServiceFormatEnum.MapServer) {
            return this.mapServerDatabaseService.queryGeoDataset(appCatalogDataNode.getDatasetId(), queryByObjectIdDTO.getObjectId().toString());
        }
        return super.queryByObjectId(queryByObjectIdDTO);
    }

    public List<StatQueryResultDTO> queryStatMulti(StatQueryNodeFilterDTO statDTO) {
        AppCatalogNodeDTO appCatalogNode = this.appCatalogNodeService.getNodeDetail(statDTO.getNodeId());
        if (!(appCatalogNode instanceof AppCatalogDataNodeDTO)) {
            throw new RuntimeException("\u8282\u70b9\u4e0d\u652f\u6301\u67e5\u8be2\u7edf\u8ba1");
        }
        AppCatalogDataNodeDTO appCatalogDataNode = (AppCatalogDataNodeDTO)appCatalogNode;
        ServiceFormatEnum serviceFormatEnum = ServiceFormatEnum.getByValue((Integer)appCatalogDataNode.getServiceFormat());
        if (serviceFormatEnum == ServiceFormatEnum.MapServer) {
            return this.mapServerDatabaseService.queryStatMulti(appCatalogDataNode.getDatasetId(), statDTO);
        }
        return super.queryStatMulti(statDTO);
    }
}

