/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.externaldata.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.ns.onemap.externaldata.service.IUserService;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ChangGuiZWPTServiceImpl {
    @Resource
    private SysParamsService sysParamsService;
    @Resource
    private IUserService userService;

    public String getUserTel(String url, String token, String userid) {
        JSONArray userArray = new JSONArray();
        userArray.add((Object)userid);
        String responseString = ((HttpRequest)HttpRequest.post((String)url).body(userArray.toJSONString()).header("Authorization", token)).execute().body();
        JSONObject responseJSON = JSONObject.parseObject((String)responseString);
        return responseJSON.getString(userid);
    }

    public String getCgzhptToken(String id) {
        JSONObject userInfoById = this.userService.getUserInfoById(id);
        if (userInfoById == null || !userInfoById.containsKey((Object)"params") || !userInfoById.getJSONObject("params").containsKey((Object)"uuid")) {
            throw new RuntimeException("\u7528\u6237\u6ca1\u6709\u8be5\u6743\u9650");
        }
        String userId = userInfoById.getJSONObject("params").getString("uuid");
        JSONObject configJson = this.getCgzhptConfig();
        String userTokenUrl = configJson.getString("userTokenUrl");
        JSONArray jsonArray = configJson.getJSONArray("configData");
        if (jsonArray == null || jsonArray.size() == 0 || StringUtils.isBlank((CharSequence)userTokenUrl) || StringUtils.isBlank((CharSequence)configJson.getString("openDetail"))) {
            throw new RuntimeException("\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570");
        }
        String baseUrl = jsonArray.getJSONObject(0).getString("baseUrl");
        String accessToken = this.getChangguiOauthToken(configJson);
        String url = baseUrl + userTokenUrl + "/" + userId;
        String responseString = ((HttpRequest)HttpRequest.get((String)url).header("Authorization", accessToken)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseString)) {
            throw new RuntimeException("\u83b7\u53d6token\u5931\u8d25");
        }
        return responseString;
    }

    public JSONObject getCgzhptConfig() {
        SysParamDTO sysParamDTO = this.sysParamsService.getDetail("hnSys", "cgzhptConfig");
        return JSONObject.parseObject((String)sysParamDTO.getValue());
    }

    public String getChangguiOauthToken(JSONObject configJson) {
        JSONArray jsonArray = configJson.getJSONArray("configData");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new RuntimeException("\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570");
        }
        String tokenUrl = configJson.getString("tokenUrl");
        String baseUrl = jsonArray.getJSONObject(0).getString("baseUrl");
        String Authorization = jsonArray.getJSONObject(0).getString("Authorization");
        if (StringUtils.isBlank((CharSequence)tokenUrl) || StringUtils.isBlank((CharSequence)Authorization)) {
            throw new RuntimeException("\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570");
        }
        return this.getChangguiOauthToken(baseUrl + tokenUrl, Authorization);
    }

    public String getChangguiOauthToken(String tokenUrl, String Authorization) {
        String url = tokenUrl + "?grant_type=client_credentials";
        String responseString = ((HttpRequest)HttpRequest.post((String)url).header("Authorization", Authorization)).execute().body();
        JSONObject responseJSON = JSONObject.parseObject((String)responseString);
        String access_token = responseJSON.getString("access_token");
        if (StringUtils.isEmpty((CharSequence)access_token)) {
            throw new RuntimeException("\u83b7\u53d6token\u5931\u8d25");
        }
        return "Bearer " + access_token;
    }

    public void syncChangguiInfo() {
        this.syncOrganization();
        this.syncChangguiUser();
    }

    public void syncOrganization() {
        JSONArray orgJson = this.getOrganizationTree();
        this.putOrganization(orgJson);
    }

    public void putOrganization(JSONArray orgJson) {
        for (int i = 0; i < orgJson.size(); ++i) {
            JSONObject org = orgJson.getJSONObject(i);
            String parentDeptId = org.getString("parentDeptId");
            String parentDeptName = org.getString("parentDeptName");
            String deptId = org.getString("deptId");
            String deptName = org.getString("deptName");
            String simpleDeptName = org.getString("simpleDeptName");
            JSONArray queryOrganization = this.userService.queryOrganization("Q_code_S_EQ=" + deptId + ";Q_name_S_EQ=" + deptName + ";");
            if (queryOrganization.size() == 0) {
                if ("-1".equals(org.getString("parentDeptId"))) {
                    this.userService.saveOrganization(null, deptName, simpleDeptName, deptId, "", "0", "0");
                } else {
                    JSONArray parentOrg = this.userService.queryOrganization("Q_code_S_EQ=" + parentDeptId + ";Q_name_S_EQ=" + parentDeptName + ";");
                    if (parentOrg.size() > 0) {
                        this.userService.saveOrganization(null, deptName, simpleDeptName, deptId, parentDeptId, parentOrg.getJSONObject(0).getString("id"), parentOrg.getJSONObject(0).getInteger("level") + 1 + "");
                    }
                }
            }
            this.putOrganization(org.getJSONArray("children"));
        }
    }

    public JSONArray getOrganizationTree() {
        int i;
        JSONObject configJson = this.getCgzhptConfig();
        if (configJson == null || StringUtils.isBlank((CharSequence)configJson.getString("departUrl"))) {
            throw new RuntimeException("\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570");
        }
        String token = this.getChangguiOauthToken(configJson);
        String departUrl = configJson.getString("departUrl");
        String syncTime = configJson.getString("syncTime");
        String unitIds = configJson.getString("unitIds");
        String baseUrl = configJson.getJSONArray("configData").getJSONObject(0).getString("baseUrl");
        JSONArray jsonArray = new JSONArray();
        Integer pageSize = 1000;
        JSONObject deptResponseJSON = this.getUserDepartApi(baseUrl + departUrl, token, syncTime, pageSize, 1, unitIds);
        Integer totalPage = deptResponseJSON.getInteger("pages");
        JSONArray records = deptResponseJSON.getJSONArray("records");
        if (records != null && records.size() > 0) {
            jsonArray.addAll((Collection)records);
        }
        if (totalPage > 1) {
            for (int i2 = 2; i2 <= totalPage; ++i2) {
                deptResponseJSON = this.getUserDepartApi(baseUrl + departUrl, token, syncTime, pageSize, i2, unitIds);
                records = deptResponseJSON.getJSONArray("records");
                if (records == null || records.size() <= 0) continue;
                jsonArray.addAll((Collection)records);
            }
        }
        JSONObject jsonObject = new JSONObject();
        JSONArray resuleJsonArray = new JSONArray();
        for (i = 0; i < jsonArray.size(); ++i) {
            JSONObject node = jsonArray.getJSONObject(i);
            node.put("children", (Object)new JSONArray());
            jsonObject.put(node.getString("deptId"), (Object)node);
        }
        for (i = 0; i < jsonArray.size(); ++i) {
            JSONObject node = jsonArray.getJSONObject(i);
            if (!"-1".equals(node.getString("parentDeptId")) && jsonObject.containsKey((Object)node.getString("parentDeptId"))) {
                jsonObject.getJSONObject(node.getString("parentDeptId")).getJSONArray("children").add((Object)node);
                continue;
            }
            if (!"-1".equals(node.getString("parentDeptId"))) continue;
            resuleJsonArray.add((Object)node);
        }
        return resuleJsonArray;
    }

    public void syncChangguiUser() {
        JSONObject configJson = this.getCgzhptConfig();
        String userListUrl = configJson.getString("userListUrl");
        String userPhoneUrl = configJson.getString("userPhoneUrl");
        String unitIds = configJson.getString("unitIds");
        String syncTime = configJson.getString("syncTime");
        String roleIds = configJson.getString("roleIds");
        String baseUrl = configJson.getJSONArray("configData").getJSONObject(0).getString("baseUrl");
        String token = this.getChangguiOauthToken(configJson);
        Integer pageSize = 1000;
        JSONObject userResponseJSON = this.getUserDepartApi(baseUrl + userListUrl, token, syncTime, pageSize, 1, unitIds);
        Integer totalPage = userResponseJSON.getInteger("pages");
        this.addUser(userResponseJSON, roleIds, baseUrl + userPhoneUrl, token);
        if (totalPage > 1) {
            for (int i = 2; i <= totalPage; ++i) {
                userResponseJSON = this.getUserDepartApi(baseUrl + userListUrl, token, syncTime, pageSize, i, unitIds);
                this.addUser(userResponseJSON, roleIds, baseUrl + userPhoneUrl, token);
            }
        }
    }

    public void addUser(JSONObject userResponseJSON, String defaultRoleIds, String baseUrl, String token) {
        JSONArray records = userResponseJSON.getJSONArray("records");
        if (records == null) {
            return;
        }
        JSONArray role = this.userService.queryRoleList("");
        for (int i = 0; i < records.size(); ++i) {
            int j;
            String filterParam;
            JSONArray sysUserList;
            JSONObject jsonObject = records.getJSONObject(i);
            if (StringUtils.isEmpty((CharSequence)jsonObject.getString("deptName")) || (sysUserList = this.userService.queryUser(filterParam = "Q_accout_S_EQ=" + jsonObject.getString("accountId"))) == null || sysUserList.size() > 1) continue;
            JSONObject sysUser = sysUserList.size() == 0 ? new JSONObject() : sysUserList.getJSONObject(0);
            String userId = jsonObject.getString("userId");
            String accountId = jsonObject.getString("accountId");
            String userName = jsonObject.getString("userName");
            String deptId = jsonObject.getString("deptId");
            String deptName = jsonObject.getString("deptName");
            String postInfo = jsonObject.getString("postInfo");
            JSONObject otherParams = new JSONObject();
            JSONArray org = this.userService.queryOrganization("Q_code_S_EQ=" + deptId + ";Q_name_S_EQ=" + deptName + ";");
            JSONArray orgList = new JSONArray();
            for (int j2 = 0; j2 < org.size(); ++j2) {
                orgList.add(org.getJSONObject(j2).get((Object)"id"));
            }
            otherParams.put("organizations", (Object)orgList);
            JSONArray roleList = new JSONArray();
            for (j = 0; j < role.size(); ++j) {
                if (!deptName.equals(role.getJSONObject(j).getString("name"))) continue;
                roleList.add(role.getJSONObject(j).get((Object)"id"));
            }
            for (j = 0; j < defaultRoleIds.split(",").length; ++j) {
                roleList.add((Object)defaultRoleIds.split(",")[j]);
            }
            otherParams.put("roles", (Object)roleList);
            JSONObject params = new JSONObject();
            params.put("uuid", (Object)userId);
            params.put("postInfo", (Object)postInfo);
            String tel = this.getUserTel(baseUrl, token, jsonObject.getString("userId"));
            this.userService.savaUser(sysUser.getString("id"), userName, accountId, StringUtils.defaultString((String)tel, (String)"--"), params.toJSONString(), otherParams.toJSONString());
        }
    }

    public JSONObject getUserDepartApi(String getUrl, String token, String syncTime, Integer pageSize, Integer pageIndex, String unitIds) {
        String url = getUrl + "?syncTime=" + syncTime + "&pageSize=" + pageSize + "&pageIndex=" + pageIndex + "&unitIds=" + unitIds;
        String responseString = ((HttpRequest)HttpRequest.get((String)url).header("Authorization", token)).execute().body();
        return JSONObject.parseObject((String)responseString);
    }
}

