/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.controller.overlay;

import com.geoway.ns.onemap.overlay.entity.TbOverlayCache;
import com.geoway.ns.onemap.overlay.service.TbOverlayCacheService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.impl.TokenServiceImpl;
import com.geoway.ns.sys.utils.MyRequestUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53e0\u52a0\u529f\u80fd\u7f13\u5b58"})
@RestController
@RequestMapping(value={"/overlayCache"})
public class TbOverlayCacheController {
    @Autowired
    private TbOverlayCacheService tbOverlayCacheService;
    @Autowired
    private TokenServiceImpl tokenService;

    @ApiOperation(value="1-\u6839\u636e\u5206\u7ec4\u83b7\u53d6\u4e3b\u9898\u5217\u8868")
    @GetMapping(value={"/listByUserid"})
    public BaseResponse listByUserid(HttpServletRequest request) {
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token, Boolean.valueOf(false));
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            return DataResponse.success(this.tbOverlayCacheService.listByUserid(sysUser.getId()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return DataResponse.error((Exception)e);
        }
    }

    @ApiOperation(value="2-\u53e0\u52a0\u56fe\u5c42\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    public BaseResponse save(HttpServletRequest request, @Valid @RequestBody TbOverlayCache param) {
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token, Boolean.valueOf(false));
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            param.setUserid(sysUser.getId());
            return DataResponse.success((Object)this.tbOverlayCacheService.addOrUpdate(param));
        }
        catch (Exception e) {
            e.printStackTrace();
            return DataResponse.error((Exception)e);
        }
    }

    @ApiOperation(value="3-\u53e0\u52a0\u56fe\u5c42\u5220\u9664(\u5355\u4e2a\u6761\u76ee)")
    @GetMapping(value={"/remove"})
    public BaseResponse remove(@RequestParam(value="id") String id) {
        boolean res = this.tbOverlayCacheService.remove(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @ApiOperation(value="4-\u53e0\u52a0\u56fe\u5c42\u5220\u9664(\u591a\u4e2a\u6761\u76ee) id\u5217\u8868\uff0c\u591a\u4e2aid\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    @GetMapping(value={"/removes"})
    public BaseResponse removes(@RequestParam(value="ids") String ids) {
        String[] idArr = ids.split(",");
        this.tbOverlayCacheService.removes(Arrays.asList(idArr));
        return BaseResponse.success();
    }
}

