/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.onemap.controller.theme;

import com.geoway.ns.onemap.theme.entity.TbScene;
import com.geoway.ns.onemap.theme.service.TbSceneService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e3b\u9898\u573a\u666f"})
@RestController
@RequestMapping(value={"/theme/scene"})
public class TbSceneController {
    @Autowired
    private TbSceneService tbSceneService;

    @ApiOperation(value="1-\u83b7\u53d6\u573a\u666f\u76ee\u5f55\u6811")
    @GetMapping(value={"/listByTheme/{themeId}"})
    public BaseResponse listByTheme(@PathVariable Long themeId) {
        return DataResponse.success(this.tbSceneService.listByTheme(themeId));
    }

    @ApiOperation(value="2-\u4e3b\u9898\u573a\u666f\u8be6\u60c5")
    @GetMapping(value={"/info/{id}"})
    public BaseResponse info(@PathVariable Long id) {
        return DataResponse.success((Object)this.tbSceneService.info(id));
    }

    @ApiOperation(value="3-\u4e3b\u9898\u573a\u666f\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    public BaseResponse save(@Valid @RequestBody TbScene param) {
        return DataResponse.success((Object)this.tbSceneService.addOrUpdate(param));
    }

    @ApiOperation(value="4-\u4e3b\u9898\u573a\u666f\u5220\u9664(\u5355\u4e2a\u6761\u76ee)")
    @GetMapping(value={"/remove/{id}"})
    public BaseResponse remove(@PathVariable Long id) {
        boolean res = this.tbSceneService.remove(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @ApiOperation(value="5-\u4e3b\u9898\u573a\u666f\u5220\u9664(\u591a\u4e2a\u6761\u76ee)")
    @PostMapping(value={"/removes"})
    public BaseResponse removes(@Valid @RequestBody List<Long> ids) {
        this.tbSceneService.removes(ids);
        return BaseResponse.success();
    }

    @RequestMapping(value={"/updateToFirst"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="7-\u7f6e\u9876")
    public BaseResponse updateToFirst(@RequestParam(value="id") Long id) {
        boolean res = this.tbSceneService.updateToFirst(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToLast"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="8-\u7f6e\u5e95")
    public BaseResponse updateToLast(@RequestParam(value="id") Long id) {
        boolean res = this.tbSceneService.updateToLast(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToPre"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="9-\u4e0a\u79fb")
    public BaseResponse updateToPre(@RequestParam(value="id") Long id) {
        boolean res = this.tbSceneService.updateToPre(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToSuffix"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="10-\u4e0b\u79fb")
    public BaseResponse updateToSuffix(@RequestParam(value="id") Long id) {
        boolean res = this.tbSceneService.updateToSuffix(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/moveSort"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="10-\u62d6\u62fd\u6392\u5e8f")
    public BaseResponse moveSort(@RequestParam(value="id") Long id, @RequestParam(value="targetOrder") Long targetOrder) {
        boolean res = this.tbSceneService.sort(id, targetOrder);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @ApiOperation(value="11-\u62f7\u8d1d\u573a\u666f")
    @PostMapping(value={"/copy"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="originId", value="\u539f\u59cb\u573a\u666fid", required=true, dataTypeClass=Long.class), @ApiImplicitParam(name="tarId", value="\u62f7\u8d1d\u5230\u7684\u573a\u666f\u5206\u7ec4id", required=true, dataTypeClass=Long.class)})
    public BaseResponse copy(@RequestParam(value="originId") Long originId, @RequestParam(value="tarId") Long tarId) {
        return DataResponse.success((Object)this.tbSceneService.copy(originId, tarId));
    }
}

