/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.config;

import cn.hutool.core.util.StrUtil;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class MongoClientConfig {
    private static final Logger logger = LogManager.getLogger(MongoClientConfig.class);
    @Value(value="${mongo.url:}")
    private String url;
    @Value(value="${mongo.collection:}")
    private String mongoCollection;
    public MongoCollection<Document> collection;
    private boolean available = false;

    @PostConstruct
    public void init() {
        if (StringUtils.isNotBlank((CharSequence)this.url) && StringUtils.isNotBlank((CharSequence)this.mongoCollection)) {
            try {
                logger.info("\u5df2\u542f\u7528mongo\u7f13\u5b58\uff0c\u6b63\u5728\u521d\u59cb\u5316mongodb\u8fde\u63a5\uff01");
                String db = this.getDb(this.url);
                ConnectionString connectionString = new ConnectionString(this.url);
                MongoClientSettings.Builder settingBuilder = MongoClientSettings.builder().applyConnectionString(connectionString).applyToSslSettings(s -> s.invalidHostNameAllowed(true));
                MongoClient mongoClient = MongoClients.create((MongoClientSettings)settingBuilder.build());
                MongoDatabase mongoDatabase = mongoClient.getDatabase(db);
                this.collection = mongoDatabase.getCollection(this.mongoCollection);
                this.collection.countDocuments();
                this.available = true;
                logger.info("\u521d\u59cb\u5316mongodb\u8fde\u63a5\u5b8c\u6210\uff01");
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316mongodb\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    public byte[] get(String key) {
        Document document = (Document)this.collection.find((Bson)new Document("key", (Object)key)).first();
        if (document == null) {
            return null;
        }
        return ((Binary)document.get((Object)"data")).getData();
    }

    public boolean has(String key) {
        return this.collection.find((Bson)new Document("key", (Object)key)).first() != null;
    }

    public void save(String key, byte[] data) {
        this.collection.insertOne((Object)new Document("key", (Object)key).append("data", (Object)data));
    }

    public void remove(String key) {
        this.collection.deleteOne((Bson)new Document("key", (Object)key));
    }

    public void clearAll() {
        this.collection.drop();
    }

    public void clearByKey(String searchPattern) {
        boolean caseInsensitive = true;
        Bson filter = Filters.regex((String)"key", (String)searchPattern, (String)(caseInsensitive ? "i" : ""));
        this.collection.deleteMany(filter);
    }

    public boolean available() {
        return this.available;
    }

    private String getDb(String mongoUrl) {
        int index = mongoUrl.lastIndexOf("/");
        Assert.state((index > 0 ? 1 : 0) != 0, (String)"\u8fde\u63a5\u53c2\u6570\u6709\u8bef : \u672a\u6307\u5b9a\u6570\u636e\u5e93!");
        int index1 = mongoUrl.lastIndexOf("?");
        if (index1 > 0) {
            return StrUtil.sub((CharSequence)mongoUrl, (int)(index + 1), (int)index1);
        }
        return mongoUrl.substring(index + 1);
    }
}

