/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.utils;

import cn.hutool.core.util.StrUtil;
import org.springframework.stereotype.Component;

@Component
public class IpVerification {
    public boolean ipExistsInRange(String ip, String ipSection) {
        boolean flag = true;
        if (StrUtil.isNotBlank((CharSequence)ipSection)) {
            ip = ip.trim();
            ipSection = ipSection.trim();
            String[] split = ipSection.split(",");
            for (int i = 0; i < split.length; ++i) {
                flag = this.ipType(split[i], ip);
                if (!flag) continue;
                return flag;
            }
        }
        return flag;
    }

    public long getIp(String ip) {
        ip = ip.trim();
        String[] ips = ip.split("\\.");
        long ipLong = 0L;
        for (int i = 0; i < 4; ++i) {
            ipLong = ipLong << 8 | (long)Integer.parseInt(ips[i]);
        }
        return ipLong;
    }

    public boolean ipType(String ips, String ip) {
        if (StrUtil.isNotBlank((CharSequence)ips)) {
            Integer i = ips.split("\\.").length;
            if (i == 1) {
                ips = ips + ".0.0.0-" + ips + ".255.255.255";
            } else if (i == 2) {
                ips = ips + ".0.0-" + ips + ".255.255";
            } else if (i == 3) {
                ips = ips + ".0-" + ips + ".255";
            } else if (i == 4) {
                return ips.equals(ip);
            }
            int idx = ips.indexOf(45);
            if (idx > 0) {
                String beginIP = ips.substring(0, idx);
                String endIP = ips.substring(idx + 1);
                return this.getIp(beginIP) <= this.getIp(ip) && this.getIp(ip) <= this.getIp(endIP) || this.getIp(endIP) <= this.getIp(ip) && this.getIp(ip) <= this.getIp(beginIP);
            }
        }
        return true;
    }
}

