/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.proxy.config.ApplicationYmlConfig;
import com.geoway.ns.proxy.constant.enums.TempProxyType;
import com.geoway.ns.proxy.dto.ExcursionDTO;
import com.geoway.ns.proxy.service.MapExcursionService;
import com.geoway.ns.proxy.service.ProxyTokenService;
import com.geoway.ns.proxy.service.RedisTemplateService;
import com.geoway.ns.proxy.service.UniversalProxyService;
import com.geoway.ns.proxy.utils.UnityUtils;
import com.geoway.ns.proxy.utils.httpclient.ProxyHttpClient;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.stereotype.Service;

@Service
public class UniversalProxyServiceImpl
implements UniversalProxyService {
    private static final String DNR = "DNR";
    private static final String OST = "OST";
    @Value(value="${dnr.enable:true}")
    private Boolean dnrEnable;
    @Value(value="${dnr.address:}")
    private String address;
    @Value(value="${py.enable:false}")
    private Boolean pyEnable;
    @Value(value="${py.cacheLevel:0}")
    private Integer cacheLevel;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private ApplicationYmlConfig applicationYmlConfig;
    @Autowired
    private ProxyTokenService proxyTokenService;
    @Autowired
    private MapExcursionService mapExcursionService;

    @Override
    public void proxy(String token, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BufferedImage image;
        if (StrUtil.isBlank((CharSequence)token)) {
            throw new Exception("\u3010gk\u3011\u4e3anull\u6216\u4e0d\u5b58\u5728\uff01");
        }
        ProxyHttpClient httpClient = new ProxyHttpClient();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String url = "";
        String substring = token.substring(0, 2);
        Boolean hasKey = this.redisTemplateService.isHasKey("proxyTemData:" + token);
        if (!hasKey.booleanValue()) {
            throw new Exception("\u5f53\u524d\u5730\u5740\u5df2\u5931\u6548\uff01\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01");
        }
        BoundHashOperations hash = this.redisTemplateService.getInfoByBoundValueHash("proxyTemData:" + token);
        if (TempProxyType.TEMP_PROXY.name.equals(substring)) {
            url = hash.get((Object)"url").toString();
        } else if (TempProxyType.TEMP_PROXY_HIDE.name.equals(substring)) {
            Map entries = hash.entries();
            for (Map.Entry entry : entries.entrySet()) {
                if ("url".equals(entry.getKey())) {
                    url = (String)entry.getValue();
                    continue;
                }
                if ("type".equals(entry.getKey())) continue;
                map.put((String)entry.getKey(), entry.getValue());
            }
        }
        String requestURL = (String)request.getAttribute("requestURL");
        url = UnityUtils.getRealUrlUtil(url, 1) + UnityUtils.getRealUrlUtil(requestURL, 2);
        this.verifyDNR(token, request);
        url = this.manageSubDomain(token, url);
        Object offset = hash.get((Object)"offset");
        ExcursionDTO excursionDTO = new ExcursionDTO();
        this.mapExcursionService.analysisUrl(requestURL, excursionDTO);
        if (this.pyEnable.booleanValue() && !excursionDTO.getException().booleanValue() && offset != null && ((Boolean)offset).booleanValue() && excursionDTO.getLevel() > this.cacheLevel && (image = this.mapExcursionService.excursion(url + "?" + UnityUtils.getRealUrlUtil(requestURL, 4))) != null) {
            ServletOutputStream outputStream = response.getOutputStream();
            ImageIO.write((RenderedImage)image, "png", (OutputStream)outputStream);
            return;
        }
        httpClient.fetchs(url, map, request, response);
    }

    @Override
    public String getProxy(String params) throws Exception {
        JSONObject jsonObject = JSONObject.parseObject((String)params);
        String url = jsonObject.getString("url");
        Integer type = jsonObject.getInteger("type");
        Boolean isDomain = jsonObject.getBoolean("isDomain");
        String Domain = jsonObject.getString("subDomain");
        Boolean offset = jsonObject.getBoolean("offset");
        if (StrUtil.isBlank((CharSequence)url)) {
            throw new Exception("\u539f\u59cb\u5730\u5740\u4e0d\u5b58\u5728\uff01\uff01\uff01");
        }
        if (type == null) {
            type = TempProxyType.TEMP_PROXY.value;
        }
        HashMap paramMap = new HashMap();
        for (Map.Entry entry : jsonObject.entrySet()) {
            paramMap.put(entry.getKey(), entry.getValue());
        }
        String tag = TempProxyType.getName(type);
        String uuid = UUID.randomUUID().toString();
        String token = String.format("%s-%s", tag, uuid.replace("-", ""));
        if (isDomain != null && isDomain.booleanValue()) {
            token = token + DNR;
        }
        String proxyUrl = this.initProxyUrl(url, type, token);
        this.redisTemplateService.setInfoByBoundValueOps("proxyTemToken:" + token, token, this.applicationYmlConfig.getTemporaryToken(), TimeUnit.MINUTES);
        if (!paramMap.isEmpty()) {
            this.redisTemplateService.setInfoByBoundValueHash("proxyTemData:" + token, paramMap, this.applicationYmlConfig.getTemporaryToken(), TimeUnit.MINUTES);
        }
        if (StringUtils.isNotBlank((CharSequence)Domain)) {
            this.redisTemplateService.setInfoByBoundValueOps("proxySubDomain:" + token, Domain, this.applicationYmlConfig.getTemporaryToken(), TimeUnit.MINUTES);
        }
        return proxyUrl;
    }

    private String initProxyUrl(String url, Integer type, String token) throws Exception {
        if (type.equals(TempProxyType.TEMP_PROXY.value)) {
            URL fullRUL = URLUtil.url((String)url);
            int index = url.indexOf("/", url.indexOf("/") + 2);
            String relative = url.substring(index);
            int indexOf = url.indexOf("?");
            url = indexOf < 0 ? relative + "?gk=" + token : relative + "&gk=" + token;
        } else if (type.equals(TempProxyType.TEMP_PROXY_HIDE.value)) {
            url = "/temporaryProxy?gk=" + token;
        } else {
            throw new Exception("\u4ee3\u7406\u7c7b\u578b\u9519\u8bef\uff0810.\u6b63\u5e38\u4ee3\u7406  11.\u9690\u5f0f\u4ee3\u7406\uff09");
        }
        return this.applicationYmlConfig.getProxyUrl() + url;
    }

    private Boolean verifyDNR(String gk, HttpServletRequest request) {
        if (this.dnrEnable.booleanValue() && gk.endsWith(DNR)) {
            String[] split;
            String referer = request.getHeader("referer");
            if (StringUtils.isBlank((CharSequence)referer)) {
                throw new RuntimeException("\u4e0d\u5177\u5907\u8bbf\u95ee\u6743\u9650\uff01");
            }
            for (String s : split = this.address.split(",")) {
                if (!referer.startsWith(s)) continue;
                return true;
            }
            throw new RuntimeException("\u4e0d\u5177\u5907\u8bbf\u95ee\u6743\u9650\uff01");
        }
        return true;
    }

    private String manageSubDomain(String gk, String url) {
        String subDomain = this.redisTemplateService.getInfoByBoundValueOps("proxySubDomain:" + gk);
        if (StringUtils.isNotBlank((CharSequence)subDomain)) {
            subDomain = subDomain.substring(1, subDomain.length() - 1);
            String[] split = subDomain.split(";");
            Random random = new Random();
            int i = random.nextInt(split.length);
            String s = split[i];
            return url.replace("{s}", s);
        }
        return url;
    }
}

