/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.service.impl;

import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.base.exception.BizException;
import com.geoway.ns.proxy.constant.enums.TokenModel;
import com.geoway.ns.proxy.entity.ProxyApplication;
import com.geoway.ns.proxy.mapper.ProxyApplicationMapper;
import com.geoway.ns.proxy.service.ProxyApplicationService;
import com.geoway.ns.proxy.service.ProxyTokenService;
import com.geoway.ns.sys.support.query.MPJQueryMapperUtil;
import com.geoway.ns.sys.utils.BaseTreeUtil;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ProxyApplicationServiceImpl
extends ServiceImpl<ProxyApplicationMapper, ProxyApplication>
implements ProxyApplicationService {
    @Resource
    ProxyTokenService proxyTokenService;
    private final TreeNodeConfig treeNodeConfig = new TreeNodeConfig().setParentIdKey("pid").setWeightKey("createtime").setIdKey("id");

    @Override
    public ProxyApplication saveApplication(ProxyApplication proxyApplication) throws BizException {
        boolean checkResult = this.checkPrxoyApp(proxyApplication);
        if (!checkResult) {
            throw new BizException("\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        this.saveOrUpdate(proxyApplication);
        proxyApplication = (ProxyApplication)this.getById((Serializable)((Object)proxyApplication.getId()));
        if (StrUtil.isBlank((CharSequence)proxyApplication.getToken())) {
            String token = this.proxyTokenService.fetchToken(proxyApplication.getId(), proxyApplication.getName(), TokenModel.application);
            proxyApplication.setToken(token);
            this.saveOrUpdate(proxyApplication);
        }
        return proxyApplication;
    }

    @Override
    public ProxyApplication saveGroup(String id, String pid, String name) throws BizException {
        ProxyApplication proxyApplication = new ProxyApplication();
        proxyApplication.setId(id);
        proxyApplication.setPid(pid);
        proxyApplication.setName(name);
        proxyApplication.setType(0);
        boolean checkResult = this.checkPrxoyApp(proxyApplication);
        if (!checkResult) {
            throw new BizException("\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        this.saveOrUpdate(proxyApplication);
        return proxyApplication;
    }

    @Override
    public void deleteOne(String id) throws BizException {
        ProxyApplication proxyApplication = (ProxyApplication)this.getById((Serializable)((Object)id));
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ProxyApplication::getPid, (Object)id);
        long iCount = this.count((Wrapper)queryWrapper);
        if (iCount > 0L && proxyApplication.getType() == 0) {
            throw new BizException("\u5206\u7ec4\u4e0b\u6709\u5e94\u7528\u4e0d\u80fd\u5220\u9664");
        }
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public void batchDelete(String ids) throws BizException {
        String[] idArr;
        for (String id : idArr = ids.split(",")) {
            this.deleteOne(id);
        }
    }

    @Override
    public List<ProxyApplication> queryTreeByFilter(String filterParam, String sortParam) throws Exception {
        MPJQueryMapperUtil queryMapperUtil = new MPJQueryMapperUtil();
        MPJLambdaWrapper queyrWrapper = queryMapperUtil.queryMapper(filterParam, sortParam, ProxyApplication.class);
        List apps = this.list((Wrapper)queyrWrapper);
        List allPids = apps.stream().map(item -> item.getPid()).collect(Collectors.toList());
        List allIds = apps.stream().map(item -> item.getId()).collect(Collectors.toList());
        List missPids = allPids.stream().filter(item -> !allIds.contains(item) && !item.equals("-1")).collect(Collectors.toList());
        if (missPids.size() > 0) {
            List misApps = this.listByIds(missPids);
            apps.addAll(misApps);
        }
        return BaseTreeUtil.listToTree((List)apps, (TreeNodeConfig)this.treeNodeConfig, (String)"-1");
    }

    private boolean checkPrxoyApp(ProxyApplication proxyApplication) {
        long iCount;
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ProxyApplication::getName, (Object)proxyApplication.getName());
        queryWrapper.eq(ProxyApplication::getPid, (Object)proxyApplication.getPid());
        if (StrUtil.isNotBlank((CharSequence)proxyApplication.getId())) {
            queryWrapper.ne(ProxyApplication::getId, (Object)proxyApplication.getId());
        }
        return (iCount = this.count((Wrapper)queryWrapper)) <= 0L;
    }
}

