/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.geoway.ns.proxy.entity.AuthorizeToken;
import com.geoway.ns.proxy.service.RedisTemplateService;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RedisTemplateServiceImpl
implements RedisTemplateService {
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public Boolean isHasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    @Override
    public AuthorizeToken getAuthorizeToken(String key) {
        Object data = this.redisTemplate.boundValueOps((Object)key).get();
        if (ObjectUtil.isNotEmpty((Object)data)) {
            return (AuthorizeToken)data;
        }
        return null;
    }

    @Override
    public void setAuthorizeToken(String key, AuthorizeToken authorizeToken) {
        this.redisTemplate.boundValueOps((Object)key).set((Object)authorizeToken, 1L, TimeUnit.MINUTES);
    }

    @Override
    public Integer getFrequency(String key) {
        Object data = this.redisTemplate.boundValueOps((Object)key).get();
        if (ObjectUtil.isNotEmpty((Object)data)) {
            return Integer.valueOf(data.toString());
        }
        return null;
    }

    @Override
    public void setFrequency(String key, Integer integer, Long time, TimeUnit unit) {
        this.redisTemplate.boundValueOps((Object)key).set((Object)integer, time.longValue(), unit);
    }

    @Override
    public String getInfoByBoundValueOps(String key) {
        Object data = this.redisTemplate.boundValueOps((Object)key).get();
        if (ObjectUtil.isNotEmpty((Object)data)) {
            String json = JSON.toJSONString((Object)data);
            return json;
        }
        return null;
    }

    @Override
    public void setInfoByBoundValueOps(String key, Object info, Integer time, TimeUnit unit) {
        this.redisTemplate.boundValueOps((Object)key).set(info, (long)time.intValue(), unit);
    }

    @Override
    public Object getObjectByBoundValueOps(String key) {
        return this.redisTemplate.boundValueOps((Object)key).get();
    }

    @Override
    public BoundHashOperations getInfoByBoundValueHash(String key) {
        return this.redisTemplate.boundHashOps((Object)key);
    }

    @Override
    public void setInfoByBoundValueHash(String key, Map info, Integer time, TimeUnit unit) {
        this.redisTemplate.boundHashOps((Object)key).putAll(info);
        this.redisTemplate.expire((Object)key, (long)time.intValue(), unit);
    }

    @Override
    public void setInfo(String key, String value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    @Override
    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    @Override
    public void deleteKey(String key) {
        this.redisTemplate.delete((Object)key);
    }
}

