/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.proxy.utils;

import cn.hutool.core.util.StrUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.springframework.stereotype.Component;

@Component
public class IpVerification {
    public boolean ipExistsInRange(String ip, String ipSection) {
        boolean flag = true;
        if (StrUtil.isNotBlank((CharSequence)ipSection)) {
            ip = ip.trim();
            ipSection = ipSection.trim();
            String[] split = ipSection.split(",");
            for (int i = 0; i < split.length; ++i) {
                flag = this.ipType(split[i], ip);
                if (!flag) continue;
                return flag;
            }
        }
        return flag;
    }

    public long getIp(String ip) {
        ip = ip.trim();
        String[] ips = ip.split("\\.");
        long ipLong = 0L;
        for (int i = 0; i < 4; ++i) {
            ipLong = ipLong << 8 | (long)Integer.parseInt(ips[i]);
        }
        return ipLong;
    }

    public boolean ipType(String ips, String ip) {
        if (ips.equals(ip)) {
            return true;
        }
        String resolvedIps = this.resolveDomain(ips);
        if (resolvedIps == null) {
            return false;
        }
        String resolvedIp = this.resolveDomain(ip);
        if (resolvedIp == null) {
            return false;
        }
        if (StrUtil.isNotBlank((CharSequence)resolvedIps)) {
            Integer i = resolvedIps.split("\\.").length;
            if (i == 1) {
                resolvedIps = resolvedIps + ".0.0.0-" + resolvedIps + ".255.255.255";
            } else if (i == 2) {
                resolvedIps = resolvedIps + ".0.0-" + resolvedIps + ".255.255";
            } else if (i == 3) {
                resolvedIps = resolvedIps + ".0-" + resolvedIps + ".255";
            } else if (i == 4) {
                return resolvedIps.equals(resolvedIp);
            }
            int idx = resolvedIps.indexOf(45);
            if (idx > 0) {
                String beginIP = resolvedIps.substring(0, idx);
                String endIP = resolvedIps.substring(idx + 1);
                long beginIpValue = this.getIp(beginIP);
                long endIpValue = this.getIp(endIP);
                long targetIpValue = this.getIp(resolvedIp);
                return beginIpValue <= targetIpValue && targetIpValue <= endIpValue || endIpValue <= targetIpValue && targetIpValue <= beginIpValue;
            }
        }
        return true;
    }

    private String resolveDomain(String host) {
        if (StrUtil.isBlank((CharSequence)host)) {
            return host;
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            return address.getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

