/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.config;

import com.fasterxml.classmate.TypeResolver;
import io.swagger.models.auth.In;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

@Configuration
@Import(value={BeanValidatorPluginsConfiguration.class})
public class SmartSwaggerConfig {
    private static final String title = "\u667a\u80fd\u5de5\u5177\u63a5\u53e3\u6587\u6863";
    private static final String version = "1.0.0";
    private static final String groupName = "smart-1.0";
    private static final String basePackage = "com.geoway.ns.smart";
    private static final String webSite = "http://www.geoway.com.cn/";
    private static final String description = "\u4fe1\u606f\u5e73\u53f04.0 \u667a\u80fd\u5de5\u5177\u63a5\u53e3\u8bf4\u660e\u548c\u5728\u7ebf\u6d4b\u8bd5";
    @Value(value="${swagger.enabled:false}")
    private Boolean enabled;
    private final TypeResolver typeResolver;
    @Value(value="${spring.mvc.pathmatch.matching-strategy:}")
    private String matchingStrategy;

    @Autowired
    public SmartSwaggerConfig(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @Bean
    public Docket createSmartRestApi() {
        Docket docket = new Docket(DocumentationType.OAS_30).enable(this.enabled.booleanValue()).apiInfo(this.apiInfo()).groupName(groupName).select().apis(RequestHandlerSelectors.basePackage((String)basePackage)).paths(PathSelectors.any()).build().securitySchemes(this.securitySchemes()).securityContexts(this.securityContexts());
        return docket;
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(title).description(description).termsOfServiceUrl(webSite).version(version).build();
    }

    private List<SecurityScheme> securitySchemes() {
        ApiKey apiKey = new ApiKey("access_token", "access_token", In.HEADER.toValue());
        return Collections.singletonList(apiKey);
    }

    private List<SecurityContext> securityContexts() {
        return Collections.singletonList(SecurityContext.builder().securityReferences(Collections.singletonList(new SecurityReference("access_token", new AuthorizationScope[]{new AuthorizationScope("global", "")}))).build());
    }
}

