/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.ns.smart.znts.dto.HistoryImgDTO;
import com.geoway.ns.smart.znts.enums.BizEnum;
import com.geoway.ns.smart.znts.service.MediaService;
import com.geoway.ns.smart.znts.vo.HistoryImgVO;
import com.geoway.ns.sys.service.FileServerService;
import com.geoway.ns.sys.utils.RedisUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class MediaServiceImpl
implements MediaService {
    public static final String HASH_KEY = "hashKey:img";
    @Resource
    RedisTemplate redisTemplate;
    @Resource
    private SysParamsService sysParamsService;
    @Resource
    private FileServerService fileServerService;
    @Resource
    RedisUtil redisUtil;

    @Override
    public Map<String, Object> historyImage(HistoryImgDTO dto) throws Exception {
        List<Object> historyImgVOS = new ArrayList();
        this.verify(dto);
        if (BizEnum.GJ.value.equals(dto.getType())) {
            historyImgVOS = this.getHistoryImg(dto.getWkt());
        } else if (!BizEnum.SJ.value.equals(dto.getType())) {
            if (BizEnum.HN.value.equals(dto.getType())) {
                historyImgVOS = this.getHNHistoryImg(dto.getWkt());
            } else {
                historyImgVOS = this.getHistoryImg(dto.getWkt());
                List<HistoryImgVO> hnList = this.getHNHistoryImg(dto.getWkt());
                historyImgVOS.addAll(hnList);
            }
        }
        this.dataManage(historyImgVOS);
        Map<String, List<HistoryImgVO>> listMap = historyImgVOS.stream().collect(Collectors.groupingBy(HistoryImgVO::getTime));
        listMap.remove("");
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("times", listMap.keySet().stream().sorted());
        result.put("info", new TreeMap<String, List<HistoryImgVO>>(listMap));
        return result;
    }

    private void dataManage(List<HistoryImgVO> historyImgVOS) {
        BoundHashOperations hashOps = this.redisTemplate.boundHashOps((Object)HASH_KEY);
        historyImgVOS.forEach(h -> {
            if (hashOps.hasKey((Object)h.getId()).booleanValue()) {
                HistoryImgVO his = (HistoryImgVO)hashOps.get((Object)h.getId());
                BeanUtil.copyProperties((Object)his, (Object)h, (String[])new String[0]);
            } else {
                String times;
                String string = times = h.getCreateTime() == null ? h.getTime() : h.getCreateTime();
                if (StringUtils.isNotEmpty((CharSequence)times)) {
                    LocalDateTime date;
                    if (h.getFlag() != null && h.getFlag().booleanValue()) {
                        StringBuilder sb;
                        if (times.split("-")[1].length() == 1) {
                            sb = new StringBuilder();
                            sb.append(times);
                            sb.insert(5, "0");
                            times = sb.toString();
                        }
                        if (times.split("-")[2].split(" ")[0].length() == 1) {
                            sb = new StringBuilder();
                            sb.append(times);
                            sb.insert(8, "0");
                            times = sb.toString();
                        }
                        if (times.split(":")[0].split(" ")[1].length() == 1) {
                            sb = new StringBuilder();
                            sb.append(times);
                            sb.insert(11, "0");
                            times = sb.toString();
                        }
                        if (times.split(":")[1].length() == 1) {
                            sb = new StringBuilder();
                            sb.append(times);
                            sb.insert(14, "0");
                            times = sb.toString();
                        }
                        if (times.split("-")[2].length() == 1) {
                            sb = new StringBuilder();
                            sb.append(times);
                            sb.insert(17, "0");
                            times = sb.toString();
                        }
                        date = LocalDateTime.parse(times, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    } else {
                        date = Instant.ofEpochMilli(Long.valueOf(times)).atZone(ZoneOffset.ofHours(8)).toLocalDateTime();
                    }
                    h.setTime(date.getYear() + "-" + (date.getMonthValue() > 9 ? Integer.valueOf(date.getMonthValue()) : "0" + date.getMonthValue()));
                    h.setPhotoTime(date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    if (h.getFlag() == null || !h.getFlag().booleanValue()) {
                        h.setType(2);
                    }
                } else {
                    h.setTime("");
                }
                hashOps.put((Object)h.getId(), h);
            }
        });
        hashOps.expire(30L, TimeUnit.MINUTES);
    }

    private List<HistoryImgVO> getHistoryImg(String wkt) {
        String sysToken = (String)this.redisUtil.get("history-accessToken");
        if (StringUtils.isBlank((CharSequence)sysToken)) {
            String tokenUrl = this.sysParamsService.getDetail("CLOUDQUERY", "gty-history-token").getValue();
            String cloudSecret = this.sysParamsService.getDetail("CLOUDQUERY", "gty-history-appsecret").getValue();
            String cloudKey = this.sysParamsService.getDetail("CLOUDQUERY", "gty-history-appkey").getValue();
            HttpRequest tokenPost = HttpUtil.createPost((String)tokenUrl);
            HashMap<String, String> tokenMap = new HashMap<String, String>();
            tokenMap.put("appKey", cloudKey);
            tokenMap.put("appSecret", cloudSecret);
            HttpResponse tokenExecute = tokenPost.body(JSON.toJSONString(tokenMap)).timeout(15000).execute();
            String tokenBody = tokenExecute.body();
            tokenBody = tokenBody.replaceAll("\n|\t", "");
            JSONObject tokenResult = JSONObject.parseObject((String)tokenBody);
            Integer tokenCode = tokenResult.getInteger("code");
            if (200 == tokenCode) {
                sysToken = tokenResult.getJSONObject("data").getString("accessToken");
                this.redisUtil.set("history-accessToken", (Object)sysToken, 7200L);
            } else {
                throw new RuntimeException(tokenResult.getString("msg"));
            }
        }
        String url = this.sysParamsService.getDetail("CLOUDQUERY", "gty-history-api").getValue();
        HttpRequest post = HttpUtil.createPost((String)url);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("buffer", 50);
        map.put("wkt", wkt);
        map.put("needSignUrl", 1);
        HttpResponse execute = ((HttpRequest)post.header("sysToken", sysToken)).body(JSON.toJSONString(map)).execute();
        String body = execute.body();
        String replace = body.replaceAll("\n|\t", "");
        JSONObject result = JSONObject.parseObject((String)replace);
        Integer code = result.getInteger("code");
        if (200 == code) {
            List jsonObjects = result.getJSONObject("data").getJSONArray("medias").toJavaList(JSONObject.class);
            return jsonObjects.stream().map(m -> HistoryImgVO.builder().id(m.getString("originid")).time(m.getString("photoTime").replaceAll("/", "-")).hash(m.getString("hashcode")).serverPath(m.getString("signServerPath")).viewUrl(m.getString("signServerPath").replace("?x-image-process=image/resize,w_140,limit_0", "")).azimuth(m.getString("azimuth")).fileType(m.getInteger("fileType")).latitude(m.getDouble("latitude")).longitude(m.getDouble("longitude")).userName(m.getString("rname")).bizName(m.getString("bizName")).flag(true).type(1).build()).collect(Collectors.toList());
        }
        return new ArrayList<HistoryImgVO>();
    }

    private List<HistoryImgVO> getHNHistoryImg(String wkt) {
        SysParamDTO config = this.sysParamsService.getDetail("CLOUDQUERY", "hngty-history-api");
        SysParamDTO imageConfig = this.sysParamsService.getDetail("CLOUDQUERY", "hngty-history-api-network");
        String url = config.getValue() + "jinaoApp/getFjGroupByWkt";
        String imageIp = imageConfig.getValue();
        String body = HttpUtil.createGet((String)url).form("secretKey", (Object)"JC916F96F487EA521144ED6D740A964D1DB65AF2").form("wkt", (Object)wkt).execute().body();
        try {
            JSONArray result = JSON.parseArray((String)body);
            List jsonObjects = result.toJavaList(JSONObject.class);
            return jsonObjects.stream().filter(m -> m.getString("serverPath") != null && !m.getString("serverPath").isEmpty() && !m.getString("serverPath").equals("null")).map(m -> HistoryImgVO.builder().id(IdUtil.simpleUUID()).time(m.getString("photoTime")).viewUrl(imageIp + m.getString("serverPath")).azimuth(m.getString("azimuth")).fileType(1).latitude(m.getDouble("latitude")).longitude(m.getDouble("longitude")).serverPath(imageIp + m.getString("serverPath")).userName(m.getString("psry")).bizName(m.getString("bizName")).flag(true).type(3).build()).collect(Collectors.toList());
        }
        catch (Exception e) {
            return new ArrayList<HistoryImgVO>();
        }
    }

    private void verify(HistoryImgDTO dto) throws Exception {
        if (StringUtils.isEmpty((CharSequence)dto.getWkt())) {
            throw new Exception("wkt\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)dto.getType())) {
            throw new Exception("\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

