/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.geoway.ns.geoserver3.service.IDTSPService;
import com.geoway.ns.geoserver3.service.IYZFXService;
import com.geoway.ns.smart.znts.entity.CloudQueryItemSj;
import com.geoway.ns.smart.znts.entity.CloudQueryPlan;
import com.geoway.ns.smart.znts.entity.CloudQueryPlanItem;
import com.geoway.ns.smart.znts.entity.CloudQueryPlanUser;
import com.geoway.ns.smart.znts.entity.CloudQueryRecord;
import com.geoway.ns.smart.znts.service.CloudQueryItemSjService;
import com.geoway.ns.smart.znts.service.CloudQueryPlanItemService;
import com.geoway.ns.smart.znts.service.CloudQueryPlanService;
import com.geoway.ns.smart.znts.service.CloudQueryPlanUserService;
import com.geoway.ns.smart.znts.service.CloudQueryRecordService;
import com.geoway.ns.smart.znts.service.ICloudQueryConfigService;
import com.geoway.ns.smart.znts.service.ProvincialCloudQueryService;
import com.geoway.ns.smart.znts.util.CloudQueryHttpUtil;
import com.geoway.ns.sys.dto.SimpleRole;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.enums.SysPowerEnum;
import com.geoway.ns.sys.exception.Code200Exception;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.service.SysPowerService;
import com.geoway.ns.sys.support.ServletUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ProvincialCloudQueryServiceImpl
implements ProvincialCloudQueryService {
    private static final Logger log = LoggerFactory.getLogger(ProvincialCloudQueryServiceImpl.class);
    @Resource
    private ITokenService tokenService;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Resource
    private CloudQueryItemSjService cloudQueryItemSjService;
    @Resource
    private CloudQueryHttpUtil cloudQueryHttpUtil;
    @Resource
    private CloudQueryRecordService cloudQueryRecordService;
    @Resource
    private CloudQueryPlanUserService cloudQueryPlanUserService;
    @Resource
    private CloudQueryPlanService cloudQueryPlanService;
    @Resource
    private CloudQueryPlanItemService cloudQueryPlanItemService;
    @Resource
    private IDTSPService dtspService;
    @Resource
    private IYZFXService yzfxService;
    @Resource
    private ICloudQueryConfigService cloudQueryConfigService;
    @Value(value="${cloud.query.defaultUserid:''}")
    private String defaultUserid;
    @Autowired
    private SysPowerService sysPowerService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String sendCloudQuery(Map<String, Object> params) throws Exception {
        List services;
        Assert.notEmpty(params, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject(params);
        String group = jsonObject.getString("group");
        JSONArray blocks = jsonObject.getJSONArray("Blocks");
        String wkt = null;
        if (!CollectionUtils.isEmpty((Collection)blocks)) {
            wkt = blocks.getJSONObject(0).getString("WKT");
        }
        List<CloudQueryItemSj> cloudQueryItems = this.cloudQueryItemSjService.getUserCloudQueryItems(userId, wkt, group, "");
        ArrayList serviceList = new ArrayList();
        if (!CollectionUtils.isEmpty(cloudQueryItems) && !CollectionUtils.isEmpty(services = cloudQueryItems.stream().map(CloudQueryItemSj::getServiceid).distinct().map(serviceId -> MapUtil.builder((Object)"serviceId", (Object)serviceId).build()).collect(Collectors.toList()))) {
            serviceList.addAll(services);
        }
        jsonObject.put("serviceList", serviceList);
        String serviceName = this.cloudQueryConfigService.getProvincialServiceName();
        com.alibaba.fastjson.JSONObject responseObj = this.dtspService.analysisExtention((Map)jsonObject, serviceName);
        String uniqueTaskId = responseObj.getString("UniqueTaskID");
        if (StringUtils.isBlank((CharSequence)uniqueTaskId)) {
            throw new RuntimeException("\u8c03\u7528\u4e91\u67e5\u8be2\u670d\u52a1\u5931\u8d25\uff01");
        }
        CloudQueryRecord cloudQueryRecord = CloudQueryRecord.builder().cloudId(uniqueTaskId).requestId(uniqueTaskId).userId(userId).param(jsonObject.toJSONString()).status(0).updateTime(new Date()).type(2).build();
        this.cloudQueryRecordService.saveRecord(cloudQueryRecord);
        return uniqueTaskId;
    }

    @Override
    public LinkedHashMap<String, List<CloudQueryItemSj>> getCloudQueryMeta() throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        List<CloudQueryItemSj> cloudQueryItems = this.cloudQueryItemSjService.getUserCloudQueryItems(userId, null, null, null);
        if (CollectionUtils.isEmpty(cloudQueryItems)) {
            throw new RuntimeException("\u4e91\u67e5\u8be2\u9879\u4e0d\u5b58\u5728\uff01");
        }
        cloudQueryItems = cloudQueryItems.stream().sorted(Comparator.comparing(CloudQueryItemSj::getOrder)).collect(Collectors.toList());
        LinkedHashMap tableNameMap = cloudQueryItems.stream().collect(Collectors.groupingBy(CloudQueryItemSj::getGrouptype, LinkedHashMap::new, Collectors.toList()));
        return tableNameMap;
    }

    @Override
    public JSONArray getCloudRuleMeta() throws Exception {
        String serviceName = this.cloudQueryConfigService.getProvincialServiceName();
        com.alibaba.fastjson.JSONObject responseObj = this.dtspService.queryRules(serviceName);
        return responseObj.getJSONArray("Results");
    }

    @Override
    public List<Map<String, Object>> getCloudQueryConfig() throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        String token = ServletUtils.getHeaderValues((String)"access_token");
        if (StringUtils.isNotEmpty((CharSequence)token) && token.equalsIgnoreCase("Geoway")) {
            userId = this.defaultUserid;
        } else {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        }
        return this.getCloudQueryConfig(null, userId);
    }

    @Override
    public List<Map<String, Object>> getCloudQueryConfig(String planId) throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        String token = ServletUtils.getHeaderValues((String)"access_token");
        if (StringUtils.isNotEmpty((CharSequence)token) && token.equalsIgnoreCase("Geoway")) {
            userId = this.defaultUserid;
        } else {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        }
        return this.getCloudQueryConfig(planId, userId);
    }

    public String getPlanIdByToken() {
        String token = ServletUtils.getHeaderValues((String)"access_token");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            SysUserDTO sysUser = null;
            try {
                sysUser = this.tokenService.querySysUserByToken(token);
                List lshs = this.sysPowerService.selectByToken(SysPowerEnum.ZNTS.value, sysUser.getRoles().stream().map(SimpleRole::getId).map(String::valueOf).collect(Collectors.toList()), sysUser.getId());
                List lhsIds = lshs.stream().map(sysPower -> sysPower.getMandateId()).collect(Collectors.toList());
                if (lhsIds.size() > 0) {
                    return (String)lhsIds.get(0);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getCloudQueryConfig(String planId, String userId) throws Exception {
        CloudQueryPlan plan = (CloudQueryPlan)this.cloudQueryPlanService.getById((Serializable)((Object)(planId = StringUtils.isBlank((CharSequence)planId) ? this.getPlanByUser(userId) : planId)));
        com.alibaba.fastjson.JSONObject responseObj = this.dtspService.findByName(plan.getServiceName());
        JSONArray config = responseObj.getJSONArray("Results");
        if (CollectionUtils.isEmpty((Collection)config)) {
            throw new RuntimeException("\u8c03\u7528\u67e5\u8be2\u7701\u7ea7\u4e91\u67e5\u8be2\u914d\u7f6e\u670d\u52a1\u5931\u8d25\uff01");
        }
        List<CloudQueryPlanItem> cloudQueryPlanItems = this.cloudQueryPlanItemService.queryByPlanIdAndType(planId, 2);
        if (CollectionUtils.isEmpty(cloudQueryPlanItems)) {
            return config.stream().map(item -> {
                com.alibaba.fastjson.JSONObject object = (com.alibaba.fastjson.JSONObject)item;
                List collect = object.getJSONArray("services").stream().sorted(Comparator.comparing(a -> ((com.alibaba.fastjson.JSONObject)a).getString("serviceAlias"))).collect(Collectors.toList());
                object.put("services", collect);
                return new HashMap(object);
            }).collect(Collectors.toList());
        }
        List hideServiceIds = cloudQueryPlanItems.stream().map(CloudQueryPlanItem::getItemId).collect(Collectors.toList());
        return config.stream().map(result -> {
            com.alibaba.fastjson.JSONObject resultObject = (com.alibaba.fastjson.JSONObject)result;
            JSONArray services = resultObject.getJSONArray("services");
            if (CollectionUtils.isEmpty((Collection)services)) {
                return null;
            }
            List serviceResults = services.stream().filter(service -> !hideServiceIds.contains(((com.alibaba.fastjson.JSONObject)service).getString("serviceId"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(serviceResults)) {
                return null;
            }
            return MapUtil.builder((Object)"services", serviceResults).put((Object)"groupType", (Object)resultObject.getString("groupType")).build();
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public JSONArray getCloudQueryInfo(String id, String serviceId) {
        com.alibaba.fastjson.JSONObject queryResults = this.dtspService.findResulByServiceId(id, serviceId);
        JSONArray results = queryResults.getJSONArray("Results");
        if (CollectionUtils.isEmpty((Collection)results)) {
            return results;
        }
        boolean isAllSuccess = results.stream().noneMatch(item -> {
            com.alibaba.fastjson.JSONObject object = (com.alibaba.fastjson.JSONObject)item;
            Integer status = object.getInteger("status");
            return status == null || status != 1;
        });
        if (isAllSuccess) {
            this.cloudQueryRecordService.updateRecordResultByCloudId(id, 1, results.toJSONString());
        }
        return results;
    }

    @Override
    public JSONObject getResultDetail(String requestId) {
        List<CloudQueryRecord> cloudQueryRecords = this.cloudQueryRecordService.selectSJCloudQueryByRequestId(requestId);
        if (CollectionUtils.isEmpty(cloudQueryRecords)) {
            throw new RuntimeException("\u4e91\u67e5\u8be2\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        com.alibaba.fastjson.JSONObject detail = new com.alibaba.fastjson.JSONObject();
        try {
            JSONObject jsonObject = new JSONObject();
            for (CloudQueryRecord cloudQuery : cloudQueryRecords) {
                boolean isAllSuccess;
                if (cloudQuery.getStatus() == 1 && StringUtils.isNotEmpty((CharSequence)cloudQuery.getResult())) {
                    com.alibaba.fastjson.JSONObject jsonObjectResult = JSON.parseObject((String)cloudQuery.getResult());
                    jsonObject.put((Object)cloudQuery.getTag(), (Object)jsonObjectResult);
                    continue;
                }
                com.alibaba.fastjson.JSONObject queryResults = this.dtspService.findResulByServiceId(cloudQuery.getCloudId(), null);
                JSONArray results = queryResults.getJSONArray("Results");
                com.alibaba.fastjson.JSONObject imageResponseObj = this.dtspService.findImageByServiceId(cloudQuery.getCloudId(), null);
                JSONArray imageResults = imageResponseObj.getJSONArray("Results");
                JSONObject Items = new JSONObject();
                for (int i = 0; i < results.size(); ++i) {
                    com.alibaba.fastjson.JSONObject result = results.getJSONObject(i);
                    com.alibaba.fastjson.JSONObject dtspResult = result.getJSONObject("result");
                    this.setImage(dtspResult, imageResults);
                    Items.put((Object)result.getString("serviceName"), (Object)dtspResult);
                }
                if ((cloudQuery.getStatus() == 0 || cloudQuery.getStatus() == null) && (isAllSuccess = results.stream().noneMatch(item -> {
                    com.alibaba.fastjson.JSONObject object = (com.alibaba.fastjson.JSONObject)item;
                    Integer status = object.getInteger("status");
                    return status == null || status != 1;
                }))) {
                    cloudQuery.setStatus(1);
                    cloudQuery.setResult(Items.toString());
                    this.cloudQueryRecordService.saveOrUpdate(cloudQuery);
                }
                jsonObject.put((Object)cloudQuery.getTag(), (Object)Items);
            }
            return jsonObject;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void setImage(com.alibaba.fastjson.JSONObject dtspResult, JSONArray imageResults) {
        if (imageResults == null) {
            return;
        }
        String serviceId = dtspResult.getString("serviceId");
        for (int j = 0; j < imageResults.size(); ++j) {
            com.alibaba.fastjson.JSONObject imageResult = imageResults.getJSONObject(j);
            if (!Objects.equals(serviceId, imageResult.getString("serviceId"))) continue;
            if (imageResult.getString("image") != null) {
                dtspResult.put("imgString", (Object)JSON.parseObject((String)imageResult.getString("image")));
            }
            return;
        }
    }

    @Override
    public com.alibaba.fastjson.JSONObject getRuleResultDetail(String ruleId) {
        return this.dtspService.findRuleResultByTaskId(ruleId, this.cloudQueryConfigService.getProvincialDtspId());
    }

    @Override
    public void updateCloudQueryConfig(String planId) {
        CloudQueryPlan plan = (CloudQueryPlan)this.cloudQueryPlanService.getById((Serializable)((Object)planId));
        com.alibaba.fastjson.JSONObject responseObj = this.dtspService.findByName(plan.getServiceName());
        JSONArray results = responseObj.getJSONArray("Results");
        if (CollectionUtils.isEmpty((Collection)results)) {
            return;
        }
        List<CloudQueryItemSj> allCloudQueryItemSj = this.cloudQueryItemSjService.queryByDtsp(plan.getDtspId());
        ArrayList cloudQueryItems = new ArrayList();
        for (Object result : results) {
            com.alibaba.fastjson.JSONObject resultObject = (com.alibaba.fastjson.JSONObject)result;
            JSONArray services = resultObject.getJSONArray("services");
            if (CollectionUtils.isEmpty((Collection)services)) continue;
            List byServices = services.stream().map(service -> {
                com.alibaba.fastjson.JSONObject serviceObject = (com.alibaba.fastjson.JSONObject)service;
                CloudQueryItemSj cloudQueryItemSj = allCloudQueryItemSj.stream().filter(s -> s.getGrouptype().equalsIgnoreCase(serviceObject.getString("groupType")) && s.getServiceid().equalsIgnoreCase(serviceObject.getString("serviceId")) && s.getServicename().equalsIgnoreCase(serviceObject.getString("serviceName"))).findFirst().orElse(null);
                if (cloudQueryItemSj == null) {
                    cloudQueryItemSj = CloudQueryItemSj.builder().id(serviceObject.getString("id")).dtspid(serviceObject.getString("dtspId")).serviceid(serviceObject.getString("serviceId")).enable(serviceObject.getInteger("enable")).servicealias(serviceObject.getString("serviceAlias")).servicename(serviceObject.getString("serviceName")).grouptype(serviceObject.getString("groupType")).layers(serviceObject.getJSONArray("layers").toJSONString()).chartdata(serviceObject.getString("chartData")).chartlayout(serviceObject.getString("chartLayout")).charttype(serviceObject.getString("chartType")).serviceinfo(serviceObject.getJSONObject("serviceInfo").toJSONString()).versions(serviceObject.containsKey((Object)"versions") ? (serviceObject.getJSONArray("versions") != null ? serviceObject.getJSONArray("versions").toJSONString() : null) : null).extention(serviceObject.getString("extention")).order(serviceObject.getInteger("order")).defaultyear(serviceObject.getInteger("defaultYear")).build();
                } else {
                    allCloudQueryItemSj.remove(cloudQueryItemSj);
                    cloudQueryItemSj.setDtspid(serviceObject.getString("dtspId"));
                    cloudQueryItemSj.setEnable(serviceObject.getInteger("enable"));
                    cloudQueryItemSj.setServicealias(serviceObject.getString("serviceAlias"));
                    cloudQueryItemSj.setLayers(serviceObject.getJSONArray("layers").toJSONString());
                    cloudQueryItemSj.setChartdata(serviceObject.getString("chartData"));
                    cloudQueryItemSj.setChartlayout(serviceObject.getString("chartLayout"));
                    cloudQueryItemSj.setChartdata(serviceObject.getString("chartData"));
                    cloudQueryItemSj.setCharttype(serviceObject.getString("chartType"));
                    cloudQueryItemSj.setServiceinfo(serviceObject.getJSONObject("serviceInfo").toJSONString());
                    cloudQueryItemSj.setVersions(serviceObject.containsKey((Object)"versions") ? (serviceObject.getJSONArray("versions") != null ? serviceObject.getJSONArray("versions").toJSONString() : null) : null);
                    cloudQueryItemSj.setExtention(serviceObject.getString("extention"));
                    cloudQueryItemSj.setDefaultyear(serviceObject.getInteger("defaultYear"));
                    cloudQueryItemSj.setInfo(serviceObject.getString("info"));
                }
                return cloudQueryItemSj;
            }).collect(Collectors.toList());
            cloudQueryItems.addAll(byServices);
        }
        this.cloudQueryItemSjService.removeByIds(allCloudQueryItemSj);
        this.cloudQueryItemSjService.saveOrUpdateBatch(cloudQueryItems);
    }

    @Override
    public com.alibaba.fastjson.JSONObject resetCloudQuery(String id, String serviceId) {
        String serviceName = this.cloudQueryConfigService.getProvincialServiceName();
        return this.dtspService.resetAnalysisExtention(serviceName, id, serviceId);
    }

    @Override
    public JSONArray getProvincialImages(String id, String serviceId) {
        com.alibaba.fastjson.JSONObject responseObj = this.dtspService.findImageByServiceId(id, serviceId);
        JSONArray images = responseObj.getJSONArray("Results");
        if (CollectionUtils.isEmpty((Collection)images)) {
            return images;
        }
        List result = images.stream().filter(item -> {
            com.alibaba.fastjson.JSONObject image = (com.alibaba.fastjson.JSONObject)images.get(0);
            Integer imageStatus = image.getInteger("imageStatus");
            return imageStatus != null && imageStatus == 1;
        }).collect(Collectors.toList());
        return new JSONArray(result);
    }

    @Override
    public Map<String, Object> statisticsByServiceName(String serviceName, String serviceId, String analysisResult) {
        com.alibaba.fastjson.JSONObject chartData = null;
        String cacheChartKey = "dtspChart";
        String httpServiceId = serviceId;
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)cacheChartKey))) {
            chartData = (com.alibaba.fastjson.JSONObject)this.redisTemplate.boundHashOps((Object)cacheChartKey).get((Object)serviceName);
        } else {
            if (StringUtils.isBlank((CharSequence)httpServiceId)) {
                httpServiceId = this.cloudQueryConfigService.getProvincialServiceId();
            }
            com.alibaba.fastjson.JSONObject responseResults = this.dtspService.findResultById(httpServiceId);
            String errorQueryEmpty = "\u6839\u636e" + httpServiceId + "\u83b7\u53d6\u7701\u7ea7\u4e91\u67e5\u8be2\u914d\u7f6e\u4e3a\u7a7a\uff01";
            if (MapUtil.isEmpty((Map)responseResults)) {
                throw new Code200Exception(errorQueryEmpty);
            }
            JSONArray responseServices = responseResults.getJSONArray("services");
            if (CollectionUtils.isEmpty((Map)responseResults)) {
                throw new Code200Exception(errorQueryEmpty);
            }
            HashMap<String, com.alibaba.fastjson.JSONObject> result = new HashMap<String, com.alibaba.fastjson.JSONObject>();
            for (Object service : responseServices) {
                com.alibaba.fastjson.JSONObject serviceObject = (com.alibaba.fastjson.JSONObject)service;
                com.alibaba.fastjson.JSONObject serviceInfo = serviceObject.getJSONObject("serviceInfo");
                String name = serviceInfo.getString("name");
                com.alibaba.fastjson.JSONObject data = serviceObject.getJSONObject("chartData");
                result.put(name, data);
                if (!name.equals(serviceName)) continue;
                chartData = data;
                log.info(serviceName + " chartData:" + JSON.toJSONString((Object)chartData));
            }
            BoundHashOperations boundHashOperations = this.redisTemplate.boundHashOps((Object)cacheChartKey);
            boundHashOperations.putAll(result);
            boundHashOperations.expire(10L, TimeUnit.MINUTES);
        }
        com.alibaba.fastjson.JSONObject testChartDataSD = JSON.parseObject((String)"{\"tableConfig\":{\"tableType\":\"Common\",\"tableColumn\":[{\"type\":\"index\",\"label\":\"\u5e8f\u53f7\",\"align\":\"center\",\"width\":\"60\"},{\"prop\":\"DLMC\",\"label\":\"\u5730\u7c7b\u540d\u79f0\",\"align\":\"center\"},{\"prop\":\"QSXZ\",\"label\":\"\u6743\u5c5e\u6027\u8d28\",\"align\":\"center\"},{\"prop\":\"QSDWMC\",\"label\":\"\u6743\u5c5e\u5355\u4f4d\u540d\u79f0\",\"align\":\"center\"},{\"prop\":\"YZMJ\",\"label\":\"\u538b\u5360\u9762\u79ef\",\"align\":\"right\",\"headerAlign\":\"center\"},{\"prop\":\"YZKCMJ\",\"label\":\"\u538b\u5360\u6263\u9664\u9762\u79ef\",\"align\":\"right\",\"headerAlign\":\"center\"}],\"numberField\":[{\"name\":\"YZMJ\",\"format\":2},{\"name\":\"YZKCMJ\",\"format\":2}]},\"StatTableConfig\":{\"tableType\":\"SDDLFX\",\"tableColumn\":[],\"numberField\":[{\"name\":\"YZMJ\",\"format\":2}],\"mergeColumn\":[],\"groupByField\":[],\"statField\":[\"\"],\"amountType\":1}}");
        com.alibaba.fastjson.JSONObject testChartDataCommon = JSON.parseObject((String)"{\"tableConfig\":{\"tableType\":\"Common\",\"tableColumn\":[{\"type\":\"index\",\"label\":\"\u5e8f\u53f7\",\"align\":\"center\",\"width\":\"60\"},{\"prop\":\"GZQLXDM\",\"label\":\"\u7ba1\u5236\u533a\u7c7b\u578b\u4ee3\u7801\",\"align\":\"right\",\"headerAlign\":\"center\"},{\"prop\":\"YZMJ\",\"label\":\"\u9762\u79ef\uff08m\u00b2\uff09\",\"align\":\"right\",\"headerAlign\":\"center\"}],\"numberField\":[{\"name\":\"YZMJ\",\"format\":2}]},\"StatTableConfig\":{\"tableType\":\"CommonStat\",\"tableColumn\":[{\"prop\":\"GZQLXDM\",\"label\":\"\u7ba1\u5236\u533a\u7c7b\u578b\u4ee3\u7801\",\"align\":\"right\",\"headerAlign\":\"center\"},{\"prop\":\"YZMJ\",\"label\":\"\u9762\u79ef\uff08m\u00b2\uff09\",\"align\":\"right\",\"headerAlign\":\"center\"}],\"numberField\":[{\"name\":\"YZMJ\",\"format\":2}],\"mergeColumn\":[\"GZQLXDM\"],\"groupByField\":[\"GZQLXDM\"],\"statField\":[\"YZMJ\"],\"amountType\":2}}");
        if (chartData == null) {
            throw new Code200Exception("\u672a\u627e\u5230" + serviceName + "\u914d\u7f6e\uff1ahttpServiceId = " + httpServiceId);
        }
        if (chartData.getJSONObject("StatTableConfig") != null && chartData.getJSONObject("StatTableConfig").getString("tableType") != null && (chartData.getJSONObject("StatTableConfig").getString("tableType").equals("DLFX") || chartData.getJSONObject("StatTableConfig").getString("tableType").equals("SDDLFX"))) {
            return this.dataManages(serviceName, analysisResult);
        }
        return this.dataManage(analysisResult, chartData);
    }

    private Map dataManage(String analysisResult, com.alibaba.fastjson.JSONObject chartData) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String statisFiled = "";
        JSONArray array = com.alibaba.fastjson.JSONObject.parseArray((String)analysisResult);
        List<com.alibaba.fastjson.JSONObject> dataList = array.toJavaList(com.alibaba.fastjson.JSONObject.class);
        com.alibaba.fastjson.JSONObject statTableConfig = chartData.getJSONObject("StatTableConfig");
        JSONArray tableColumn = statTableConfig.getJSONArray("tableColumn");
        int index = tableColumn.size() - 1;
        dataList = dataList.stream().map(m -> {
            com.alibaba.fastjson.JSONObject object = new com.alibaba.fastjson.JSONObject();
            for (int i = 0; i < tableColumn.size(); ++i) {
                com.alibaba.fastjson.JSONObject jsonObject = tableColumn.getJSONObject(i);
                String prop = jsonObject.getString("prop");
                object.put(prop, m.get((Object)prop));
            }
            return object;
        }).collect(Collectors.toList());
        if (tableColumn.size() > 0) {
            com.alibaba.fastjson.JSONObject jsonObject = tableColumn.getJSONObject(index);
            statisFiled = jsonObject.getString("prop");
            for (int i = index - 1; i >= 0; --i) {
                Boolean flag = i != index - 1;
                com.alibaba.fastjson.JSONObject colum = tableColumn.getJSONObject(i);
                String prop = colum.getString("prop");
                dataList = this.manages(prop, statisFiled, dataList, flag);
            }
        } else {
            log.error("\u914d\u7f6etableColumn\u4e0d\u80fd\u4e3a\u7a7a");
        }
        map.put("tableCulom", tableColumn);
        map.put("table", dataList);
        return map;
    }

    private List<com.alibaba.fastjson.JSONObject> manages(String prop, String statisFiled, List<com.alibaba.fastjson.JSONObject> dataList, Boolean flag) {
        HashMap<String, com.alibaba.fastjson.JSONObject> map = new HashMap<String, com.alibaba.fastjson.JSONObject>();
        for (com.alibaba.fastjson.JSONObject f : dataList) {
            String key = f.getString(prop);
            Double aDouble = f.getDouble(statisFiled);
            if (map.containsKey(key)) {
                com.alibaba.fastjson.JSONObject mapJson = (com.alibaba.fastjson.JSONObject)map.get(key);
                String mapProp = mapJson.getString(prop);
                if (!key.equals(mapProp)) continue;
                Double mapJsonDouble = mapJson.getDouble(statisFiled);
                mapJson.put(statisFiled, (Object)(mapJsonDouble + aDouble));
                continue;
            }
            com.alibaba.fastjson.JSONObject object = new com.alibaba.fastjson.JSONObject();
            BeanUtil.copyProperties((Object)f, (Object)object, (String[])new String[0]);
            if (flag.booleanValue()) {
                object.put("children", dataList);
            }
            object.put("label", (Object)prop);
            map.put(key, object);
        }
        List<com.alibaba.fastjson.JSONObject> collect = map.values().stream().collect(Collectors.toList());
        return collect;
    }

    private Map dataManages(String serviceName, String analysisResult) {
        HashMap<String, JSONArray> result = new HashMap<String, JSONArray>();
        String tableCulom = "[{\"prop\":\"SDLMC\",\"label\":\"\u5730\u5757\u5927\u7c7b\"},{\"prop\":\"YJLMC\",\"label\":\"\u4e00\u7ea7\u7c7b\"},{\"prop\":\"DLMC\",\"label\":\"\u4e8c\u7ea7\u7c7b\"},{\"prop\":\"YZMJ\",\"label\":\"\u538b\u5360\u9762\u79ef\uff08m\u00b2\uff09\"}]";
        result.put("tableCulom", JSON.parseArray((String)tableCulom));
        if (analysisResult != null && !analysisResult.isEmpty() && !analysisResult.equals("[]")) {
            com.alibaba.fastjson.JSONObject responseObj = this.yzfxService.statByResult(serviceName, analysisResult);
            com.alibaba.fastjson.JSONObject object = responseObj.getJSONObject("Results");
            log.info("dataManages getProvincialLandStatistics:" + object.toJSONString());
            JSONArray results = object.getJSONArray("SDLStat");
            for (int i = 0; i < results.size(); ++i) {
                com.alibaba.fastjson.JSONObject jsonObject = results.getJSONObject(i);
                if (0.0 == jsonObject.getDouble("YZMJ")) {
                    results.remove(i);
                    --i;
                    continue;
                }
                JSONArray manages = this.manages(jsonObject.getJSONArray("YJLStat"), "\u4e00\u7ea7\u7c7b", "YJL");
                jsonObject.put("children", (Object)manages);
                jsonObject.put("label", (Object)"DKDL");
                jsonObject.remove((Object)"YJLStat");
            }
            result.put("table", results);
        } else {
            result.put("table", new JSONArray());
        }
        return result;
    }

    private JSONArray manages(JSONArray array, String label, String key) {
        for (int i = 0; i < array.size(); ++i) {
            com.alibaba.fastjson.JSONObject jsonObject = array.getJSONObject(i);
            if (0.0 == jsonObject.getDouble("YZMJ")) {
                array.remove(i);
                --i;
                continue;
            }
            if (jsonObject.getJSONArray("EJLStat") != null) {
                JSONArray manages = this.manages(jsonObject.getJSONArray("EJLStat"), "\u4e8c\u7ea7\u7c7b", "DLMC");
                jsonObject.put("children", (Object)manages);
            }
            jsonObject.put("label", (Object)key);
            jsonObject.remove((Object)"EJLStat");
        }
        return array;
    }

    @Override
    @Transactional
    public Map<String, Integer> getRecordStateByRequestIds(List<String> listRequestIds) throws Exception {
        if (listRequestIds.isEmpty()) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String requestId : listRequestIds) {
            List<CloudQueryRecord> cloudQueries = this.cloudQueryRecordService.selectSJCloudQueryByRequestId(requestId);
            for (CloudQueryRecord unFinshed : cloudQueries) {
                if (unFinshed != null) {
                    if (unFinshed.getStatus() != null && unFinshed.getStatus() != 0) continue;
                    com.alibaba.fastjson.JSONObject result = this.dtspService.findStatusByTaskId(unFinshed.getCloudId());
                    if (result == null) {
                        map.put(unFinshed.getCloudId(), -1);
                        continue;
                    }
                    JSONArray arr = result.getJSONArray("Results");
                    for (int i = 0; i < arr.size(); ++i) {
                        com.alibaba.fastjson.JSONObject job = arr.getJSONObject(i);
                        String serviceId = job.getString("serviceId");
                        String requestid = unFinshed.getCloudId();
                        String id = job.getString("id");
                        int state = job.getIntValue("status");
                        if (map.containsKey(requestid)) {
                            Integer integer = (Integer)map.get(requestid);
                            if (integer < 0) {
                                map.put(requestid, -1);
                            } else if (state == 1 || state == 2) {
                                map.put(requestid, 1);
                            } else {
                                map.put(requestid, -1);
                            }
                        } else if (state == 1 || state == 2) {
                            map.put(requestid, 1);
                        } else {
                            map.put(requestid, -1);
                        }
                        unFinshed.setStatus(state);
                        unFinshed.setUpdateTime(new Date());
                        this.cloudQueryRecordService.saveOrUpdate(unFinshed);
                    }
                    continue;
                }
                for (CloudQueryRecord cloudQuery : cloudQueries) {
                    if (map.containsKey(cloudQuery.getCloudId())) {
                        Integer integer = (Integer)map.get(cloudQuery.getCloudId());
                        if (integer < 0) {
                            map.put(cloudQuery.getCloudId(), -1);
                            continue;
                        }
                        if (cloudQuery.getStatus() == 1 || cloudQuery.getStatus() == 2) {
                            map.put(cloudQuery.getCloudId(), 1);
                            continue;
                        }
                        map.put(cloudQuery.getCloudId(), -1);
                        continue;
                    }
                    if (cloudQuery.getStatus() == 1 || cloudQuery.getStatus() == 2) {
                        map.put(cloudQuery.getCloudId(), 1);
                        continue;
                    }
                    map.put(cloudQuery.getCloudId(), -1);
                }
            }
        }
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String sendCloudRule(Map<String, Object> params) throws Exception {
        List services;
        Assert.notEmpty(params, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject(params);
        JSONArray blocks = jsonObject.getJSONArray("Blocks");
        String wkt = null;
        if (!CollectionUtils.isEmpty((Collection)blocks)) {
            wkt = blocks.getJSONObject(0).getString("WKT");
        }
        List<CloudQueryItemSj> cloudQueryItems = this.cloudQueryItemSjService.getUserCloudQueryItems(userId, wkt, "", "");
        ArrayList serviceList = new ArrayList();
        if (!CollectionUtils.isEmpty(cloudQueryItems) && !CollectionUtils.isEmpty(services = cloudQueryItems.stream().map(CloudQueryItemSj::getServiceid).distinct().map(serviceId -> MapUtil.builder((Object)"serviceId", (Object)serviceId).build()).collect(Collectors.toList()))) {
            serviceList.addAll(services);
        }
        jsonObject.put("serviceList", serviceList);
        String serviceName = this.cloudQueryConfigService.getProvincialServiceName();
        com.alibaba.fastjson.JSONObject responseObj = this.dtspService.analysisExtention((Map)jsonObject, serviceName);
        String uniqueTaskId = responseObj.getString("UniqueTaskID");
        if (StringUtils.isBlank((CharSequence)uniqueTaskId)) {
            throw new RuntimeException("\u8c03\u7528\u4e91\u67e5\u8be2\u670d\u52a1\u5931\u8d25\uff01");
        }
        CloudQueryRecord cloudQueryRecord = CloudQueryRecord.builder().cloudId(uniqueTaskId).requestId(uniqueTaskId).userId(userId).param(jsonObject.toJSONString()).status(0).updateTime(new Date()).type(2).build();
        this.cloudQueryRecordService.saveRecord(cloudQueryRecord);
        return uniqueTaskId;
    }

    private String getPlanByUser(String userId) {
        String planId;
        CloudQueryPlanUser planUser = this.cloudQueryPlanUserService.getByUserId(userId);
        if (planUser != null) {
            planId = planUser.getPlanId();
        } else {
            planId = this.getPlanIdByToken();
            if (StringUtils.isBlank((CharSequence)planId)) {
                CloudQueryPlan cloudQueryPlan = this.cloudQueryPlanService.queryDefault();
                if (cloudQueryPlan == null) {
                    throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u4e91\u67e5\u8be2\u8ba1\u5212\uff01");
                }
                planId = cloudQueryPlan.getId();
            }
        }
        return planId;
    }
}

